/*-
 * sigFromHost.c --
 *	Map a host specific signal number to a SIGNAL_ value
 *
 * Copyright (c) 1982 Regents of the University of California.
 * Copyright (c) 1992 by Andreas Stolcke
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * and Andreas Stolcke make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 */
#ifndef lint
static char *rcsid =
"$Id: sigFromHost.c,v 1.1 1994/05/18 17:56:45 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    "customs.h"

extern struct signal {
    int	signo;			/* OS specific signal number */
    char *name;			/* short signal name */
} signalList[];

/*-
 *-----------------------------------------------------------------------
 * Signal_FromHost --
 *	Map a host specific signal number to a SIGNAL_ value.
 *
 * Results:
 *	The SIGNAL_ value.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
int
Signal_FromHost (signo)
    int	    	 signo;
{
    int signal;

    for (signal = 0; signal < SIGNAL_INVAL; signal++) {
	if (signalList[signal].signo == signo) {
	    break;
	}
    }
    return (signal);
}

