/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2002 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks.h
 */

/* callbacks for the main window */
#include "callbacks_menu.h"
#include "callbacks_toolbar.h"
#include "callbacks_qsoframe.h"
#include "callbacks_clist.h"
#include "callbacks_mainwindow.h"

/* callbacks generated by glade for all the dialogs */

/* about dialog */
void on_aboutbutton_clicked(GtkButton *button, gpointer user_data);

/* setup dialog */
void on_setupbutton_clicked (GtkButton *button, gpointer user_data);
gboolean on_setupdialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);

/* save dialog */
void on_saveokbutton_clicked(GtkButton *button, gpointer user_data);
void on_savecancelbutton_clicked(GtkButton *button, gpointer user_data);
gboolean on_savedialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);

/* preferences dialog */
void on_preferencesokbutton_clicked(GtkButton *button, gpointer user_data);
void on_preferencescancelbutton_clicked(GtkButton *button, gpointer user_data);
gboolean on_preferencesdialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_bandsradiobutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_modesradiobutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_hamlibcheckbutton_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_themebutton_clicked(GtkButton *button, gpointer user_data);
void on_pathbutton_clicked(GtkButton *button, gpointer user_data);

/* print dialog */
void on_printokbutton_clicked(GtkButton *button, gpointer user_data);
void on_printcancelbutton_clicked(GtkButton *button, gpointer user_data);
gboolean on_printdialog_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_printradiobutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);

/* search dialog */
void on_searchokbutton_clicked(GtkButton *button, gpointer user_data);
void on_searchcancelbutton_clicked(GtkButton *button, gpointer user_data);
gboolean on_searchdialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);

/* search result dialog */
void on_searchresultokbutton_clicked(GtkButton *button, gpointer user_data);
void on_searchresultclist_select_row(GtkCList *clist, gint row, gint column, GdkEvent *event, gpointer user_data);

/* color selection dialog */
void on_colorokbutton_clicked(GtkButton *button, gpointer user_data);
void on_colorcancelbutton_clicked(GtkButton *button, gpointer user_data);
gboolean on_colorselectiondialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);

/* new log dialog */
void on_newlogokbutton_clicked(GtkButton *button, gpointer user_data);
void on_newlogcancelbutton_clicked(GtkButton *button, gpointer user_data);
gboolean on_newlogdialog_delete_event(GtkWidget  *widget, GdkEvent *event, gpointer user_data);

/* file selection dialog */
gboolean on_fileselection_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_fileselection_ok_button_clicked(GtkButton *button, gpointer user_data);
void on_fileselection_cancel_button_clicked(GtkButton *button, gpointer  user_data);

/* path selection dialog */
gboolean on_pathselection_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_pathselection_ok_button_clicked(GtkButton *button, gpointer user_data);
void on_pathselection_cancel_button_clicked (GtkButton *button, gpointer user_data);

/* close dialog */
gboolean on_closedialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_closeokbutton_clicked(GtkButton *button, gpointer user_data);
void on_closecancelbutton_clicked(GtkButton *button, gpointer user_data);

/* end of file */

void
on_logeditorokbutton_clicked           (GtkButton       *button,
                                        gpointer         user_data);

void
on_logeditorcancelbutton_clicked       (GtkButton       *button,
                                        gpointer         user_data);

gboolean
on_logeditorwindow_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_menu_logeditor_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data);


void
on_menu_import_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

