/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;
import sun.security.x509.AVAComparator;
import sun.security.x509.X500Name;

class RDN
implements Cloneable {
    protected AVA[] assertion;

    RDN(String string) throws IOException {
        AVA aVA;
        String string2;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Vector vector = new Vector(3);
        int n5 = string.indexOf(43);
        while (n5 >= 0) {
            if (n5 > 0 && string.charAt(n5 - 1) != '\\' && (n2 += X500Name.countQuotes(string, n3, n5)) != 1) {
                string2 = string.substring(n4, n5).trim();
                if (string2.length() == 0) {
                    throw new IOException("empty AVA in RDN \"" + string + "\"");
                }
                aVA = new AVA(new StringReader(string2));
                vector.addElement(aVA);
                n4 = n5 + 1;
                n2 = 0;
            }
            n3 = n5 + 1;
            n5 = string.indexOf(43, n3);
        }
        string2 = string.substring(n4).trim();
        if (string2.length() == 0) {
            throw new IOException("empty AVA in RDN \"" + string + "\"");
        }
        aVA = new AVA(new StringReader(string2));
        vector.addElement(aVA);
        this.assertion = (AVA[])vector.toArray(new AVA[vector.size()]);
    }

    RDN(String string, String string2) throws IOException {
        AVA aVA;
        String string3;
        if (!string2.equalsIgnoreCase("RFC2253")) {
            throw new IOException("Unsupported format " + string2);
        }
        int n2 = 0;
        int n3 = 0;
        Vector vector = new Vector(3);
        int n4 = string.indexOf(43);
        while (n4 >= 0) {
            if (n4 > 0 && string.charAt(n4 - 1) != '\\') {
                string3 = string.substring(n3, n4);
                if (string3.length() == 0) {
                    throw new IOException("empty AVA in RDN \"" + string + "\"");
                }
                aVA = new AVA(new StringReader(string3), 3);
                vector.addElement(aVA);
                n3 = n4 + 1;
            }
            n2 = n4 + 1;
            n4 = string.indexOf(43, n2);
        }
        string3 = string.substring(n3);
        if (string3.length() == 0) {
            throw new IOException("empty AVA in RDN \"" + string + "\"");
        }
        aVA = new AVA(new StringReader(string3), 3);
        vector.addElement(aVA);
        this.assertion = (AVA[])vector.toArray(new AVA[vector.size()]);
    }

    RDN(DerValue derValue) throws IOException {
        if (derValue.tag != 49) {
            throw new IOException("X500 RDN");
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSet(5);
        this.assertion = new AVA[derValueArray.length];
        int n2 = 0;
        while (n2 < derValueArray.length) {
            this.assertion[n2] = new AVA(derValueArray[n2]);
            ++n2;
        }
    }

    RDN(int n2) {
        this.assertion = new AVA[n2];
    }

    public boolean equals(Object object) {
        if (object instanceof RDN) {
            return this.equals((RDN)object);
        }
        return false;
    }

    public boolean equals(RDN rDN) {
        if (rDN == null) {
            return false;
        }
        if (rDN == this) {
            return true;
        }
        if (this.assertion.length != rDN.assertion.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.assertion.length) {
            int n3 = 0;
            while (n3 < rDN.assertion.length) {
                if (this.assertion[n2].equals(rDN.assertion[n3])) break;
                ++n3;
            }
            if (n3 == rDN.assertion.length) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.assertion.length) {
            if (this.assertion[n4].value != null) {
                n2 += this.assertion[n4].value.length() * n3++;
            }
            ++n4;
        }
        return n2;
    }

    DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        int n2 = 0;
        while (n2 < this.assertion.length) {
            if (this.assertion[n2].oid.equals(objectIdentifier)) {
                return this.assertion[n2].value;
            }
            ++n2;
        }
        return null;
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOrderedSetOf((byte)49, this.assertion);
    }

    public String toString() {
        String string = null;
        int n2 = 0;
        while (n2 < this.assertion.length) {
            string = string == null ? this.assertion[n2].toString() : string + " + " + this.assertion[n2];
            ++n2;
        }
        return string;
    }

    public String toRFC1779String() {
        String string = null;
        int n2 = 0;
        while (n2 < this.assertion.length) {
            string = string == null ? this.assertion[n2].toRFC1779String() : string + " + " + this.assertion[n2];
            ++n2;
        }
        return string;
    }

    public String toRFC2253String() {
        return this.toRFC2253String(false);
    }

    public String toRFC2253String(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl2) {
            int n2 = 0;
            while (n2 < this.assertion.length) {
                if (n2 > 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(this.assertion[n2].toRFC2253String());
                ++n2;
            }
        } else {
            LinkedList linkedList = new LinkedList();
            int n3 = 0;
            while (n3 < this.assertion.length) {
                linkedList.add(this.assertion[n3]);
                ++n3;
            }
            Collections.sort(linkedList, new AVAComparator());
            int n4 = 0;
            while (n4 < linkedList.size()) {
                if (n4 > 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(((AVA)linkedList.get(n4)).toRFC2253CanonicalString());
                ++n4;
            }
        }
        return new String(stringBuffer);
    }

    public Object clone() {
        try {
            return new RDN(this.toString());
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

