/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.Certificate;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signer;

public class SystemSigner
extends Signer {
    private static final long serialVersionUID = -2127743304301557711L;
    private boolean trusted = false;

    public SystemSigner(String string) {
        super(string);
    }

    public SystemSigner(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }

    void setTrusted(boolean bl2) {
        this.trusted = bl2;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    void setSignerKeyPair(KeyPair keyPair) throws InvalidParameterException, KeyException {
        this.setKeyPair(keyPair);
    }

    PrivateKey getSignerPrivateKey() {
        return this.getPrivateKey();
    }

    void setSignerInfo(String string) {
        this.setInfo(string);
    }

    void addSignerCertificate(Certificate certificate) throws KeyManagementException {
        this.addCertificate(certificate);
    }

    void clearCertificates() throws KeyManagementException {
        Certificate[] certificateArray = this.certificates();
        int n2 = 0;
        while (n2 < certificateArray.length) {
            this.removeCertificate(certificateArray[n2]);
            ++n2;
        }
    }

    public String toString() {
        String string = "not trusted";
        if (this.trusted) {
            string = "trusted";
        }
        return super.toString() + "[" + string + "]";
    }
}

