/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.LoginUtility;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public class Krb5InitCredential
extends KerberosTicket
implements Krb5CredElement {
    private static Class TICKET_CLASS;
    private Krb5NameElement name;
    private Credentials krb5Credentials;

    private Krb5InitCredential(Krb5NameElement krb5NameElement, byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws GSSException {
        super(byArray, kerberosPrincipal, kerberosPrincipal2, byArray2, n2, blArray, date, date2, date3, date4, inetAddressArray);
        this.name = krb5NameElement;
        try {
            this.krb5Credentials = new Credentials(byArray, kerberosPrincipal.getName(), kerberosPrincipal2.getName(), byArray2, n2, blArray, date, date2, date3, date4, inetAddressArray);
        }
        catch (KrbException krbException) {
            throw new GSSException(13, -1, krbException.getMessage());
        }
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.getMessage());
        }
    }

    private Krb5InitCredential(Krb5NameElement krb5NameElement, Credentials credentials, byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws GSSException {
        super(byArray, kerberosPrincipal, kerberosPrincipal2, byArray2, n2, blArray, date, date2, date3, date4, inetAddressArray);
        this.name = krb5NameElement;
        this.krb5Credentials = credentials;
    }

    static Krb5InitCredential getInstance(Krb5NameElement krb5NameElement, int n2) throws GSSException {
        KerberosTicket kerberosTicket = Krb5InitCredential.getTgtFromSubject(krb5NameElement, n2);
        if (kerberosTicket == null) {
            throw new GSSException(13, -1, "Failed to find any Kerberos Ticket");
        }
        if (krb5NameElement == null) {
            String string = kerberosTicket.getClient().getName();
            krb5NameElement = Krb5NameElement.getInstance(string, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
        }
        return new Krb5InitCredential(krb5NameElement, kerberosTicket.getEncoded(), kerberosTicket.getClient(), kerberosTicket.getServer(), kerberosTicket.getSessionKey().getEncoded(), kerberosTicket.getSessionKeyType(), kerberosTicket.getFlags(), kerberosTicket.getAuthTime(), kerberosTicket.getStartTime(), kerberosTicket.getEndTime(), kerberosTicket.getRenewTill(), kerberosTicket.getClientAddresses());
    }

    static Krb5InitCredential getInstance(Krb5NameElement krb5NameElement, Credentials credentials) throws GSSException {
        EncryptionKey encryptionKey = credentials.getSessionKey();
        PrincipalName principalName = credentials.getClient();
        PrincipalName principalName2 = credentials.getServer();
        KerberosPrincipal kerberosPrincipal = null;
        KerberosPrincipal kerberosPrincipal2 = null;
        Krb5NameElement krb5NameElement2 = null;
        if (principalName != null) {
            String string = principalName.getName();
            krb5NameElement2 = Krb5NameElement.getInstance(string, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
            kerberosPrincipal = new KerberosPrincipal(string);
        }
        if (principalName2 != null) {
            kerberosPrincipal2 = new KerberosPrincipal(principalName2.getName());
        }
        return new Krb5InitCredential(krb5NameElement2, credentials, credentials.getEncoded(), kerberosPrincipal, kerberosPrincipal2, encryptionKey.getBytes(), encryptionKey.getEType(), credentials.getFlags(), credentials.getAuthTime(), credentials.getStartTime(), credentials.getEndTime(), credentials.getRenewTill(), credentials.getClientAddresses());
    }

    public final GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    public int getInitLifetime() throws GSSException {
        int n2 = 0;
        n2 = (int)(this.getEndTime().getTime() - new Date().getTime());
        return n2;
    }

    public int getAcceptLifetime() throws GSSException {
        return 0;
    }

    public boolean isInitiatorCredential() throws GSSException {
        return true;
    }

    public boolean isAcceptorCredential() throws GSSException {
        return false;
    }

    public final Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    Credentials getKrb5Credentials() {
        return this.krb5Credentials;
    }

    public void dispose() throws GSSException {
        try {
            this.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            GSSException gSSException = new GSSException(11, -1, "Could not destroy credentials - " + destroyFailedException.getMessage());
            gSSException.initCause(destroyFailedException);
        }
    }

    private static KerberosTicket getTgtFromSubject(Krb5NameElement krb5NameElement, int n2) throws GSSException {
        Object object;
        String string = null;
        String string2 = null;
        if (krb5NameElement != null) {
            string2 = krb5NameElement.getKrb5PrincipalName().getName();
            string = krb5NameElement.getKrb5PrincipalName().getRealmAsString();
        } else {
            try {
                object = Config.getInstance();
                string = ((Config)object).getDefaultRealm();
            }
            catch (KrbException krbException) {
                GSSException gSSException = new GSSException(13, -1, "Attempt to obtain INITIATE credentials failed! (" + krbException.getMessage() + ")");
                gSSException.initCause(krbException);
                throw gSSException;
            }
        }
        object = new String("krbtgt/" + string + "@" + string);
        AccessControlContext accessControlContext = AccessController.getContext();
        Object object2 = AccessController.doPrivileged(new SubjectComber(accessControlContext, (String)object, string2));
        if (object2 == null && !LoginUtility.useSubjectCredsOnly()) {
            Subject subject = null;
            try {
                subject = (Subject)AccessController.doPrivileged(new LoginUtility(LoginUtility.GSS_INITIATE_ENTRY));
            }
            catch (PrivilegedActionException privilegedActionException) {
                GSSException gSSException = new GSSException(13, -1, "Attempt to obtain new INITIATE credentials failed! (" + privilegedActionException.getMessage() + ")");
                gSSException.initCause(privilegedActionException.getException());
                throw gSSException;
            }
            object2 = AccessController.doPrivileged(new SubjectComber(subject, (String)object, string2));
        }
        return object2 == null ? null : (KerberosTicket)object2;
    }

    static {
        try {
            TICKET_CLASS = Class.forName("javax.security.auth.kerberos.KerberosTicket");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class SubjectComber
    implements PrivilegedAction {
        private AccessControlContext acc;
        private String tgsPrincipal;
        private String clientPrincipal;
        private Subject subject;

        public SubjectComber(AccessControlContext accessControlContext, String string, String string2) {
            this.acc = accessControlContext;
            this.tgsPrincipal = string;
            this.clientPrincipal = string2;
        }

        public SubjectComber(Subject subject, String string, String string2) {
            this.subject = subject;
            this.tgsPrincipal = string;
            this.clientPrincipal = string2;
        }

        public Object run() {
            if (this.subject == null) {
                this.subject = Subject.getSubject(this.acc);
            }
            if (this.subject != null) {
                Iterator iterator = this.subject.getPrivateCredentials(TICKET_CLASS).iterator();
                while (iterator.hasNext()) {
                    KerberosTicket kerberosTicket = (KerberosTicket)iterator.next();
                    if (!kerberosTicket.getServer().getName().equals(this.tgsPrincipal) || !kerberosTicket.isCurrent() || this.clientPrincipal != null && !this.clientPrincipal.equals(kerberosTicket.getClient().getName())) continue;
                    return kerberosTicket;
                }
            }
            return null;
        }
    }
}

