/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.security.AccessController;
import sun.rmi.runtime.Log;
import sun.rmi.server.RemoteProxy;
import sun.rmi.transport.Connection;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.StreamRemoteCall;
import sun.security.action.GetBooleanAction;

public class UnicastRef
implements RemoteRef {
    public static final Log clientRefLog = Log.getLog("sun.rmi.client.ref", "transport", RemoteProxy.logLevel);
    public static final Log clientCallLog;
    protected LiveRef ref;

    public UnicastRef() {
    }

    public UnicastRef(LiveRef liveRef) {
        this.ref = liveRef;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Remote var1_1, Method var2_2, Object[] var3_3, long var4_4) throws Exception {
        if (UnicastRef.clientCallLog.isLoggable(Log.VERBOSE)) {
            UnicastRef.clientCallLog.log(Log.VERBOSE, "method: " + var2_2);
        }
        if (UnicastRef.clientCallLog.isLoggable(Log.VERBOSE)) {
            this.logClientCall(var1_1, var2_2);
        }
        var6_5 = this.ref.getChannel().newConnection();
        var7_6 = null;
        var8_7 = true;
        var9_8 = false;
        try {
            try {
                if (UnicastRef.clientRefLog.isLoggable(Log.VERBOSE)) {
                    UnicastRef.clientRefLog.log(Log.VERBOSE, "opnum = " + var4_4);
                }
                var7_6 = new StreamRemoteCall(var6_5, this.ref.getObjID(), -1, var4_4);
                try {
                    var10_9 = var7_6.getOutputStream();
                    this.marshalCustomCallData((ObjectOutput)var10_9);
                    var11_13 = var2_2.getParameterTypes();
                    var12_16 = 0;
                    while (var12_16 < var11_13.length) {
                        UnicastRef.marshalValue(var11_13[var12_16], var3_3[var12_16], (ObjectOutput)var10_9);
                        ++var12_16;
                    }
                }
                catch (IOException var10_10) {
                    UnicastRef.clientRefLog.log(Log.BRIEF, "IOException marshalling arguments: ", var10_10);
                    throw new MarshalException("error marshalling arguments", var10_10);
                }
                var7_6.executeCall();
                try {
                    block29: {
                        block27: {
                            var10_9 = var2_2.getReturnType();
                            if (var10_9 != Void.TYPE) break block27;
                            var11_13 = null;
                            var16_19 = null;
                            try {
                                var7_6.done();
                            }
                            catch (IOException var17_22) {
                                var8_7 = false;
                            }
                            var19_25 = null;
                            if (var9_8 != false) return var11_13;
                            if (UnicastRef.clientRefLog.isLoggable(Log.BRIEF)) {
                                UnicastRef.clientRefLog.log(Log.BRIEF, "free connection (reuse = " + var8_7 + ")");
                            }
                            this.ref.getChannel().free(var6_5, var8_7);
                            return var11_13;
                        }
                        var12_17 = var7_6.getInputStream();
                        var13_28 = UnicastRef.unmarshalValue((Class)var10_9, var12_17);
                        var9_8 = true;
                        UnicastRef.clientRefLog.log(Log.BRIEF, "free connection (reuse = true)");
                        this.ref.getChannel().free(var6_5, true);
                        var14_29 = var13_28;
                        var16_20 = null;
                        ** try [egrp 7[TRYBLOCK] [6 : 382->392)] { 
lbl59:
                        // 1 sources

                        var7_6.done();
                        break block29;
lbl61:
                        // 1 sources

                        catch (IOException var17_23) {
                            var8_7 = false;
                        }
                    }
                    var19_26 = null;
                    if (var9_8 != false) return var14_29;
                    if (UnicastRef.clientRefLog.isLoggable(Log.BRIEF)) {
                        UnicastRef.clientRefLog.log(Log.BRIEF, "free connection (reuse = " + var8_7 + ")");
                    }
                    this.ref.getChannel().free(var6_5, var8_7);
                    return var14_29;
                }
                catch (IOException var10_11) {
                    try {
                        UnicastRef.clientRefLog.log(Log.BRIEF, "IOException unmarshalling return: ", var10_11);
                        throw new UnmarshalException("error unmarshalling return", var10_11);
                        catch (ClassNotFoundException var11_14) {
                            UnicastRef.clientRefLog.log(Log.BRIEF, "ClassNotFoundException unmarshalling return: ", var11_14);
                            throw new UnmarshalException("error unmarshalling return", var11_14);
                        }
                    }
                    catch (Throwable var15_30) {
                        var16_21 = null;
                        ** try [egrp 7[TRYBLOCK] [6 : 382->392)] { 
lbl82:
                        // 1 sources

                        var7_6.done();
                        throw var15_30;
lbl84:
                        // 1 sources

                        catch (IOException var17_24) {
                            var8_7 = false;
                        }
                        throw var15_30;
                    }
                }
            }
            catch (RuntimeException var10_12) {
                if (var7_6 != null) {
                    if (((StreamRemoteCall)var7_6).getServerException() == var10_12) throw var10_12;
                }
                var8_7 = false;
                throw var10_12;
            }
            catch (RemoteException var11_15) {
                var8_7 = false;
                throw var11_15;
            }
            catch (Error var12_18) {
                var8_7 = false;
                throw var12_18;
            }
        }
        catch (Throwable var18_31) {
            var19_27 = null;
            if (var9_8 != false) throw var18_31;
            if (UnicastRef.clientRefLog.isLoggable(Log.BRIEF)) {
                UnicastRef.clientRefLog.log(Log.BRIEF, "free connection (reuse = " + var8_7 + ")");
            }
            this.ref.getChannel().free(var6_5, var8_7);
            throw var18_31;
        }
    }

    protected void marshalCustomCallData(ObjectOutput objectOutput) throws IOException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void marshalValue(Class clazz, Object object, ObjectOutput objectOutput) throws IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                objectOutput.writeInt((Integer)object);
                return;
            } else if (clazz == Boolean.TYPE) {
                objectOutput.writeBoolean((Boolean)object);
                return;
            } else if (clazz == Byte.TYPE) {
                objectOutput.writeByte(((Byte)object).byteValue());
                return;
            } else if (clazz == Character.TYPE) {
                objectOutput.writeChar(((Character)object).charValue());
                return;
            } else if (clazz == Short.TYPE) {
                objectOutput.writeShort(((Short)object).shortValue());
                return;
            } else if (clazz == Long.TYPE) {
                objectOutput.writeLong((Long)object);
                return;
            } else if (clazz == Float.TYPE) {
                objectOutput.writeFloat(((Float)object).floatValue());
                return;
            } else {
                if (clazz != Double.TYPE) throw new Error("Unrecognized primitive type: " + clazz);
                objectOutput.writeDouble((Double)object);
            }
            return;
        } else {
            objectOutput.writeObject(object);
        }
    }

    protected static Object unmarshalValue(Class clazz, ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return new Integer(objectInput.readInt());
            }
            if (clazz == Boolean.TYPE) {
                return new Boolean(objectInput.readBoolean());
            }
            if (clazz == Byte.TYPE) {
                return new Byte(objectInput.readByte());
            }
            if (clazz == Character.TYPE) {
                return new Character(objectInput.readChar());
            }
            if (clazz == Short.TYPE) {
                return new Short(objectInput.readShort());
            }
            if (clazz == Long.TYPE) {
                return new Long(objectInput.readLong());
            }
            if (clazz == Float.TYPE) {
                return new Float(objectInput.readFloat());
            }
            if (clazz == Double.TYPE) {
                return new Double(objectInput.readDouble());
            }
            throw new Error("Unrecognized primitive type: " + clazz);
        }
        return objectInput.readObject();
    }

    public RemoteCall newCall(RemoteObject remoteObject, Operation[] operationArray, int n2, long l2) throws RemoteException {
        clientRefLog.log(Log.BRIEF, "get connection");
        Connection connection = this.ref.getChannel().newConnection();
        try {
            clientRefLog.log(Log.VERBOSE, "create call context");
            if (clientCallLog.isLoggable(Log.VERBOSE)) {
                this.logClientCall(remoteObject, operationArray[n2]);
            }
            StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection, this.ref.getObjID(), n2, l2);
            try {
                this.marshalCustomCallData(streamRemoteCall.getOutputStream());
            }
            catch (IOException iOException) {
                throw new MarshalException("error marshaling custom call data");
            }
            return streamRemoteCall;
        }
        catch (RemoteException remoteException) {
            this.ref.getChannel().free(connection, false);
            throw remoteException;
        }
    }

    public void invoke(RemoteCall remoteCall) throws Exception {
        try {
            clientRefLog.log(Log.VERBOSE, "execute call");
            remoteCall.executeCall();
        }
        catch (RemoteException remoteException) {
            clientRefLog.log(Log.BRIEF, "exception: ", remoteException);
            this.free(remoteCall, false);
            throw remoteException;
        }
        catch (Error error) {
            clientRefLog.log(Log.BRIEF, "error: ", error);
            this.free(remoteCall, false);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            clientRefLog.log(Log.BRIEF, "exception: ", runtimeException);
            this.free(remoteCall, false);
            throw runtimeException;
        }
        catch (Exception exception) {
            clientRefLog.log(Log.BRIEF, "exception: ", exception);
            this.free(remoteCall, true);
            throw exception;
        }
    }

    private void free(RemoteCall remoteCall, boolean bl2) throws RemoteException {
        Connection connection = ((StreamRemoteCall)remoteCall).getConnection();
        this.ref.getChannel().free(connection, bl2);
    }

    public void done(RemoteCall remoteCall) throws RemoteException {
        clientRefLog.log(Log.BRIEF, "free connection (reuse = true)");
        this.free(remoteCall, true);
        try {
            remoteCall.done();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void logClientCall(Object object, Object object2) {
        clientCallLog.log(Log.VERBOSE, "outbound call: " + this.ref + " : " + object.getClass().getName() + this.ref.getObjID().toString() + ": " + object2);
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastRef";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.ref.write(objectOutput, false);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = LiveRef.read(objectInput, false);
    }

    public String remoteToString() {
        return "RemoteStub [ref: " + this.ref + "]";
    }

    public int remoteHashCode() {
        return this.ref.hashCode();
    }

    public boolean remoteEquals(RemoteRef remoteRef) {
        if (remoteRef instanceof UnicastRef) {
            return this.ref.remoteEquals(((UnicastRef)remoteRef).ref);
        }
        return false;
    }

    static {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.client.logCalls"));
        boolean bl3 = bl2;
        clientCallLog = Log.getLog("sun.rmi.client.call", "RMI", bl3);
    }
}

