/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import sun.print.BackgroundLookupListener;
import sun.print.BackgroundServiceLookup;
import sun.print.UnixPrintService;
import sun.security.action.GetPropertyAction;

public class UnixPrintServiceLookup
extends PrintServiceLookup
implements BackgroundServiceLookup,
Runnable {
    private String defaultPrinter;
    private PrintService defaultPrintService;
    private String[] printers;
    private PrintService[] printServices;
    private Vector lookupListeners = null;
    static String osname = (String)AccessController.doPrivileged(new GetPropertyAction("os.name"));
    static final int UNINITIALIZED = -1;
    static final int BSD_LPD = 0;
    static final int BSD_LPD_NG = 1;
    static int cmdIndex = -1;
    String[] lpcFirstCom = new String[]{"/usr/sbin/lpc status | grep : | sed -ne '1,1 s/://p'", "/usr/sbin/lpc status | grep -E '^[ 0-9a-zA-Z]*@' | awk -F'@' '{print $1}'"};
    String[] lpcAllCom = new String[]{"/usr/sbin/lpc status | grep : | sed -e 's/://'", "/usr/sbin/lpc -a status | grep -E '^[ 0-9a-zA-Z]*@' | awk -F'@' '{print $1}'"};
    String[] lpcNameCom = new String[]{"| grep : | sed -ne 's/://p'", "| grep -E '^[ 0-9a-zA-Z]*@' | awk -F'@' '{print $1}'"};
    static /* synthetic */ Class class$javax$print$attribute$standard$PrinterName;

    static boolean isSysV() {
        return osname.equals("SunOS");
    }

    static boolean isBSD() {
        return osname.equals("Linux");
    }

    static int getBSDCommandIndex() {
        String string = "/usr/sbin/lpc status | grep @";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        if (stringArray == null || stringArray.length == 0) {
            return 0;
        }
        return 1;
    }

    public synchronized PrintService[] getPrintServices() {
        block5: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPrintJobAccess();
            }
            if (this.printServices != null) break block5;
            this.getDefaultPrintService();
            if (UnixPrintServiceLookup.isSysV()) {
                this.printers = this.getAllPrinterNamesSysV();
                this.printServices = new PrintService[this.printers.length + 1];
                this.printServices[0] = this.getDefaultPrintService();
                int n2 = 0;
                while (n2 < this.printers.length) {
                    this.printServices[n2 + 1] = new UnixPrintService(this.printers[n2]);
                    ++n2;
                }
            } else {
                this.printers = this.getAllPrinterNamesBSD();
                this.printServices = new PrintService[this.printers.length];
                int n3 = 0;
                while (n3 < this.printers.length) {
                    this.printServices[n3] = new UnixPrintService(this.printers[n3]);
                    ++n3;
                }
            }
        }
        return this.printServices;
    }

    private boolean matchesAttributes(PrintService printService, PrintServiceAttributeSet printServiceAttributeSet) {
        Attribute[] attributeArray = printServiceAttributeSet.toArray();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            PrintServiceAttribute printServiceAttribute = printService.getAttribute(attributeArray[n2].getCategory());
            if (printServiceAttribute == null || !printServiceAttribute.equals(attributeArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean checkPrinterName(String string) {
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (!Character.isLetterOrDigit(c2) && c2 != '-' && c2 != '_' && c2 != '.' && c2 != '/') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private PrintService getServiceByName(PrinterName printerName) {
        String string = printerName.getValue();
        PrintService printService = null;
        if (string == null || string.equals("") || !this.checkPrinterName(string)) {
            return null;
        }
        printService = UnixPrintServiceLookup.isSysV() ? this.getNamedPrinterNameSysV(string) : this.getNamedPrinterNameBSD(string);
        return printService;
    }

    private PrintService[] getPrintServices(PrintServiceAttributeSet printServiceAttributeSet) {
        if (printServiceAttributeSet == null || printServiceAttributeSet.isEmpty()) {
            return this.getPrintServices();
        }
        PrinterName printerName = (PrinterName)printServiceAttributeSet.get(class$javax$print$attribute$standard$PrinterName == null ? (class$javax$print$attribute$standard$PrinterName = UnixPrintServiceLookup.class$("javax.print.attribute.standard.PrinterName")) : class$javax$print$attribute$standard$PrinterName);
        if (printerName != null) {
            PrintService printService = this.getDefaultPrintService();
            PrinterName printerName2 = (PrinterName)printService.getAttribute(class$javax$print$attribute$standard$PrinterName == null ? (class$javax$print$attribute$standard$PrinterName = UnixPrintServiceLookup.class$("javax.print.attribute.standard.PrinterName")) : class$javax$print$attribute$standard$PrinterName);
            if (printerName2 != null && printerName.equals(printerName2)) {
                if (this.matchesAttributes(printService, printServiceAttributeSet)) {
                    PrintService[] printServiceArray = new PrintService[]{printService};
                    return printServiceArray;
                }
                return new PrintService[0];
            }
            PrintService printService2 = this.getServiceByName(printerName);
            if (printService2 != null && this.matchesAttributes(printService2, printServiceAttributeSet)) {
                PrintService[] printServiceArray = new PrintService[]{printService2};
                return printServiceArray;
            }
            return new PrintService[0];
        }
        Vector vector = new Vector();
        PrintService[] printServiceArray = this.getPrintServices();
        int n2 = 0;
        while (n2 < printServiceArray.length) {
            if (this.matchesAttributes(printServiceArray[n2], printServiceAttributeSet)) {
                vector.add(printServiceArray[n2]);
            }
            ++n2;
        }
        printServiceArray = new PrintService[vector.size()];
        int n3 = 0;
        while (n3 < printServiceArray.length) {
            printServiceArray[n3] = (PrintService)vector.elementAt(n3);
            ++n3;
        }
        return printServiceArray;
    }

    public PrintService[] getPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        Attribute[] attributeArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = null;
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = null;
        if (attributeSet != null && !attributeSet.isEmpty()) {
            hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
            attributeArray = attributeSet.toArray();
            int n2 = 0;
            while (n2 < attributeArray.length) {
                if (attributeArray[n2] instanceof PrintRequestAttribute) {
                    hashPrintRequestAttributeSet.add(attributeArray[n2]);
                } else if (attributeArray[n2] instanceof PrintServiceAttribute) {
                    hashPrintServiceAttributeSet.add(attributeArray[n2]);
                }
                ++n2;
            }
        }
        attributeArray = this.getDefaultPrintService();
        if ((docFlavor == null || attributeArray.isDocFlavorSupported(docFlavor)) && attributeArray.getUnsupportedAttributes(docFlavor, hashPrintRequestAttributeSet) == null) {
            return this.getPrintServices(hashPrintServiceAttributeSet);
        }
        return new PrintService[0];
    }

    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new MultiDocPrintService[0];
    }

    public synchronized PrintService getDefaultPrintService() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.defaultPrintService == null) {
            this.defaultPrinter = UnixPrintServiceLookup.isSysV() ? this.getDefaultPrinterNameSysV() : this.getDefaultPrinterNameBSD();
            this.defaultPrintService = new UnixPrintService(this.defaultPrinter);
        }
        return this.defaultPrintService;
    }

    public synchronized void getServicesInbackground(BackgroundLookupListener backgroundLookupListener) {
        if (this.printServices != null) {
            backgroundLookupListener.notifyServices(this.printServices);
        } else if (this.lookupListeners == null) {
            this.lookupListeners = new Vector();
            this.lookupListeners.add(backgroundLookupListener);
            Thread thread = new Thread(this);
            thread.start();
        } else {
            this.lookupListeners.add(backgroundLookupListener);
        }
    }

    private PrintService[] copyOf(PrintService[] printServiceArray) {
        if (printServiceArray == null || printServiceArray.length == 0) {
            return printServiceArray;
        }
        PrintService[] printServiceArray2 = new PrintService[printServiceArray.length];
        System.arraycopy(printServiceArray, 0, printServiceArray2, 0, printServiceArray.length);
        return printServiceArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PrintService[] printServiceArray = this.getPrintServices();
        UnixPrintServiceLookup unixPrintServiceLookup = this;
        synchronized (unixPrintServiceLookup) {
            int n2 = 0;
            while (n2 < this.lookupListeners.size()) {
                BackgroundLookupListener backgroundLookupListener = (BackgroundLookupListener)this.lookupListeners.elementAt(n2);
                backgroundLookupListener.notifyServices(this.copyOf(printServiceArray));
                ++n2;
            }
            this.lookupListeners = null;
        }
    }

    private String getDefaultPrinterNameBSD() {
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(this.lpcFirstCom[cmdIndex])) == null || stringArray.length == 0) {
            return null;
        }
        if (cmdIndex == 1 && stringArray[0].startsWith("missingprinter")) {
            return null;
        }
        return stringArray[0];
    }

    private PrintService getNamedPrinterNameBSD(String string) {
        String string2;
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(string2 = "/usr/sbin/lpc status " + string + this.lpcNameCom[cmdIndex])) == null || !stringArray[0].equals(string)) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private String[] getAllPrinterNamesBSD() {
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(this.lpcAllCom[cmdIndex])) == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    private String getDefaultPrinterNameSysV() {
        String string = "lp";
        String string2 = "/usr/bin/lpstat -d|/usr/bin/expand|/usr/bin/cut -f4 -d' '";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        return stringArray[0];
    }

    private PrintService getNamedPrinterNameSysV(String string) {
        String string2 = "/usr/bin/lpstat -v " + string;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        if (stringArray == null || stringArray[0].indexOf("unknown printer") > 0) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private String[] getAllPrinterNamesSysV() {
        String string = "lp";
        String string2 = "/usr/bin/lpstat -v|/usr/bin/expand|/usr/bin/cut -f3 -d' ' |/usr/bin/cut -f1 -d':'";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (!stringArray[n2].equals("_default") && !stringArray[n2].equals(string)) {
                arrayList.add(stringArray[n2]);
            }
            ++n2;
        }
        return (String[])arrayList.toArray(new String[arrayList.size()]);
    }

    static String[] execCmd(String string) {
        ArrayList arrayList = new ArrayList();
        try {
            Process process;
            final String[] stringArray = new String[3];
            if (UnixPrintServiceLookup.isSysV()) {
                stringArray[0] = "/usr/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = "env LC_ALL=C " + string;
            } else {
                stringArray[0] = "/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = string;
            }
            try {
                process = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return Runtime.getRuntime().exec(stringArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            process.waitFor();
            if (process.exitValue() == 0) {
                String string2;
                InputStream inputStream = process.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string2 = bufferedReader.readLine()) != null) {
                    arrayList.add(string2);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (String[])arrayList.toArray(new String[arrayList.size()]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

