/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcCallableStatement;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcDatabaseMetaData;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPreparedStatement;
import sun.jdbc.odbc.JdbcOdbcStatement;
import sun.jdbc.odbc.JdbcOdbcTypeInfo;

public class JdbcOdbcConnection
extends JdbcOdbcObject
implements JdbcOdbcConnectionInterface {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcDriverInterface myDriver;
    protected long hEnv;
    protected long hDbc;
    protected SQLWarning lastWarning;
    protected boolean closed;
    protected String URL;
    protected int odbcVer;
    protected Hashtable typeInfo;
    protected Hashtable statements;
    protected Hashtable batchStatements;
    protected short rsTypeFO;
    protected short rsTypeSI;
    protected short rsTypeSS;
    protected short rsTypeBest;
    protected int rsBlockSize;
    protected int batchInStatements;
    protected int batchInProcedures;
    protected int batchInPrepares;

    public JdbcOdbcConnection(JdbcOdbc jdbcOdbc, long l2, JdbcOdbcDriverInterface jdbcOdbcDriverInterface) {
        this.OdbcApi = jdbcOdbc;
        this.myDriver = jdbcOdbcDriverInterface;
        this.hEnv = l2;
        this.hDbc = 0L;
        this.URL = null;
        this.lastWarning = null;
        this.closed = true;
    }

    protected void finalize() {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Connection.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void initialize(String string, Properties properties, int n2) throws SQLException {
        int n3;
        String string2;
        String string3 = "";
        String string4 = "";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = "";
        if (this.closed) {
            this.hDbc = this.myDriver.allocConnection(this.hEnv);
        }
        if (n2 > 0) {
            this.setLoginTimeout(n2);
        }
        if ((string2 = properties.getProperty("odbcRowSetSize")) != null) {
            this.setResultSetBlockSize(string2);
        }
        this.OdbcApi.charSet = properties.getProperty("charSet", System.getProperty("file.encoding"));
        String string9 = properties.getProperty("licfile", "");
        String string10 = properties.getProperty("licpwd", "");
        String string11 = properties.getProperty("user", "");
        String string12 = properties.getProperty("password", "");
        String string13 = null;
        string13 = string.indexOf("DRIVER") != -1 || string.indexOf("Driver") != -1 || string.indexOf("driver") != -1 ? string : "DSN=" + string;
        StringTokenizer stringTokenizer = new StringTokenizer(string13, ";", false);
        if (stringTokenizer.countTokens() > 1) {
            n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n3;
                String string14 = stringTokenizer.nextToken();
                if (string14.startsWith("user")) {
                    string5 = string14;
                    continue;
                }
                if (string14.startsWith("password")) {
                    string6 = string14;
                    continue;
                }
                if (string14.startsWith("odbcRowSetSize")) {
                    string7 = string14;
                    continue;
                }
                string4 = n3 > 1 ? string4 + ";" + string14 : string4 + string14;
            }
        } else {
            string4 = string13;
        }
        string3 = string4;
        try {
            StringBuffer stringBuffer;
            int n4;
            if (string11.equals("") && string5 != null) {
                string8 = string5;
                String string15 = string5.substring(4);
                if (!string15.equals("")) {
                    if (string3.indexOf("UID=") == -1) {
                        string3 = string3 + ";UID" + string15;
                    } else {
                        int n5 = string3.indexOf("UID=");
                        n4 = string3.indexOf(";", n5);
                        stringBuffer = new StringBuffer(string3);
                        stringBuffer.replace(n5, n4, "UID=" + string15);
                        string3 = stringBuffer.toString();
                    }
                }
            } else if (!string11.equals("")) {
                if (string3.indexOf("UID=") == -1) {
                    string3 = string3 + ";UID=" + string11;
                } else {
                    n3 = string3.indexOf("UID=");
                    int n6 = string3.indexOf(";", n3);
                    StringBuffer stringBuffer2 = new StringBuffer(string3);
                    stringBuffer2.replace(n3, n6, "UID=" + string11);
                    string3 = stringBuffer2.toString();
                }
            }
            if (string12.equals("") && string6 != null) {
                string8 = string6;
                String string16 = string6.substring(8);
                if (string3.indexOf("UID=") != -1) {
                    if (string3.indexOf("PWD=") == -1) {
                        string3 = string3 + ";PWD" + string16;
                    } else {
                        int n7 = string3.indexOf("PWD=");
                        n4 = string3.indexOf(";", n7);
                        stringBuffer = new StringBuffer(string3);
                        stringBuffer.replace(n7, n4, "PWD=" + string16);
                        string3 = stringBuffer.toString();
                    }
                }
            } else if (!string12.equals("") && string3.indexOf("UID=") != -1) {
                if (string3.indexOf("PWD=") == -1) {
                    string3 = string3 + ";PWD=" + string12;
                } else {
                    int n8 = string3.indexOf("PWD=");
                    int n9 = string3.indexOf(";", n8);
                    StringBuffer stringBuffer3 = new StringBuffer(string3);
                    stringBuffer3.replace(n8, n9, "PWD=" + string12);
                    string3 = stringBuffer3.toString();
                }
            }
            if (string2 == null && string7 != null) {
                string8 = string7;
                String string17 = string7.substring(15);
                this.setResultSetBlockSize(string17);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new SQLException("invalid property values [" + string8 + "]");
        }
        try {
            this.OdbcApi.SQLDriverConnect(this.hDbc, string3);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.myDriver.closeConnection(this.hDbc);
            throw sQLException;
        }
        this.closed = false;
        if (string9 != null) {
            // empty if block
        }
        if (string10 != null) {
            // empty if block
        }
        this.statements = new Hashtable();
        this.batchStatements = new Hashtable();
        DatabaseMetaData databaseMetaData = this.getMetaData();
        this.OdbcApi.odbcDriverName = databaseMetaData.getDriverName() + " " + databaseMetaData.getDriverVersion();
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Driver name:    " + databaseMetaData.getDriverName());
            JdbcOdbcObject.trace("Driver version: " + databaseMetaData.getDriverVersion());
        } else {
            databaseMetaData = null;
        }
        this.buildTypeInfo();
        this.checkScrollCursorSupport();
        this.checkBatchUpdateSupport();
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public Statement createStatement(int n2, int n3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.createStatement");
        }
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        JdbcOdbcStatement jdbcOdbcStatement = new JdbcOdbcStatement(this);
        jdbcOdbcStatement.initialize(this.OdbcApi, this.hDbc, l2, null, n2, n3);
        jdbcOdbcStatement.setBlockCursorSize(this.rsBlockSize);
        this.registerStatement(jdbcOdbcStatement);
        return jdbcOdbcStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.prepareStatement (" + string + ")");
        }
        JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        jdbcOdbcPreparedStatement = new JdbcOdbcPreparedStatement(this);
        jdbcOdbcPreparedStatement.initialize(this.OdbcApi, this.hDbc, l2, this.typeInfo, n2, n3);
        try {
            this.OdbcApi.SQLPrepare(l2, string);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcPreparedStatement.close();
            throw sQLException;
        }
        jdbcOdbcPreparedStatement.initBoundParam();
        jdbcOdbcPreparedStatement.setWarning(sQLWarning);
        jdbcOdbcPreparedStatement.setBlockCursorSize(this.rsBlockSize);
        jdbcOdbcPreparedStatement.setSql(string);
        this.registerStatement(jdbcOdbcPreparedStatement);
        return jdbcOdbcPreparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public CallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.prepareCall (" + string + ")");
        }
        JdbcOdbcCallableStatement jdbcOdbcCallableStatement = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        jdbcOdbcCallableStatement = new JdbcOdbcCallableStatement(this);
        jdbcOdbcCallableStatement.initialize(this.OdbcApi, this.hDbc, l2, this.typeInfo, n2, n3);
        try {
            this.OdbcApi.SQLPrepare(l2, string);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcCallableStatement.close();
            throw sQLException;
        }
        jdbcOdbcCallableStatement.initBoundParam();
        jdbcOdbcCallableStatement.setWarning(sQLWarning);
        jdbcOdbcCallableStatement.setBlockCursorSize(this.rsBlockSize);
        jdbcOdbcCallableStatement.setSql(string);
        this.registerStatement(jdbcOdbcCallableStatement);
        return jdbcOdbcCallableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        String string2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.nativeSQL (" + string + ")");
        }
        try {
            string2 = this.OdbcApi.SQLNativeSql(this.hDbc, string);
        }
        catch (SQLException sQLException) {
            string2 = string;
        }
        return string2;
    }

    public void setAutoCommit(boolean bl2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.setAutoCommit (" + bl2 + ")");
        }
        int n2 = 1;
        this.validateConnection();
        if (!bl2) {
            n2 = 0;
        }
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)102, n2);
    }

    public boolean getAutoCommit() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.getAutoCommit");
        }
        boolean bl2 = false;
        this.validateConnection();
        int n2 = (int)this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)102);
        if (n2 == 1) {
            bl2 = true;
        }
        return bl2;
    }

    public void commit() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.commit");
        }
        this.validateConnection();
        this.OdbcApi.SQLTransact(this.hEnv, this.hDbc, (short)0);
    }

    public void rollback() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.rollback");
        }
        this.validateConnection();
        this.OdbcApi.SQLTransact(this.hEnv, this.hDbc, (short)1);
    }

    public void close() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.close");
        }
        this.closeAllStatements();
        if (!this.closed) {
            this.myDriver.disconnect(this.hDbc);
            this.myDriver.closeConnection(this.hDbc);
        }
        this.closed = true;
        this.URL = null;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.getMetaData");
        }
        this.validateConnection();
        JdbcOdbcDatabaseMetaData jdbcOdbcDatabaseMetaData = new JdbcOdbcDatabaseMetaData(this.OdbcApi, this);
        return jdbcOdbcDatabaseMetaData;
    }

    public void setReadOnly(boolean bl2) throws SQLException {
        block4: {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("*Connection.setReadOnly (" + bl2 + ")");
            }
            int n2 = 0;
            this.validateConnection();
            if (bl2) {
                n2 = 1;
            }
            try {
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)101, n2);
            }
            catch (SQLException sQLException) {
                if (!JdbcOdbcObject.isTracing()) break block4;
                JdbcOdbcObject.trace("setReadOnly exception ignored");
            }
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.isReadOnly");
        }
        boolean bl2 = false;
        this.validateConnection();
        int n2 = (int)this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)101);
        if (n2 == 1) {
            bl2 = true;
        }
        return bl2;
    }

    public void setCatalog(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.setCatalog (" + string + ")");
        }
        this.validateConnection();
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)109, string);
    }

    public String getCatalog() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.getCatalog");
        }
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, (short)16);
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.setTransactionIsolation (" + n2 + ")");
        }
        this.validateConnection();
        switch (n2) {
            case 0: {
                this.setAutoCommit(true);
                break;
            }
            case 1: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 1);
                break;
            }
            case 2: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 2);
                break;
            }
            case 4: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 4);
                break;
            }
            case 8: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 8);
                break;
            }
            default: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, n2);
            }
        }
    }

    public void setLicenseFile(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.setLicenseFile (" + string + ")");
        }
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)1041, string);
    }

    public void setLicensePassword(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.setPassword (" + string + ")");
        }
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)1042, string);
    }

    public int getTransactionIsolation() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.getTransactionIsolation");
        }
        int n2 = 0;
        this.validateConnection();
        int n3 = (int)this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)108);
        switch (n3) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            default: {
                n2 = n3;
            }
        }
        return n2;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.getWarnings");
        }
        return this.lastWarning;
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public void validateConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    public long getHDBC() {
        return this.hDbc;
    }

    public void setURL(String string) {
        this.URL = string;
    }

    public String getURL() {
        return this.URL;
    }

    protected void setLoginTimeout(int n2) throws SQLException {
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)103, n2);
    }

    public int getODBCVer() {
        if (this.odbcVer == 0) {
            String string;
            try {
                string = this.OdbcApi.SQLGetInfoString(this.hDbc, (short)10);
            }
            catch (SQLException sQLException) {
                string = "-1";
            }
            Integer n2 = new Integer(string.substring(0, 2));
            this.odbcVer = n2;
        }
        return this.odbcVer;
    }

    protected void checkBatchUpdateSupport() {
        this.batchInStatements = -1;
        this.batchInProcedures = -1;
        this.batchInPrepares = -1;
        int n2 = -1;
        int n3 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            n2 = this.OdbcApi.SQLGetInfo(this.hDbc, (short)121);
            if ((n2 & 2) > 0) {
                bl2 = true;
            }
            if ((n2 & 8) > 0) {
                bl3 = true;
            }
            if (((n3 = this.OdbcApi.SQLGetInfo(this.hDbc, (short)120)) & 4) > 0) {
                this.batchInStatements = 4;
                this.batchInProcedures = 4;
            } else {
                if (bl2 && (n3 & 2) > 0) {
                    this.batchInStatements = 2;
                }
                if (bl3 && (n3 & 1) > 0) {
                    this.batchInProcedures = 1;
                }
            }
            n2 = this.OdbcApi.SQLGetInfo(this.hDbc, (short)153);
            if ((n2 & 1) > 0) {
                bl4 = true;
                this.batchInPrepares = 1;
            }
        }
        catch (SQLException sQLException) {
            this.batchInStatements = -1;
            this.batchInProcedures = -1;
            this.batchInPrepares = -1;
        }
    }

    public int getBatchRowCountFlag(int n2) {
        switch (n2) {
            case 1: {
                return this.batchInStatements;
            }
            case 2: {
                return this.batchInPrepares;
            }
            case 3: {
                return this.batchInProcedures;
            }
        }
        return -1;
    }

    public void checkScrollCursorSupport() throws SQLException {
        short s2 = -1;
        int n2 = 0;
        int n3 = this.OdbcApi.SQLGetInfo(this.hDbc, (short)44);
        this.rsTypeFO = (short)-1;
        this.rsTypeSI = (short)-1;
        this.rsTypeSS = (short)-1;
        if ((n3 & 1) != 0) {
            this.rsTypeFO = 0;
        }
        if ((n3 & 0x10) != 0) {
            this.rsTypeSI = (short)3;
        }
        if ((n3 & 0x10) != 0 && ((n2 = this.getOdbcCursorAttr2(s2 = 3)) & 0x40) != 0) {
            this.rsTypeSS = s2;
        }
        if ((n3 & 2) != 0 || (n3 & 8) != 0) {
            s2 = 1;
            n2 = this.getOdbcCursorAttr2(s2);
            if ((n2 & 0x40) != 0) {
                this.rsTypeSS = s2;
            } else {
                this.rsTypeSI = s2;
            }
        }
        if ((n3 & 4) != 0 && ((n2 = this.getOdbcCursorAttr2(s2 = 2)) & 0x40) != 0) {
            this.rsTypeSS = s2;
        }
        this.rsTypeBest = s2;
        if (this.rsTypeBest == -1) {
            this.rsTypeBest = this.rsTypeSS;
        }
        if (this.rsTypeBest == -1) {
            this.rsTypeBest = this.rsTypeSI;
        }
        if (this.rsTypeBest == -1) {
            this.rsTypeBest = this.rsTypeFO;
        }
    }

    public short getBestOdbcCursorType() {
        return this.rsTypeBest;
    }

    public short getOdbcCursorType(int n2) {
        short s2 = -1;
        switch (n2) {
            case 1003: {
                s2 = this.rsTypeFO;
                break;
            }
            case 1004: {
                s2 = this.rsTypeSI;
                break;
            }
            case 1005: {
                s2 = this.rsTypeSS;
            }
        }
        return s2;
    }

    public short getOdbcConcurrency(int n2) {
        switch (n2) {
            case 1007: {
                return 1;
            }
            case 1008: {
                return 2;
            }
        }
        return 1;
    }

    public int getOdbcCursorAttr2(short s2) throws SQLException {
        short s3 = 0;
        switch (s2) {
            case 0: {
                s3 = 147;
                break;
            }
            case 3: {
                s3 = 168;
                break;
            }
            case 1: {
                s3 = 151;
                break;
            }
            case 2: {
                s3 = 145;
            }
        }
        try {
            return this.OdbcApi.SQLGetInfo(this.hDbc, s3);
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public Map getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected void buildTypeInfo() throws SQLException {
        this.typeInfo = new Hashtable();
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Caching SQL type information");
        }
        ResultSet resultSet = this.getMetaData().getTypeInfo();
        boolean bl2 = resultSet.next();
        while (bl2) {
            String string = resultSet.getString(1);
            int n2 = resultSet.getInt(2);
            if (this.typeInfo.get(new Integer(n2)) == null) {
                JdbcOdbcTypeInfo jdbcOdbcTypeInfo = new JdbcOdbcTypeInfo();
                jdbcOdbcTypeInfo.setName(string);
                jdbcOdbcTypeInfo.setPrec(resultSet.getInt(3));
                this.typeInfo.put(new Integer(n2), jdbcOdbcTypeInfo);
            }
            bl2 = resultSet.next();
        }
        resultSet.close();
    }

    protected void registerStatement(Statement statement) {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Registering Statement " + statement);
        }
        this.statements.put(statement, "");
    }

    public void deregisterStatement(Statement statement) {
        if (this.statements.get(statement) != null) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("deregistering Statement " + statement);
            }
            this.statements.remove(statement);
        }
    }

    public synchronized void closeAllStatements() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("" + this.statements.size() + " Statement(s) to close");
        }
        if (this.statements.size() == 0) {
            return;
        }
        Enumeration enumeration = this.statements.keys();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            statement.close();
        }
        this.batchStatements = null;
    }

    public synchronized void setBatchVector(Vector vector, Statement statement) {
        int n2 = -1;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("setBatchVector " + statement);
        }
        this.batchStatements.put(statement, vector);
    }

    public Vector getBatchVector(Statement statement) {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("getBatchVector " + statement);
        }
        return (Vector)this.batchStatements.get(statement);
    }

    public synchronized void removeBatchVector(Statement statement) {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("removeBatchVector " + statement);
        }
        this.batchStatements.remove(statement);
    }

    protected void setResultSetBlockSize(String string) throws SQLException {
        this.rsBlockSize = 10;
        if (string != null) {
            string.trim();
            if (!string.equals("")) {
                try {
                    int n2 = new Integer(string);
                    if (n2 > 0) {
                        this.rsBlockSize = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("invalid property value: [odbcRowSetSize=" + string + "]");
                }
            }
        }
    }

    public void setHoldability(int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Statement createStatement(int n2, int n3, int n4) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String string, int n2, int n3, int n4) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

