/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.image.ColorModel;
import sun.java2d.loops.PixelWriter;

abstract class XorPixelWriter
extends PixelWriter {
    protected ColorModel dstCM;

    XorPixelWriter() {
    }

    public void writePixel(int n2, int n3) {
        Object object = this.dstRast.getDataElements(n2, n3, null);
        this.xorPixel(object);
        this.dstRast.setDataElements(n2, n3, object);
    }

    protected abstract void xorPixel(Object var1);

    public static class DoubleData
    extends XorPixelWriter {
        long[] xorData;

        DoubleData(Object object, Object object2) {
            double[] dArray = (double[])object;
            double[] dArray2 = (double[])object2;
            this.xorData = new long[dArray.length];
            int n2 = 0;
            while (n2 < dArray.length) {
                this.xorData[n2] = Double.doubleToLongBits(dArray[n2]) ^ Double.doubleToLongBits(dArray2[n2]);
                ++n2;
            }
        }

        protected void xorPixel(Object object) {
            double[] dArray = (double[])object;
            int n2 = 0;
            while (n2 < dArray.length) {
                long l2 = Double.doubleToLongBits(dArray[n2]) ^ this.xorData[n2];
                dArray[n2] = Double.longBitsToDouble(l2);
                ++n2;
            }
        }
    }

    public static class FloatData
    extends XorPixelWriter {
        int[] xorData;

        FloatData(Object object, Object object2) {
            float[] fArray = (float[])object;
            float[] fArray2 = (float[])object2;
            this.xorData = new int[fArray.length];
            int n2 = 0;
            while (n2 < fArray.length) {
                this.xorData[n2] = Float.floatToIntBits(fArray[n2]) ^ Float.floatToIntBits(fArray2[n2]);
                ++n2;
            }
        }

        protected void xorPixel(Object object) {
            float[] fArray = (float[])object;
            int n2 = 0;
            while (n2 < fArray.length) {
                int n3 = Float.floatToIntBits(fArray[n2]) ^ this.xorData[n2];
                fArray[n2] = Float.intBitsToFloat(n3);
                ++n2;
            }
        }
    }

    public static class IntData
    extends XorPixelWriter {
        int[] xorData;

        IntData(Object object, Object object2) {
            this.xorData = (int[])object;
            this.xorPixel(object2);
            this.xorData = (int[])object2;
        }

        protected void xorPixel(Object object) {
            int[] nArray = (int[])object;
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = n2;
                nArray[n3] = nArray[n3] ^ this.xorData[n2];
                ++n2;
            }
        }
    }

    public static class ShortData
    extends XorPixelWriter {
        short[] xorData;

        ShortData(Object object, Object object2) {
            this.xorData = (short[])object;
            this.xorPixel(object2);
            this.xorData = (short[])object2;
        }

        protected void xorPixel(Object object) {
            short[] sArray = (short[])object;
            int n2 = 0;
            while (n2 < sArray.length) {
                int n3 = n2;
                sArray[n3] = (short)(sArray[n3] ^ this.xorData[n2]);
                ++n2;
            }
        }
    }

    public static class ByteData
    extends XorPixelWriter {
        byte[] xorData;

        ByteData(Object object, Object object2) {
            this.xorData = (byte[])object;
            this.xorPixel(object2);
            this.xorData = (byte[])object2;
        }

        protected void xorPixel(Object object) {
            byte[] byArray = (byte[])object;
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = n2;
                byArray[n3] = (byte)(byArray[n3] ^ this.xorData[n2]);
                ++n2;
            }
        }
    }
}

