/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import sun.awt.FontProperties;
import sun.awt.font.NativeFontWrapper;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.FontSupport;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.text.resources.LocaleData;

public abstract class SunGraphicsEnvironment
extends GraphicsEnvironment
implements FontSupport {
    protected static boolean debugMapping = false;
    private static Font defaultFont;
    private static String[] logicalFontNames;
    protected FontProperties fprops;
    private TreeMap terminalNames;
    private HashSet physicalNames;
    private boolean loadedAllFonts = false;
    protected String fontPath;
    protected TreeMap registeredFonts = new TreeMap();
    private Hashtable mapFamilyCache;
    protected boolean loadNativeFonts = false;
    protected GraphicsDevice[] screens;
    private Font[] allFonts;

    public SunGraphicsEnvironment() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getProperty("sun.java2d.debugfonts") != null) {
                    debugMapping = true;
                }
                SunGraphicsEnvironment.this.fontPath = System.getProperty("sun.java2d.fontpath");
                String string = System.getProperty("java.home", "") + File.separator + "lib" + File.separator + "fonts";
                SunGraphicsEnvironment.this.initializeProps();
                String string2 = null;
                if (SunGraphicsEnvironment.this.fprops != null) {
                    string2 = SunGraphicsEnvironment.this.fprops.getProperty("appendedfontpath");
                }
                if (SunGraphicsEnvironment.this.fontPath.length() == 0) {
                    boolean bl2 = false;
                    String string3 = System.getProperty("sun.java2d.noType1Font");
                    if (string3 == null) {
                        bl2 = NativeFontWrapper.getType1FontVar();
                    }
                    if ("true".equals(string3)) {
                        bl2 = true;
                    }
                    SunGraphicsEnvironment.this.loadNativeFonts = true;
                    SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.getPlatformFontPath(bl2);
                    SunGraphicsEnvironment.this.fontPath = string + File.pathSeparator + SunGraphicsEnvironment.this.fontPath;
                    if (string2 != null) {
                        SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.fontPath + File.pathSeparator + string2;
                    }
                    if (debugMapping) {
                        System.out.println("Platform Font Path=" + SunGraphicsEnvironment.this.fontPath);
                    }
                }
                SunGraphicsEnvironment.this.registerFontPaths(SunGraphicsEnvironment.this.fontPath);
                SunGraphicsEnvironment.this.registerFonts(string, true);
                SunGraphicsEnvironment.this.initCompositeFonts();
                Object[] objectArray = SunGraphicsEnvironment.this.registeredFonts.keySet().toArray();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    String string4 = (String)objectArray[n2];
                    String string5 = NativeFontWrapper.getFullNameByFileName(string4);
                    if (string5 != null) {
                        string5 = string5.toLowerCase();
                    }
                    if (string5 != null && !SunGraphicsEnvironment.this.terminalNames.containsKey(string5)) {
                        SunGraphicsEnvironment.this.terminalNames.put(string5, new Integer(0));
                    }
                    ++n2;
                }
                return null;
            }
        });
    }

    protected String getPlatformFontPath(boolean bl2) {
        return NativeFontWrapper.getFontPath(bl2);
    }

    protected synchronized void loadFonts() {
        if (this.loadedAllFonts) {
            return;
        }
        if (debugMapping) {
            System.out.println("loadfonts called");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl2 = SunGraphicsEnvironment.this.registerFonts(SunGraphicsEnvironment.this.fontPath, false);
                boolean bl3 = false;
                if (SunGraphicsEnvironment.this.loadNativeFonts) {
                    bl3 = SunGraphicsEnvironment.this.registerNativeFonts();
                }
                if (!bl2 && !bl3 && SunGraphicsEnvironment.this.registeredFonts.size() == 0) {
                    System.out.println("\nNo fonts were found in '" + SunGraphicsEnvironment.this.fontPath + "'.\n");
                    System.exit(2);
                }
                SunGraphicsEnvironment.this.loadedAllFonts = true;
                return null;
            }
        });
    }

    public synchronized GraphicsDevice[] getScreenDevices() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        if (graphicsDeviceArray == null) {
            int n2 = this.getNumScreens();
            graphicsDeviceArray = new GraphicsDevice[n2];
            int n3 = 0;
            while (n3 < n2) {
                graphicsDeviceArray[n3] = this.makeScreenDevice(n3);
                ++n3;
            }
            this.screens = graphicsDeviceArray;
        }
        return graphicsDeviceArray;
    }

    protected abstract int getNumScreens();

    protected abstract GraphicsDevice makeScreenDevice(int var1);

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[0];
    }

    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        SurfaceData surfaceData = BufImgSurfaceData.createData(bufferedImage);
        if (defaultFont == null) {
            defaultFont = new Font("Dialog", 0, 12);
        }
        return new SunGraphics2D(surfaceData, Color.white, Color.black, defaultFont);
    }

    public Font[] getAllFonts() {
        if (this.allFonts != null) {
            return this.allFonts;
        }
        this.loadFonts();
        Font[] fontArray = null;
        String[] stringArray = null;
        int n2 = NativeFontWrapper.getNumFonts();
        if (n2 > 0) {
            Object[] objectArray;
            TreeMap treeMap = new TreeMap();
            int n3 = 0;
            while (n3 < n2) {
                objectArray = NativeFontWrapper.getFullNameByIndex(n3);
                treeMap.put(objectArray, null);
                ++n3;
            }
            if (treeMap.size() > 0) {
                stringArray = new String[treeMap.size()];
                objectArray = treeMap.keySet().toArray();
                int n4 = 0;
                while (n4 < objectArray.length) {
                    stringArray[n4] = (String)objectArray[n4];
                    ++n4;
                }
            }
        }
        if (stringArray != null) {
            fontArray = new Font[stringArray.length];
            int n5 = 0;
            while (n5 < stringArray.length) {
                fontArray[n5] = new Font(stringArray[n5], 0, 1);
                ++n5;
            }
        }
        this.allFonts = fontArray;
        return this.allFonts;
    }

    public String[] getAvailableFontFamilyNames(Locale locale) {
        if (locale == null) {
            return this.getAvailableFontFamilyNames();
        }
        this.loadFonts();
        String[] stringArray = null;
        int n2 = NativeFontWrapper.getNumFonts();
        short s2 = SunGraphicsEnvironment.getLcidFromLocale(locale);
        if (n2 > 0) {
            Object[] objectArray;
            String string;
            TreeMap treeMap = new TreeMap();
            int n3 = 0;
            while (n3 < n2) {
                string = NativeFontWrapper.getFamilyNameByIndex(n3, s2);
                objectArray = string.toLowerCase();
                if (!(objectArray.endsWith(".bold") || objectArray.endsWith(".bolditalic") || objectArray.endsWith(".italic"))) {
                    treeMap.put(objectArray, string);
                }
                ++n3;
            }
            string = "Serif";
            treeMap.put(string.toLowerCase(), string);
            string = "SansSerif";
            treeMap.put(string.toLowerCase(), string);
            string = "Monospaced";
            treeMap.put(string.toLowerCase(), string);
            string = "Dialog";
            treeMap.put(string.toLowerCase(), string);
            string = "DialogInput";
            treeMap.put(string.toLowerCase(), string);
            string = "Default";
            treeMap.put(string.toLowerCase(), string);
            if (treeMap.size() > 0) {
                stringArray = new String[treeMap.size()];
                objectArray = treeMap.keySet().toArray();
                int n4 = 0;
                while (n4 < objectArray.length) {
                    stringArray[n4] = (String)treeMap.get(objectArray[n4]);
                    ++n4;
                }
            }
        }
        return stringArray;
    }

    public String[] getAvailableFontFamilyNames() {
        return this.getAvailableFontFamilyNames(Locale.getDefault());
    }

    public String mapFamilyName(String string, int n2) {
        int n3;
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (string2.equals("sanserif") || string2.equals("san serif") || string2.equals("sans serif") || string2.equals("ms sans serif")) {
            string2 = "sansserif";
            string = "sansserif";
        }
        if (string2.equals("ms serif")) {
            string2 = "serif";
            string = "serif";
        }
        if ((n3 = string2.lastIndexOf(".plain")) != -1) {
            string2 = string2.substring(0, n3);
        }
        if (!(this.terminalNames.containsKey(string2) || this.physicalNames != null && this.physicalNames.contains(string2))) {
            if (debugMapping) {
                System.out.println("loadfonts to find font " + string2);
            }
            this.loadFonts();
        }
        String string3 = this.mapFamilyNameAll(string, n2);
        return string3;
    }

    public String mapFamilyNameAll(String string, int n2) {
        String string2;
        String string3 = string.toLowerCase();
        if (null != this.mapFamilyCache && null != (string2 = (String)this.mapFamilyCache.get(string3 + SunGraphicsEnvironment.styleStr(n2)))) {
            return string2;
        }
        if (this.fprops == null) {
            return string;
        }
        if (debugMapping) {
            System.out.println("Originalname[" + string + "." + SunGraphicsEnvironment.styleStr(n2) + "]");
        }
        if ((string2 = this.fprops.getProperty("alias." + string3)) == null) {
            string2 = string;
        }
        Object[] objectArray = this.fprops.keySet().toArray();
        int n3 = objectArray.length;
        int n4 = 0;
        do {
            String string4;
            if (this.terminalNames.containsKey((string4 = string2.toLowerCase()) + "." + SunGraphicsEnvironment.styleStr(n2))) {
                string2 = string4 + "." + SunGraphicsEnvironment.styleStr(n2);
                break;
            }
            if (n2 == 0 && this.terminalNames.containsKey(string4)) break;
            String string5 = string4 + "." + SunGraphicsEnvironment.styleStr(n2) + ".0";
            String string6 = this.fprops.getProperty(string5);
            if (debugMapping) {
                System.out.println("  trying [" + string5 + "]");
            }
            if (string6 == null) {
                string5 = string4 + ".0";
                string6 = this.fprops.getProperty(string5);
                if (debugMapping) {
                    System.out.println("  trying [" + string5 + "]");
                }
            }
            if (string6 == null) break;
            if (debugMapping) {
                System.out.println("  found [" + string6 + "]");
            }
            string2 = this.parseFamilyNameProperty(string6);
        } while (++n4 < n3);
        if (debugMapping) {
            System.out.println("    resolved to [" + string2 + "]");
        }
        if (null == this.mapFamilyCache) {
            this.mapFamilyCache = new Hashtable(5, 0.9f);
        }
        if (null != this.mapFamilyCache) {
            this.mapFamilyCache.put(string3 + SunGraphicsEnvironment.styleStr(n2), string2);
        }
        return string2;
    }

    protected String parseFamilyNameProperty(String string) {
        int n2 = string.indexOf(",");
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(0, n2);
    }

    protected String getFontPropertyFD(String string) {
        return this.parseFamilyNameProperty(string);
    }

    protected String getFileNameFromPlatformName(String string) {
        if (this.fprops == null) {
            return null;
        }
        string = string.replace(' ', '_');
        return this.fprops.getProperty("filename." + string);
    }

    public PrinterJob getPrinterJob() {
        new Exception().printStackTrace();
        return null;
    }

    protected void registerFontPaths(String string) {
    }

    private boolean registerFonts(String string, boolean bl2) {
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                bl3 |= this.addPathFonts(string2, new TTFilter(), 0, bl2);
                bl3 |= this.addPathFonts(string2, new T1Filter(), 1, bl2);
                bl3 |= this.addPathFonts(string2, new T2KFilter(), 2, bl2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        return bl3;
    }

    protected void registerFontFile(String string, Vector vector) {
        int n2;
        if (this.registeredFonts.containsKey(string)) {
            return;
        }
        if (new TTFilter().accept(null, string)) {
            n2 = 0;
        } else if (new T1Filter().accept(null, string)) {
            n2 = 1;
        } else if (new T2KFilter().accept(null, string)) {
            n2 = 2;
        } else {
            this.registerNative(string);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.fontPath, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                File file = new File(string3, string);
                String string4 = null;
                try {
                    string4 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string4 = file.getAbsolutePath();
                }
                if (!file.canRead()) continue;
                Vector vector2 = new Vector(1, 1);
                Vector vector3 = new Vector(1, 1);
                vector3.addElement(vector);
                vector2.addElement(string4);
                this.registeredFonts.put(string, string4);
                NativeFontWrapper.registerFonts(vector2, vector2.size(), vector3, n2, false);
                if (this.physicalNames == null) {
                    this.physicalNames = new HashSet();
                }
                if ((string2 = NativeFontWrapper.getFullNameByFileName(string4)) != null) {
                    string2 = string2.toLowerCase();
                }
                if (!this.physicalNames.contains(string2)) {
                    this.physicalNames.add(string2);
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
    }

    protected void registerFontPath(String string) {
    }

    protected void registerNative(String string) {
    }

    protected Vector getNativeNames(String string) {
        Vector vector = new Vector();
        return vector;
    }

    protected boolean registerNativeFonts() {
        return false;
    }

    private boolean addPathFonts(String string, FilenameFilter filenameFilter, int n2, boolean bl2) {
        boolean bl3 = false;
        Vector vector = new Vector(20, 10);
        Vector vector2 = new Vector(20, 10);
        File file = new File(string);
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            return bl3;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            File file2 = new File(file, stringArray[n3]);
            String string2 = null;
            try {
                string2 = file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = file2.getAbsolutePath();
            }
            if (!this.registeredFonts.containsKey(string2)) {
                this.registeredFonts.put(string2, string2);
                if (debugMapping) {
                    System.out.println("Registering font " + string2);
                    Vector vector3 = this.getNativeNames(string2);
                    if (vector3.size() == 0) {
                        System.out.println("No native name");
                    } else {
                        int n4 = 0;
                        while (n4 < vector3.size()) {
                            System.out.println("native name : " + (String)vector3.elementAt(n4));
                            ++n4;
                        }
                    }
                }
                vector.addElement(string2);
                vector2.addElement(this.getNativeNames(string2));
                bl3 = true;
            }
            ++n3;
        }
        NativeFontWrapper.registerFonts(vector, vector.size(), vector2, n2, bl2);
        return bl3;
    }

    public static Font getBestFontFor(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        char c2 = attributedCharacterIterator.setIndex(n2);
        Map map = attributedCharacterIterator.getAttributes();
        Font font = Font.getFont(map);
        while (!font.canDisplay(c2) && attributedCharacterIterator.getRunLimit() < n3) {
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
            font = Font.getFont(attributedCharacterIterator.getAttributes());
        }
        if (!font.canDisplay(c2)) {
            attributedCharacterIterator.setIndex(n2);
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            int n4 = 0;
            while (n4 < stringArray.length) {
                Hashtable hashtable = new Hashtable();
                hashtable.putAll(map);
                hashtable.put(TextAttribute.FAMILY, stringArray[n4]);
                font = Font.getFont(hashtable);
                if (font.canDisplay(c2)) break;
                ++n4;
            }
            if (!font.canDisplay(c2)) {
                font = Font.getFont(map);
            }
        }
        return font;
    }

    protected boolean platformReady() {
        return true;
    }

    protected void initializeProps() {
        if (!this.platformReady()) {
            return;
        }
        this.fprops = new FontProperties();
    }

    private void initCompositeFonts() {
        if (!this.platformReady()) {
            return;
        }
        this.initTerminalNames();
        Object[] objectArray = this.terminalNames.keySet().toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object;
            String string = (String)objectArray[n2];
            Integer n3 = (Integer)this.terminalNames.get(objectArray[n2]);
            int n4 = n3;
            boolean bl2 = false;
            int n5 = 0;
            while (n5 < n4) {
                object = this.parseFamilyNameProperty(this.fprops.getProperty(string + "." + n5));
                if (((String)object).compareToIgnoreCase("Lucida Sans Regular") == 0) {
                    bl2 = true;
                    break;
                }
                ++n5;
            }
            if (!bl2) {
                ++n4;
            }
            object = new String[n4];
            int[] nArray = new int[n4];
            int[] nArray2 = new int[]{};
            int n6 = n4;
            if (!bl2) {
                object[n4 - 1] = "Lucida Sans Regular";
                --n6;
            }
            int n7 = 0;
            while (n7 < n6) {
                object[n7] = this.parseFamilyNameProperty(this.fprops.getProperty(string + "." + n7));
                if (debugMapping) {
                    System.out.println("The composite name = " + (String)object[n7]);
                }
                nArray2 = this.appendExclusions(string, n7, nArray2);
                nArray[n7] = nArray2.length;
                ++n7;
            }
            if (debugMapping) {
                System.out.println("initCompositeFonts compositeFontName=" + string);
            }
            NativeFontWrapper.registerCompositeFont(string, (String[])object, nArray2, nArray);
            ++n2;
        }
        this.terminalNames.put("default", new Integer(0));
    }

    private int[] appendExclusions(String string, int n2, int[] nArray) {
        String string2;
        int n3;
        String string3 = "exclusion." + string + "." + n2;
        if (this.fprops.containsKey(string3) && (n3 = ((string2 = this.fprops.getProperty(string3)).length() + 1) / 10) > 0) {
            Object object;
            int[] nArray2 = new int[n3 * 2];
            int n4 = 0;
            while (n4 < n3) {
                String string4 = string2.substring(n4 * 10, n4 * 10 + 4);
                object = string2.substring(n4 * 10 + 5, n4 * 10 + 9);
                nArray2[n4 * 2] = Integer.parseInt(string4, 16);
                nArray2[n4 * 2 + 1] = Integer.parseInt((String)object, 16);
                ++n4;
            }
            int n5 = nArray.length + nArray2.length;
            object = new int[n5];
            System.arraycopy(nArray, 0, object, 0, nArray.length);
            System.arraycopy(nArray2, 0, object, nArray.length, nArray2.length);
            nArray = object;
        }
        return nArray;
    }

    private void initTerminalNames() {
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        this.terminalNames = new TreeMap();
        String string = "Serif";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "SansSerif";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "Monospaced";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "Dialog";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "DialogInput";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        if (this.fprops == null) {
            throw new Error("no font properties file found.");
        }
        Object[] objectArray = this.fprops.keySet().toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            String string2;
            String string3;
            String string4 = (String)objectArray[n2];
            int n3 = string4.indexOf(".");
            if (n3 == -1) {
                n3 = string4.length();
            }
            if (treeMap.containsKey(string3 = string4.substring(0, n3)) && (n3 = string4.lastIndexOf(".")) != -1 && !this.terminalNames.containsKey(string2 = string4.substring(0, n3)) && this.fprops.containsKey(string2 + ".0")) {
                int n4 = 0;
                while (this.fprops.containsKey(string2 + "." + n4)) {
                    ++n4;
                }
                if (n4 != 0) {
                    this.terminalNames.put(string2, new Integer(n4));
                    if (debugMapping) {
                        System.out.println("FamilyStyle: " + string2);
                        System.out.println("NumSlots: " + n4);
                        System.out.println("Key: " + (String)objectArray[n2]);
                    }
                    int n5 = 0;
                    while (n5 < n4) {
                        String string5 = this.getFontPropertyFD(this.fprops.getProperty(string2 + "." + n5));
                        this.addPlatformNameForFontProperties(string5);
                        String string6 = this.getFileNameFromPlatformName(string5);
                        if (debugMapping) {
                            System.out.println("FS: [" + string2 + "." + n5 + "] PN: [" + string5 + "] FN: [" + string6 + "]");
                        }
                        if (string6 == null) {
                            if (debugMapping) {
                                System.err.println("Font specified in font.properties not found [" + string5 + "]");
                            }
                            this.loadFonts();
                        } else {
                            HashSet hashSet = (HashSet)treeMap2.get(string6);
                            if (hashSet == null) {
                                hashSet = new HashSet();
                                hashSet.add(string5);
                                treeMap2.put(string6, hashSet);
                            } else if (!hashSet.contains(string5)) {
                                hashSet.add(string5);
                            }
                        }
                        ++n5;
                    }
                }
            }
            ++n2;
        }
        this.registerFontPropertiesFonts(treeMap2);
    }

    protected void addPlatformNameForFontProperties(String string) {
    }

    protected void registerFontPropertiesFonts(TreeMap treeMap) {
        Object[] objectArray = treeMap.keySet().toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            String string = (String)objectArray[n2];
            HashSet hashSet = (HashSet)treeMap.get(string);
            String[] stringArray = (String[])hashSet.toArray(new String[0]);
            Vector vector = this.getNativeNames(string);
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!vector.contains(stringArray[n3])) {
                    vector.add(stringArray[n3]);
                }
                ++n3;
            }
            this.registerFontFile(string, vector);
            ++n2;
        }
    }

    protected boolean isLocalHead() {
        return true;
    }

    public static String styleStr(int n2) {
        switch (n2) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    public static boolean isLogicalFont(Font font) {
        String string = font.getName().toLowerCase();
        int n2 = 0;
        while (n2 < logicalFontNames.length) {
            if (string.equals(logicalFontNames[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String createFont(File file) {
        return NativeFontWrapper.createFont(file.getAbsolutePath(), 0);
    }

    private static short getLcidFromLocale(Locale locale) {
        String string;
        short s2 = 1033;
        if (locale.equals(Locale.US)) {
            return s2;
        }
        try {
            ResourceBundle resourceBundle = LocaleData.getLocaleElements(locale);
            string = resourceBundle.getString("LocaleID");
        }
        catch (MissingResourceException missingResourceException) {
            return s2;
        }
        try {
            s2 = (short)Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return s2;
    }

    public FontProperties getFontProperties() {
        return this.fprops;
    }

    public static Rectangle getUsableBounds(GraphicsDevice graphicsDevice) {
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Rectangle rectangle = graphicsConfiguration.getBounds();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    static {
        logicalFontNames = new String[]{"default", "serif", "sansserif", "monospaced", "dialog", "dialoginput"};
    }

    public class T1Filter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".ps") || string.endsWith(".PS") || string.endsWith(".pfb") || string.endsWith(".PFB") || string.endsWith(".pfa") || string.endsWith(".PFA");
        }
    }

    public class T2KFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".t2k") || string.endsWith(".T2K");
        }
    }

    public class TTFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".ttf") || string.endsWith(".TTF") || string.endsWith(".ttc") || string.endsWith(".TTC");
        }
    }
}

