/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.Keywords;
import org.apache.xpath.compiler.Lexer;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XString;

public class XPathParser {
    private OpMap m_ops;
    transient String m_token;
    transient char m_tokenChar = '\u0000';
    int m_queueMark = 0;
    PrefixResolver m_namespaceContext;
    private ErrorListener m_errorListener;
    SourceLocator m_sourceLocator;

    public XPathParser(ErrorListener errorListener, SourceLocator sourceLocator) {
        this.m_errorListener = errorListener;
        this.m_sourceLocator = sourceLocator;
    }

    public void initXPath(Compiler compiler, String string, PrefixResolver prefixResolver) throws TransformerException {
        this.m_ops = compiler;
        this.m_namespaceContext = prefixResolver;
        Lexer lexer = new Lexer(compiler, prefixResolver, this);
        lexer.tokenize(string);
        this.m_ops.m_opMap[0] = 1;
        this.m_ops.m_opMap[1] = 2;
        this.nextToken();
        this.Expr();
        if (null != this.m_token) {
            String string2 = "";
            while (null != this.m_token) {
                string2 = string2 + "'" + this.m_token + "'";
                this.nextToken();
                if (null == this.m_token) continue;
                string2 = string2 + ", ";
            }
            this.error(25, new Object[]{string2});
        }
        compiler.shrink();
    }

    public void initMatchPattern(Compiler compiler, String string, PrefixResolver prefixResolver) throws TransformerException {
        this.m_ops = compiler;
        this.m_namespaceContext = prefixResolver;
        Lexer lexer = new Lexer(compiler, prefixResolver, this);
        lexer.tokenize(string);
        this.m_ops.m_opMap[0] = 30;
        this.m_ops.m_opMap[1] = 2;
        this.nextToken();
        this.Pattern();
        if (null != this.m_token) {
            String string2 = "";
            while (null != this.m_token) {
                string2 = string2 + "'" + this.m_token + "'";
                this.nextToken();
                if (null == this.m_token) continue;
                string2 = string2 + ", ";
            }
            this.error(25, new Object[]{string2});
        }
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.m_ops.shrink();
    }

    public void setErrorHandler(ErrorListener errorListener) {
        this.m_errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    final boolean tokenIs(String string) {
        return this.m_token != null ? this.m_token.equals(string) : string == null;
    }

    final boolean tokenIs(char c2) {
        return this.m_token != null ? this.m_tokenChar == c2 : false;
    }

    final boolean lookahead(char c2, int n2) {
        String string;
        int n3 = this.m_queueMark + n2;
        boolean bl2 = n3 <= this.m_ops.m_tokenQueueSize && n3 > 0 && this.m_ops.m_tokenQueueSize != 0 ? ((string = (String)this.m_ops.m_tokenQueue[n3 - 1]).length() == 1 ? string.charAt(0) == c2 : false) : false;
        return bl2;
    }

    private final boolean lookbehind(char c2, int n2) {
        boolean bl2;
        int n3 = this.m_queueMark - (n2 + 1);
        if (n3 >= 0) {
            String string = (String)this.m_ops.m_tokenQueue[n3];
            if (string.length() == 1) {
                char c3;
                char c4 = c3 = string == null ? (char)'|' : (char)string.charAt(0);
                bl2 = c3 == '|' ? false : c3 == c2;
            } else {
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private final boolean lookbehindHasToken(int n2) {
        boolean bl2;
        if (this.m_queueMark - n2 > 0) {
            String string = (String)this.m_ops.m_tokenQueue[this.m_queueMark - (n2 - 1)];
            int n3 = string == null ? 124 : (int)string.charAt(0);
            bl2 = n3 != 124;
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private final boolean lookahead(String string, int n2) {
        String string2;
        boolean bl2 = this.m_queueMark + n2 <= this.m_ops.m_tokenQueueSize ? ((string2 = (String)this.m_ops.m_tokenQueue[this.m_queueMark + (n2 - 1)]) != null ? string2.equals(string) : string == null) : null == string;
        return bl2;
    }

    private final void nextToken() {
        if (this.m_queueMark < this.m_ops.m_tokenQueueSize) {
            this.m_token = (String)this.m_ops.m_tokenQueue[this.m_queueMark++];
            this.m_tokenChar = this.m_token.charAt(0);
        } else {
            this.m_token = null;
            this.m_tokenChar = '\u0000';
        }
    }

    private final String getTokenRelative(int n2) {
        int n3 = this.m_queueMark + n2;
        String string = n3 > 0 && n3 < this.m_ops.m_tokenQueueSize ? (String)this.m_ops.m_tokenQueue[n3] : null;
        return string;
    }

    private final void prevToken() {
        if (this.m_queueMark > 0) {
            --this.m_queueMark;
            this.m_token = (String)this.m_ops.m_tokenQueue[this.m_queueMark];
            this.m_tokenChar = this.m_token.charAt(0);
        } else {
            this.m_token = null;
            this.m_tokenChar = '\u0000';
        }
    }

    private final void consumeExpected(String string) throws TransformerException {
        if (this.tokenIs(string)) {
            this.nextToken();
        } else {
            this.error(29, new Object[]{string, this.m_token});
        }
    }

    private final void consumeExpected(char c2) throws TransformerException {
        if (this.tokenIs(c2)) {
            this.nextToken();
        } else {
            this.error(29, new Object[]{String.valueOf(c2), this.m_token});
        }
    }

    void warn(int n2, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHWarning(n2, objectArray);
        ErrorListener errorListener = this.getErrorListener();
        if (null != errorListener) {
            errorListener.warning(new TransformerException(string, this.m_sourceLocator));
        } else {
            System.err.println(string);
        }
    }

    private void assertion(boolean bl2, String string) {
        if (!bl2) {
            String string2 = XSLMessages.createXPATHMessage(30, new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    void error(int n2, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n2, objectArray);
        ErrorListener errorListener = this.getErrorListener();
        TransformerException transformerException = new TransformerException(string, this.m_sourceLocator);
        if (null == errorListener) {
            throw transformerException;
        }
        errorListener.fatalError(transformerException);
    }

    protected String dumpRemainingTokenQueue() {
        String string;
        int n2 = this.m_queueMark;
        if (n2 < this.m_ops.m_tokenQueueSize) {
            String string2 = "\n Remaining tokens: (";
            while (n2 < this.m_ops.m_tokenQueueSize) {
                String string3 = (String)this.m_ops.m_tokenQueue[n2++];
                string2 = string2 + " '" + string3 + "'";
            }
            string = string2 + ")";
        } else {
            string = "";
        }
        return string;
    }

    final int getFunctionToken(String string) {
        int n2;
        try {
            n2 = (Integer)Keywords.m_functions.get(string);
        }
        catch (NullPointerException nullPointerException) {
            n2 = -1;
        }
        catch (ClassCastException classCastException) {
            n2 = -1;
        }
        return n2;
    }

    void insertOp(int n2, int n3, int n4) {
        int n5 = this.m_ops.m_opMap[1];
        int n6 = n5 - 1;
        while (n6 >= n2) {
            this.m_ops.m_opMap[n6 + n3] = this.m_ops.m_opMap[n6];
            --n6;
        }
        this.m_ops.m_opMap[n2] = n4;
        this.m_ops.m_opMap[1] = n5 + n3;
    }

    void appendOp(int n2, int n3) {
        int n4 = this.m_ops.m_opMap[1];
        this.m_ops.m_opMap[n4] = n3;
        this.m_ops.m_opMap[n4 + 1] = n2;
        this.m_ops.m_opMap[1] = n4 + n2;
    }

    protected void Expr() throws TransformerException {
        this.OrExpr();
    }

    protected void OrExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.AndExpr();
        if (null != this.m_token && this.tokenIs("or")) {
            this.nextToken();
            this.insertOp(n2, 2, 2);
            this.OrExpr();
            this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
        }
    }

    protected void AndExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.EqualityExpr(-1);
        if (null != this.m_token && this.tokenIs("and")) {
            this.nextToken();
            this.insertOp(n2, 2, 3);
            this.AndExpr();
            this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
        }
    }

    protected int EqualityExpr(int n2) throws TransformerException {
        int n3 = this.m_ops.m_opMap[1];
        if (-1 == n2) {
            n2 = n3;
        }
        this.RelationalExpr(-1);
        if (null != this.m_token) {
            if (this.tokenIs('!') && this.lookahead('=', 1)) {
                this.nextToken();
                this.nextToken();
                this.insertOp(n2, 2, 4);
                int n4 = this.m_ops.m_opMap[1] - n2;
                n2 = this.EqualityExpr(n2);
                this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[n2 + n4 + 1] + n4;
                n2 += 2;
            } else if (this.tokenIs('=')) {
                this.nextToken();
                this.insertOp(n2, 2, 5);
                int n5 = this.m_ops.m_opMap[1] - n2;
                n2 = this.EqualityExpr(n2);
                this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[n2 + n5 + 1] + n5;
                n2 += 2;
            }
        }
        return n2;
    }

    protected int RelationalExpr(int n2) throws TransformerException {
        int n3 = this.m_ops.m_opMap[1];
        if (-1 == n2) {
            n2 = n3;
        }
        this.AdditiveExpr(-1);
        if (null != this.m_token) {
            if (this.tokenIs('<')) {
                this.nextToken();
                if (this.tokenIs('=')) {
                    this.nextToken();
                    this.insertOp(n2, 2, 6);
                } else {
                    this.insertOp(n2, 2, 7);
                }
                int n4 = this.m_ops.m_opMap[1] - n2;
                n2 = this.RelationalExpr(n2);
                this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[n2 + n4 + 1] + n4;
                n2 += 2;
            } else if (this.tokenIs('>')) {
                this.nextToken();
                if (this.tokenIs('=')) {
                    this.nextToken();
                    this.insertOp(n2, 2, 8);
                } else {
                    this.insertOp(n2, 2, 9);
                }
                int n5 = this.m_ops.m_opMap[1] - n2;
                n2 = this.RelationalExpr(n2);
                this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[n2 + n5 + 1] + n5;
                n2 += 2;
            }
        }
        return n2;
    }

    protected int AdditiveExpr(int n2) throws TransformerException {
        int n3 = this.m_ops.m_opMap[1];
        if (-1 == n2) {
            n2 = n3;
        }
        this.MultiplicativeExpr(-1);
        if (null != this.m_token) {
            if (this.tokenIs('+')) {
                this.nextToken();
                this.insertOp(n2, 2, 10);
                int n4 = this.m_ops.m_opMap[1] - n2;
                n2 = this.AdditiveExpr(n2);
                this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[n2 + n4 + 1] + n4;
                n2 += 2;
            } else if (this.tokenIs('-')) {
                this.nextToken();
                this.insertOp(n2, 2, 11);
                int n5 = this.m_ops.m_opMap[1] - n2;
                n2 = this.AdditiveExpr(n2);
                this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[n2 + n5 + 1] + n5;
                n2 += 2;
            }
        }
        return n2;
    }

    protected int MultiplicativeExpr(int n2) throws TransformerException {
        int n3 = this.m_ops.m_opMap[1];
        if (-1 == n2) {
            n2 = n3;
        }
        this.UnaryExpr();
        if (null != this.m_token) {
            if (this.tokenIs('*')) {
                this.nextToken();
                this.insertOp(n2, 2, 12);
                int n4 = this.m_ops.m_opMap[1] - n2;
                n2 = this.MultiplicativeExpr(n2);
                this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[n2 + n4 + 1] + n4;
                n2 += 2;
            } else if (this.tokenIs("div")) {
                this.nextToken();
                this.insertOp(n2, 2, 13);
                int n5 = this.m_ops.m_opMap[1] - n2;
                n2 = this.MultiplicativeExpr(n2);
                this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[n2 + n5 + 1] + n5;
                n2 += 2;
            } else if (this.tokenIs("mod")) {
                this.nextToken();
                this.insertOp(n2, 2, 14);
                int n6 = this.m_ops.m_opMap[1] - n2;
                n2 = this.MultiplicativeExpr(n2);
                this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[n2 + n6 + 1] + n6;
                n2 += 2;
            } else if (this.tokenIs("quo")) {
                this.nextToken();
                this.insertOp(n2, 2, 15);
                int n7 = this.m_ops.m_opMap[1] - n2;
                n2 = this.MultiplicativeExpr(n2);
                this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[n2 + n7 + 1] + n7;
                n2 += 2;
            }
        }
        return n2;
    }

    protected void UnaryExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        boolean bl2 = false;
        if (this.m_tokenChar == '-') {
            this.nextToken();
            this.appendOp(2, 16);
            bl2 = true;
        }
        this.UnionExpr();
        if (bl2) {
            this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
        }
    }

    protected void StringExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.appendOp(2, 17);
        this.Expr();
        this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
    }

    protected void BooleanExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.appendOp(2, 18);
        this.Expr();
        int n3 = this.m_ops.m_opMap[1] - n2;
        if (n3 == 2) {
            this.error(31, null);
        }
        this.m_ops.m_opMap[n2 + 1] = n3;
    }

    protected void NumberExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.appendOp(2, 19);
        this.Expr();
        this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
    }

    protected void UnionExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        boolean bl2 = true;
        boolean bl3 = false;
        do {
            this.PathExpr();
            if (!this.tokenIs('|')) break;
            if (!bl3) {
                bl3 = true;
                this.insertOp(n2, 2, 20);
            }
            this.nextToken();
        } while (bl2);
        this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
    }

    protected void PathExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.FilterExpr();
        if (this.tokenIs('/')) {
            this.nextToken();
            this.insertOp(n2, 2, 28);
            this.RelativeLocationPath();
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
        }
    }

    protected void FilterExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.PrimaryExpr();
        if (this.tokenIs('[')) {
            this.insertOp(n2, 2, 28);
            while (this.tokenIs('[')) {
                this.Predicate();
            }
            if (this.tokenIs('/')) {
                this.nextToken();
                this.RelativeLocationPath();
            }
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
        }
    }

    protected void PrimaryExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        if (this.m_tokenChar == '\'' || this.m_tokenChar == '\"') {
            this.appendOp(2, 21);
            this.Literal();
            this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
        } else if (this.m_tokenChar == '$') {
            this.nextToken();
            this.appendOp(2, 22);
            this.QName();
            this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
        } else if (this.m_tokenChar == '(') {
            this.nextToken();
            this.appendOp(2, 23);
            this.Expr();
            this.consumeExpected(')');
            this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
        } else if (null != this.m_token && ('.' == this.m_tokenChar && this.m_token.length() > 1 && Character.isDigit(this.m_token.charAt(1)) || Character.isDigit(this.m_tokenChar))) {
            this.appendOp(2, 27);
            this.Number();
            this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
        } else if (this.lookahead('(', 1) || this.lookahead(':', 1) && this.lookahead('(', 3)) {
            this.FunctionCall();
        } else {
            this.LocationPath();
        }
    }

    protected void Argument() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.appendOp(2, 26);
        this.Expr();
        this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
    }

    protected void FunctionCall() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        if (this.lookahead(':', 1)) {
            this.appendOp(4, 24);
            this.m_ops.m_opMap[n2 + 1 + 1] = this.m_queueMark - 1;
            this.nextToken();
            this.consumeExpected(':');
            this.m_ops.m_opMap[n2 + 1 + 2] = this.m_queueMark - 1;
            this.nextToken();
        } else {
            int n3 = this.getFunctionToken(this.m_token);
            if (-1 == n3) {
                this.error(47, new Object[]{this.m_token});
            }
            switch (n3) {
                case 1030: 
                case 1031: 
                case 1032: 
                case 1033: {
                    this.LocationPath();
                    return;
                }
            }
            this.appendOp(3, 25);
            this.m_ops.m_opMap[n2 + 1 + 1] = n3;
            this.nextToken();
        }
        this.consumeExpected('(');
        while (!this.tokenIs(')') && this.m_token != null) {
            if (this.tokenIs(',')) {
                this.error(32, null);
            }
            this.Argument();
            if (this.tokenIs(')')) continue;
            this.consumeExpected(',');
            if (!this.tokenIs(')')) continue;
            this.error(33, null);
        }
        this.consumeExpected(')');
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
    }

    protected void LocationPath() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.appendOp(2, 28);
        if (this.tokenIs('/')) {
            this.appendOp(4, 50);
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 2] = 4;
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 1] = 35;
            this.nextToken();
        }
        if (this.m_token != null) {
            this.RelativeLocationPath();
        }
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
    }

    protected void RelativeLocationPath() throws TransformerException {
        this.Step();
        while (this.tokenIs('/')) {
            this.nextToken();
            this.Step();
        }
    }

    protected void Step() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        if (this.tokenIs(".")) {
            this.nextToken();
            if (this.tokenIs('[')) {
                this.error(34, null);
            }
            this.appendOp(4, 48);
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 2] = 4;
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 1] = 1033;
        } else if (this.tokenIs("..")) {
            this.nextToken();
            this.appendOp(4, 45);
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 2] = 4;
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 1] = 1033;
        } else if (this.tokenIs('*') || this.tokenIs('@') || this.tokenIs('/') || this.tokenIs('_') || this.m_token != null && Character.isLetter(this.m_token.charAt(0))) {
            this.Basis();
            while (this.tokenIs('[')) {
                this.Predicate();
            }
            this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
        }
    }

    protected void Basis() throws TransformerException {
        int n2;
        int n3 = this.m_ops.m_opMap[1];
        if (this.lookahead("::", 1)) {
            n2 = this.AxisName();
            this.nextToken();
            this.nextToken();
        } else if (this.tokenIs('@')) {
            n2 = 39;
            this.appendOp(2, n2);
            this.nextToken();
        } else {
            if (this.tokenIs('/')) {
                int n4 = 42;
                this.appendOp(2, n4);
                this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = 1033;
                this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
                this.m_ops.m_opMap[n3 + 1 + 1] = this.m_ops.m_opMap[1] - n3;
                return;
            }
            n2 = 40;
            this.appendOp(2, n2);
        }
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.NodeTest(n2);
        this.m_ops.m_opMap[n3 + 1 + 1] = this.m_ops.m_opMap[1] - n3;
    }

    protected int AxisName() throws TransformerException {
        Object object = Keywords.m_axisnames.get(this.m_token);
        if (null == object) {
            this.error(35, new Object[]{this.m_token});
        }
        int n2 = (Integer)object;
        this.appendOp(2, n2);
        return n2;
    }

    protected void NodeTest(int n2) throws TransformerException {
        if (this.lookahead('(', 1)) {
            Object object = Keywords.m_nodetypes.get(this.m_token);
            if (null == object) {
                this.error(36, new Object[]{this.m_token});
            } else {
                int n3;
                this.nextToken();
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = n3 = ((Integer)object).intValue();
                this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
                this.consumeExpected('(');
                if (1032 == n3 && !this.tokenIs(')')) {
                    this.Literal();
                }
                this.consumeExpected(')');
            }
        } else {
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = 34;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            if (this.lookahead(':', 1)) {
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.tokenIs('*') ? -3 : this.m_queueMark - 1;
                this.nextToken();
                this.consumeExpected(':');
            } else {
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -2;
            }
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            if (this.tokenIs('*')) {
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -3;
            } else {
                if (49 == n2) {
                    String string = (String)this.m_ops.m_tokenQueue[this.m_queueMark - 1];
                    String string2 = this.m_namespaceContext.getNamespaceForPrefix(string);
                    this.m_ops.m_tokenQueue[this.m_queueMark - 1] = string2;
                }
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.m_queueMark - 1;
            }
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.nextToken();
        }
    }

    protected void Predicate() throws TransformerException {
        if (this.tokenIs('[')) {
            this.nextToken();
            this.PredicateExpr();
            this.consumeExpected(']');
        }
    }

    protected void PredicateExpr() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.appendOp(2, 29);
        this.Expr();
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
    }

    protected void QName() throws TransformerException {
        if (this.lookahead(':', 1)) {
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.m_queueMark - 1;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.nextToken();
            this.consumeExpected(':');
        } else {
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -2;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        }
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.m_queueMark - 1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.nextToken();
    }

    protected void NCName() {
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.m_queueMark - 1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.nextToken();
    }

    protected void Literal() throws TransformerException {
        int n2 = this.m_token.length() - 1;
        char c2 = this.m_tokenChar;
        char c3 = this.m_token.charAt(n2);
        if (c2 == '\"' && c3 == '\"' || c2 == '\'' && c3 == '\'') {
            int n3 = this.m_queueMark - 1;
            this.m_ops.m_tokenQueue[n3] = null;
            XString xString = new XString(this.m_token.substring(1, n2));
            this.m_ops.m_tokenQueue[n3] = xString;
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = n3;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.nextToken();
        } else {
            this.error(37, new Object[]{this.m_token});
        }
    }

    protected void Number() throws TransformerException {
        if (null != this.m_token) {
            double d2;
            try {
                d2 = Double.valueOf(this.m_token);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = 0.0;
                this.error(38, new Object[]{this.m_token});
            }
            this.m_ops.m_tokenQueue[this.m_queueMark - 1] = new XNumber(d2);
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.m_queueMark - 1;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.nextToken();
        }
    }

    protected void Pattern() throws TransformerException {
        while (true) {
            this.LocationPathPattern();
            if (!this.tokenIs('|')) break;
            this.nextToken();
        }
    }

    protected void LocationPathPattern() throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        this.appendOp(2, 31);
        if (this.lookahead('(', 1) && (this.tokenIs("id") || this.tokenIs("key"))) {
            this.IdKeyPattern();
            if (this.tokenIs('/') && this.lookahead('/', 1)) {
                this.appendOp(4, 52);
                this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 2] = 4;
                this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 1] = 1034;
                this.nextToken();
                this.nextToken();
            }
        } else if (this.tokenIs('/')) {
            if (this.lookahead('/', 1)) {
                this.appendOp(4, 52);
            } else {
                this.appendOp(4, 50);
            }
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 2] = 4;
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 1] = 35;
            this.nextToken();
        }
        if (!this.tokenIs('|') && null != this.m_token) {
            this.RelativePathPattern();
        }
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
    }

    protected void IdKeyPattern() throws TransformerException {
        this.FunctionCall();
    }

    protected void RelativePathPattern() throws TransformerException {
        this.StepPattern();
        while (this.tokenIs('/')) {
            this.nextToken();
            this.StepPattern();
        }
    }

    protected void StepPattern() throws TransformerException {
        this.AbbreviatedNodeTestStep();
    }

    protected void AbbreviatedNodeTestStep() throws TransformerException {
        int n2;
        int n3 = this.m_ops.m_opMap[1];
        int n4 = -1;
        if (this.tokenIs('@')) {
            n2 = 51;
            this.appendOp(2, n2);
            this.nextToken();
        } else if (this.lookahead("::", 1)) {
            if (this.tokenIs("attribute")) {
                n2 = 51;
                this.appendOp(2, n2);
            } else if (this.tokenIs("child")) {
                n2 = 53;
                this.appendOp(2, n2);
            } else {
                n2 = -1;
                this.error(44, new Object[]{this.m_token});
            }
            this.nextToken();
            this.nextToken();
        } else if (this.tokenIs('/')) {
            n2 = 52;
            this.appendOp(2, n2);
            this.nextToken();
        } else {
            if (this.tokenIs('/')) {
                this.nextToken();
            }
            n4 = this.m_ops.m_opMap[1];
            n2 = 53;
            this.appendOp(2, n2);
        }
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.NodeTest(n2);
        this.m_ops.m_opMap[n3 + 1 + 1] = this.m_ops.m_opMap[1] - n3;
        while (this.tokenIs('[')) {
            this.Predicate();
        }
        if (n4 > -1 && this.tokenIs('/') && this.lookahead('/', 1)) {
            this.m_ops.m_opMap[n4] = 52;
            this.nextToken();
        }
        this.m_ops.m_opMap[n3 + 1] = this.m_ops.m_opMap[1] - n3;
    }
}

