/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.trace;

import java.util.TooManyListenersException;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.trace.EndSelectionEvent;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.trace.TraceListenerEx;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.XPath;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class TraceManager {
    private TransformerImpl m_transformer;
    private Vector m_traceListeners = null;

    public TraceManager(TransformerImpl transformerImpl) {
        this.m_transformer = transformerImpl;
    }

    public void addTraceListener(TraceListener traceListener) throws TooManyListenersException {
        TransformerImpl.S_DEBUG = true;
        if (null == this.m_traceListeners) {
            this.m_traceListeners = new Vector();
        }
        this.m_traceListeners.addElement(traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        if (null != this.m_traceListeners) {
            this.m_traceListeners.removeElement(traceListener);
        }
    }

    public void fireGenerateEvent(GenerateEvent generateEvent) {
        if (null != this.m_traceListeners) {
            int n2 = this.m_traceListeners.size();
            int n3 = 0;
            while (n3 < n2) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n3);
                traceListener.generated(generateEvent);
                ++n3;
            }
        }
    }

    public boolean hasTraceListeners() {
        return null != this.m_traceListeners;
    }

    public void fireTraceEvent(ElemTemplateElement elemTemplateElement) {
        if (this.hasTraceListeners()) {
            int n2 = this.m_transformer.getXPathContext().getCurrentNode();
            Node node = this.m_transformer.getXPathContext().getDTM(n2).getNode(n2);
            this.fireTraceEvent(new TracerEvent(this.m_transformer, node, this.m_transformer.getMode(), elemTemplateElement));
        }
    }

    public void fireTraceEvent(TracerEvent tracerEvent) {
        if (this.hasTraceListeners()) {
            int n2 = this.m_traceListeners.size();
            int n3 = 0;
            while (n3 < n2) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n3);
                traceListener.trace(tracerEvent);
                ++n3;
            }
        }
    }

    public void fireSelectedEvent(int n2, ElemTemplateElement elemTemplateElement, String string, XPath xPath, XObject xObject) throws TransformerException {
        if (this.hasTraceListeners()) {
            Node node = this.m_transformer.getXPathContext().getDTM(n2).getNode(n2);
            this.fireSelectedEvent(new SelectionEvent(this.m_transformer, node, elemTemplateElement, string, xPath, xObject));
        }
    }

    public void fireSelectedEndEvent(int n2, ElemTemplateElement elemTemplateElement, String string, XPath xPath, XObject xObject) throws TransformerException {
        if (this.hasTraceListeners()) {
            Node node = this.m_transformer.getXPathContext().getDTM(n2).getNode(n2);
            this.fireSelectedEndEvent(new EndSelectionEvent(this.m_transformer, node, elemTemplateElement, string, xPath, xObject));
        }
    }

    public void fireSelectedEndEvent(EndSelectionEvent endSelectionEvent) throws TransformerException {
        if (this.hasTraceListeners()) {
            int n2 = this.m_traceListeners.size();
            int n3 = 0;
            while (n3 < n2) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n3);
                if (traceListener instanceof TraceListenerEx) {
                    ((TraceListenerEx)traceListener).selectEnd(endSelectionEvent);
                }
                ++n3;
            }
        }
    }

    public void fireSelectedEvent(SelectionEvent selectionEvent) throws TransformerException {
        if (this.hasTraceListeners()) {
            int n2 = this.m_traceListeners.size();
            int n3 = 0;
            while (n3 < n2) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n3);
                traceListener.selected(selectionEvent);
                ++n3;
            }
        }
    }
}

