/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.xalan.processor.StopParseException;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.StylesheetPIHandler;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.transformer.TrAXFilter;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.DOM2Helper;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    public static String XSLT_PROPERTIES = "org/apache/xalan/res/XSLTInfo.properties";
    private static boolean isInited = false;
    private static final Class[] NO_CLASSES = new Class[0];
    private static final Object[] NO_OBJS = new Object[0];
    public static final String FEATURE_INCREMENTAL = "http://xml.apache.org/xalan/features/incremental";
    public static final String FEATURE_OPTIMIZE = "http://xml.apache.org/xalan/features/optimize";
    private String m_DOMsystemID = null;
    public static boolean m_optimize = true;
    URIResolver m_uriResolver;
    private ErrorListener m_errorListener = new DefaultErrorHandler();
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$xalan$processor$TransformerFactoryImpl;

    public TransformerFactoryImpl() {
        TransformerFactoryImpl.loadPropertyFileToSystem(XSLT_PROPERTIES);
    }

    private static void loadPropertyFileToSystem(String string) {
        if (!isInited) {
            try {
                InputStream inputStream = null;
                try {
                    Object object;
                    Object object2;
                    Properties properties = new Properties();
                    try {
                        object2 = (class$java$lang$Thread == null ? (class$java$lang$Thread = TransformerFactoryImpl.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", NO_CLASSES);
                        if (object2 != null) {
                            object = (ClassLoader)((Method)object2).invoke(Thread.currentThread(), NO_OBJS);
                            inputStream = ((ClassLoader)object).getResourceAsStream(string);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (inputStream == null) {
                        inputStream = (class$org$apache$xalan$processor$TransformerFactoryImpl == null ? (class$org$apache$xalan$processor$TransformerFactoryImpl = TransformerFactoryImpl.class$("org.apache.xalan.processor.TransformerFactoryImpl")) : class$org$apache$xalan$processor$TransformerFactoryImpl).getResourceAsStream("/" + string);
                    }
                    object2 = new BufferedInputStream(inputStream);
                    properties.load((InputStream)object2);
                    ((BufferedInputStream)object2).close();
                    object = System.getProperties();
                    Enumeration enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if (((Hashtable)object).containsKey(string2)) continue;
                        ((Hashtable)object).put(string2, properties.getProperty(string2));
                    }
                    System.setProperties((Properties)object);
                    isInited = true;
                }
                catch (Exception exception) {}
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public Templates processFromNode(Node node) throws TransformerConfigurationException {
        try {
            TemplatesHandler templatesHandler = this.newTemplatesHandler();
            TreeWalker treeWalker = new TreeWalker(templatesHandler, new DOM2Helper(), templatesHandler.getSystemId());
            treeWalker.traverse(node);
            return templatesHandler.getTemplates();
        }
        catch (SAXException sAXException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(sAXException));
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
                return null;
            }
            throw new TransformerConfigurationException(XSLMessages.createMessage(134, null), sAXException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw transformerConfigurationException;
        }
        catch (Exception exception) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(exception));
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
                return null;
            }
            throw new TransformerConfigurationException(XSLMessages.createMessage(134, null), exception);
        }
    }

    String getDOMsystemID() {
        return this.m_DOMsystemID;
    }

    Templates processFromNode(Node node, String string) throws TransformerConfigurationException {
        this.m_DOMsystemID = string;
        return this.processFromNode(node);
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        Object object;
        block14: {
            String string4;
            InputSource inputSource = null;
            Node node = null;
            XMLReader xMLReader = null;
            if (source instanceof DOMSource) {
                object = (DOMSource)source;
                node = ((DOMSource)object).getNode();
                string4 = ((DOMSource)object).getSystemId();
            } else {
                inputSource = SAXSource.sourceToInputSource(source);
                string4 = inputSource.getSystemId();
            }
            object = new StylesheetPIHandler(string4, string, string2, string3);
            if (this.m_uriResolver != null) {
                ((StylesheetPIHandler)object).setURIResolver(this.m_uriResolver);
            }
            try {
                if (null != node) {
                    TreeWalker treeWalker = new TreeWalker((ContentHandler)object, new DOM2Helper(), string4);
                    treeWalker.traverse(node);
                    break block14;
                }
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
                if (null == xMLReader) {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
                xMLReader.setContentHandler((ContentHandler)object);
                xMLReader.parse(inputSource);
            }
            catch (StopParseException stopParseException) {
            }
            catch (SAXException sAXException) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", sAXException);
            }
            catch (IOException iOException) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", iOException);
            }
        }
        return ((StylesheetPIHandler)object).getAssociatedStylesheet();
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new StylesheetHandler(this);
    }

    public boolean getFeature(String string) {
        if ("http://javax.xml.transform.dom.DOMResult/feature" == string || "http://javax.xml.transform.dom.DOMSource/feature" == string || "http://javax.xml.transform.sax.SAXResult/feature" == string || "http://javax.xml.transform.sax.SAXSource/feature" == string || "http://javax.xml.transform.stream.StreamResult/feature" == string || "http://javax.xml.transform.stream.StreamSource/feature" == string || "http://javax.xml.transform.sax.SAXTransformerFactory/feature" == string || "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter" == string) {
            return true;
        }
        return "http://javax.xml.transform.dom.DOMResult/feature".equals(string) || "http://javax.xml.transform.dom.DOMSource/feature".equals(string) || "http://javax.xml.transform.sax.SAXResult/feature".equals(string) || "http://javax.xml.transform.sax.SAXSource/feature".equals(string) || "http://javax.xml.transform.stream.StreamResult/feature".equals(string) || "http://javax.xml.transform.stream.StreamSource/feature".equals(string) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature".equals(string) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter".equals(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (string.equals(FEATURE_INCREMENTAL)) {
            if (object instanceof Boolean) {
                DTMManager.setIncremental((Boolean)object);
                return;
            } else {
                if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage(211, new Object[]{string, object}));
                DTMManager.setIncremental(new Boolean((String)object));
            }
            return;
        } else {
            if (!string.equals(FEATURE_OPTIMIZE)) throw new IllegalArgumentException(XSLMessages.createMessage(171, new Object[]{string}));
            if (object instanceof Boolean) {
                m_optimize = (Boolean)object;
                return;
            } else {
                if (!(object instanceof String)) throw new IllegalArgumentException(XSLMessages.createMessage(211, new Object[]{string, object}));
                m_optimize = new Boolean((String)object);
            }
        }
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if (string.equals(FEATURE_INCREMENTAL)) {
            return new Boolean(DTMManager.getIncremental());
        }
        if (string.equals(FEATURE_OPTIMIZE)) {
            return new Boolean(m_optimize);
        }
        throw new IllegalArgumentException(XSLMessages.createMessage(213, new Object[]{string}));
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException;
        }
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        if (templates == null) {
            return null;
        }
        return this.newTransformerHandler(templates);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        try {
            TransformerImpl transformerImpl = (TransformerImpl)templates.newTransformer();
            transformerImpl.setURIResolver(this.m_uriResolver);
            TransformerHandler transformerHandler = (TransformerHandler)transformerImpl.getInputContentHandler(true);
            return transformerHandler;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TransformerConfigurationException transformerConfigurationException2;
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    transformerConfigurationException2 = new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException2;
        }
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return new TransformerIdentityImpl();
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        try {
            Templates templates = this.newTemplates(source);
            if (templates == null) {
                return null;
            }
            Transformer transformer = templates.newTransformer();
            transformer.setURIResolver(this.m_uriResolver);
            return transformer;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TransformerConfigurationException transformerConfigurationException2;
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    transformerConfigurationException2 = new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException2;
        }
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerIdentityImpl();
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        Object object;
        String string;
        TemplatesHandler templatesHandler;
        block29: {
            templatesHandler = this.newTemplatesHandler();
            string = source.getSystemId();
            if (null == string) {
                try {
                    object = System.getProperty("user.dir");
                    if (((String)object).startsWith(File.separator)) {
                        string = "file://" + (String)object + File.separatorChar + source.getClass().getName();
                        break block29;
                    }
                    string = "file:///" + (String)object + File.separatorChar + source.getClass().getName();
                }
                catch (SecurityException securityException) {}
            } else {
                try {
                    string = SystemIDResolver.getAbsoluteURI(string);
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
        }
        templatesHandler.setSystemId(string);
        if (source instanceof DOMSource) {
            object = (DOMSource)source;
            Node node = ((DOMSource)object).getNode();
            if (null != node) {
                return this.processFromNode(node, string);
            }
            String string2 = XSLMessages.createMessage(108, null);
            throw new IllegalArgumentException(string2);
        }
        try {
            boolean bl2;
            object = SAXSource.sourceToInputSource(source);
            XMLReader xMLReader = null;
            if (source instanceof SAXSource) {
                xMLReader = ((SAXSource)source).getXMLReader();
            }
            boolean bl3 = bl2 = xMLReader != null;
            if (null == xMLReader) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xMLReader = sAXParser.getXMLReader();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    throw new SAXException(factoryConfigurationError.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            if (null == xMLReader) {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            try {
                if (!bl2) {
                    xMLReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                }
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            xMLReader.setContentHandler(templatesHandler);
            xMLReader.parse((InputSource)object);
        }
        catch (SAXException sAXException) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(sAXException));
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw new TransformerConfigurationException(sAXException.getMessage(), sAXException);
        }
        catch (Exception exception) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(exception));
                    return null;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(transformerException);
                }
            }
            throw new TransformerConfigurationException(exception.getMessage(), exception);
        }
        return templatesHandler.getTemplates();
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (null == errorListener) {
            throw new IllegalArgumentException("ErrorListener");
        }
        this.m_errorListener = errorListener;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

