/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.text.NavigationFilter;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    public static final String FOCUS_ACCELERATOR_KEY = "focusAcceleratorKey";
    private Document model;
    private transient Caret caret;
    private NavigationFilter navigationFilter;
    private transient Highlighter highlighter;
    private transient Keymap keymap;
    private transient MutableCaretEvent caretEvent;
    private Color caretColor;
    private Color selectionColor;
    private Color selectedTextColor;
    private Color disabledTextColor;
    private boolean editable;
    private Insets margin;
    private char focusAccelerator;
    private boolean dragEnabled;
    private static DefaultTransferHandler defaultTransferHandler;
    private static Map overrideMap;
    private static JTextComponent focusedComponent;
    private static Hashtable keymapTable;
    private JTextComponent editor;
    private transient InputMethodRequests inputMethodRequestsHandler;
    private AttributedString composedText;
    private String composedTextContent;
    private Position composedTextStart;
    private Position composedTextEnd;
    private Position latestCommittedTextStart;
    private Position latestCommittedTextEnd;
    private ComposedTextCaret composedTextCaret;
    private transient Caret originalCaret;
    private boolean checkedInputOverride;
    private boolean needToSendKeyTypedEvent;
    public static final String DEFAULT_KEYMAP = "default";
    static /* synthetic */ Class class$javax$swing$event$CaretListener;
    static /* synthetic */ Class class$javax$swing$text$JTextComponent;
    static /* synthetic */ Class class$java$awt$event$InputMethodEvent;

    public JTextComponent() {
        this.enableEvents(2056L);
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
        this.setEditable(true);
        this.setDragEnabled(false);
        this.setLayout(null);
        this.updateUI();
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void setUI(TextUI textUI) {
        super.setUI(textUI);
    }

    public void updateUI() {
        this.setUI((TextUI)UIManager.getUI(this));
        this.invalidate();
    }

    public void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = JTextComponent.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener, caretListener);
    }

    public void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = JTextComponent.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener, caretListener);
    }

    public CaretListener[] getCaretListeners() {
        return (CaretListener[])this.listenerList.getListeners(class$javax$swing$event$CaretListener == null ? (class$javax$swing$event$CaretListener = JTextComponent.class$("javax.swing.event.CaretListener")) : class$javax$swing$event$CaretListener);
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$CaretListener == null ? JTextComponent.class$("javax.swing.event.CaretListener") : class$javax$swing$event$CaretListener)) {
                ((CaretListener)objectArray[n2 + 1]).caretUpdate(caretEvent);
            }
            n2 -= 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocument(Document document) {
        Document document2 = this.model;
        try {
            if (document2 instanceof AbstractDocument) {
                ((AbstractDocument)document2).readLock();
            }
            if (this.accessibleContext != null) {
                this.model.removeDocumentListener((AccessibleJTextComponent)this.accessibleContext);
            }
            if (this.inputMethodRequestsHandler != null) {
                this.model.removeDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
            }
            this.model = document;
            Boolean bl2 = this.getComponentOrientation().isLeftToRight() ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
            document.putProperty(TextAttribute.RUN_DIRECTION, bl2);
            this.firePropertyChange("document", document2, document);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (document2 instanceof AbstractDocument) {
                ((AbstractDocument)document2).readUnlock();
            }
            throw throwable;
        }
        if (document2 instanceof AbstractDocument) {
            ((AbstractDocument)document2).readUnlock();
        }
        this.revalidate();
        this.repaint();
        if (this.accessibleContext != null) {
            this.model.addDocumentListener((AccessibleJTextComponent)this.accessibleContext);
        }
        if (this.inputMethodRequestsHandler != null) {
            this.model.addDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
        }
    }

    public Document getDocument() {
        return this.model;
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        Document document = this.getDocument();
        if (document != null) {
            Boolean bl2 = componentOrientation.isLeftToRight() ? TextAttribute.RUN_DIRECTION_LTR : TextAttribute.RUN_DIRECTION_RTL;
            document.putProperty(TextAttribute.RUN_DIRECTION, bl2);
        }
        super.setComponentOrientation(componentOrientation);
    }

    public Action[] getActions() {
        return this.getUI().getEditorKit(this).getActions();
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.invalidate();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setNavigationFilter(NavigationFilter navigationFilter) {
        this.navigationFilter = navigationFilter;
    }

    public NavigationFilter getNavigationFilter() {
        return this.navigationFilter;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        if (this.caret != null) {
            this.caret.removeChangeListener(this.caretEvent);
            this.caret.deinstall(this);
        }
        Caret caret2 = this.caret;
        this.caret = caret;
        if (this.caret != null) {
            this.caret.install(this);
            this.caret.addChangeListener(this.caretEvent);
        }
        this.firePropertyChange("caret", caret2, this.caret);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.highlighter != null) {
            this.highlighter.deinstall(this);
        }
        Highlighter highlighter2 = this.highlighter;
        this.highlighter = highlighter;
        if (this.highlighter != null) {
            this.highlighter.install(this);
        }
        this.firePropertyChange("highlighter", highlighter2, highlighter);
    }

    public void setKeymap(Keymap keymap) {
        Keymap keymap2 = this.keymap;
        this.keymap = keymap;
        this.firePropertyChange("keymap", keymap2, this.keymap);
        this.updateInputMap(keymap2, keymap);
    }

    public void setDragEnabled(boolean bl2) {
        if (bl2 && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl2;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    void updateInputMap(Keymap keymap, Keymap keymap2) {
        Serializable serializable;
        InputMap inputMap;
        InputMap inputMap2 = inputMap = this.getInputMap(0);
        while (inputMap != null && !(inputMap instanceof KeymapWrapper)) {
            inputMap2 = inputMap;
            inputMap = inputMap.getParent();
        }
        if (inputMap != null) {
            if (keymap2 == null) {
                if (inputMap2 != inputMap) {
                    inputMap2.setParent(inputMap.getParent());
                } else {
                    inputMap2.setParent(null);
                }
            } else {
                serializable = new KeymapWrapper(keymap2);
                inputMap2.setParent((InputMap)serializable);
                if (inputMap2 != inputMap) {
                    ((InputMap)serializable).setParent(inputMap.getParent());
                }
            }
        } else if (keymap2 != null && (inputMap = this.getInputMap(0)) != null) {
            serializable = new KeymapWrapper(keymap2);
            ((InputMap)serializable).setParent(inputMap.getParent());
            inputMap.setParent((InputMap)serializable);
        }
        serializable = this.getActionMap();
        ActionMap actionMap = serializable;
        while (serializable != null && !(serializable instanceof KeymapActionMap)) {
            actionMap = serializable;
            serializable = ((ActionMap)serializable).getParent();
        }
        if (serializable != null) {
            if (keymap2 == null) {
                if (actionMap != serializable) {
                    actionMap.setParent(((ActionMap)serializable).getParent());
                } else {
                    actionMap.setParent(null);
                }
            } else {
                KeymapActionMap keymapActionMap = new KeymapActionMap(keymap2);
                actionMap.setParent(keymapActionMap);
                if (actionMap != serializable) {
                    keymapActionMap.setParent(((ActionMap)serializable).getParent());
                }
            }
        } else if (keymap2 != null && (serializable = this.getActionMap()) != null) {
            KeymapActionMap keymapActionMap = new KeymapActionMap(keymap2);
            keymapActionMap.setParent(((ActionMap)serializable).getParent());
            ((ActionMap)serializable).setParent(keymapActionMap);
        }
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    public static Keymap addKeymap(String string, Keymap keymap) {
        DefaultKeymap defaultKeymap = new DefaultKeymap(string, keymap);
        if (string != null) {
            keymapTable.put(string, defaultKeymap);
        }
        return defaultKeymap;
    }

    public static Keymap removeKeymap(String string) {
        return (Keymap)keymapTable.remove(string);
    }

    public static Keymap getKeymap(String string) {
        return (Keymap)keymapTable.get(string);
    }

    public static void loadKeymap(Keymap keymap, KeyBinding[] keyBindingArray, Action[] actionArray) {
        Object object;
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        while (n2 < actionArray.length) {
            Action action = actionArray[n2];
            object = (String)action.getValue("Name");
            hashtable.put(object != null ? object : "", action);
            ++n2;
        }
        int n3 = 0;
        while (n3 < keyBindingArray.length) {
            object = (Action)hashtable.get(keyBindingArray[n3].actionName);
            if (object != null) {
                keymap.addActionForKeyStroke(keyBindingArray[n3].key, (Action)object);
            }
            ++n3;
        }
    }

    private static Boolean isProcessInputMethodEventOverridden(Class clazz) {
        if (clazz == (class$javax$swing$text$JTextComponent == null ? (class$javax$swing$text$JTextComponent = JTextComponent.class$("javax.swing.text.JTextComponent")) : class$javax$swing$text$JTextComponent)) {
            return Boolean.FALSE;
        }
        Boolean bl2 = (Boolean)overrideMap.get(clazz.getName());
        if (bl2 != null) {
            return bl2;
        }
        Boolean bl3 = JTextComponent.isProcessInputMethodEventOverridden(clazz.getSuperclass());
        if (bl3.booleanValue()) {
            overrideMap.put(clazz.getName(), bl3);
            return bl3;
        }
        try {
            Class[] classArray = new Class[]{class$java$awt$event$InputMethodEvent == null ? (class$java$awt$event$InputMethodEvent = JTextComponent.class$("java.awt.event.InputMethodEvent")) : class$java$awt$event$InputMethodEvent};
            Method method = clazz.getDeclaredMethod("processInputMethodEvent", classArray);
            bl2 = Boolean.TRUE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl2 = Boolean.FALSE;
        }
        overrideMap.put(clazz.getName(), bl2);
        return bl2;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color color) {
        Color color2 = this.caretColor;
        this.caretColor = color;
        this.firePropertyChange("caretColor", color2, this.caretColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        Color color2 = this.selectionColor;
        this.selectionColor = color;
        this.firePropertyChange("selectionColor", color2, this.selectionColor);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(Color color) {
        Color color2 = this.selectedTextColor;
        this.selectedTextColor = color;
        this.firePropertyChange("selectedTextColor", color2, this.selectedTextColor);
    }

    public Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(Color color) {
        Color color2 = this.disabledTextColor;
        this.disabledTextColor = color;
        this.firePropertyChange("disabledTextColor", color2, this.disabledTextColor);
    }

    public void replaceSelection(String string) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                int n2 = Math.min(this.caret.getDot(), this.caret.getMark());
                int n3 = Math.max(this.caret.getDot(), this.caret.getMark());
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).replace(n2, n3 - n2, string, null);
                } else {
                    if (n2 != n3) {
                        document.remove(n2, n3 - n2);
                    }
                    if (string != null && string.length() > 0) {
                        document.insertString(n2, string, null);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        }
    }

    public String getText(int n2, int n3) throws BadLocationException {
        return this.getDocument().getText(n2, n3);
    }

    public Rectangle modelToView(int n2) throws BadLocationException {
        return this.getUI().modelToView(this, n2);
    }

    public int viewToModel(Point point) {
        return this.getUI().viewToModel(this, point);
    }

    public void cut() {
        if (this.isEditable() && this.isEnabled()) {
            this.invokeAction("cut", TransferHandler.getCutAction());
        }
    }

    public void copy() {
        this.invokeAction("copy", TransferHandler.getCopyAction());
    }

    public void paste() {
        if (this.isEditable() && this.isEnabled()) {
            this.invokeAction("paste", TransferHandler.getPasteAction());
        }
    }

    private void invokeAction(String string, Action action) {
        ActionMap actionMap = this.getActionMap();
        Action action2 = null;
        if (actionMap != null) {
            action2 = actionMap.get(string);
        }
        if (action2 == null) {
            this.installDefaultTransferHandlerIfNecessary();
            action2 = action;
        }
        action2.actionPerformed(new ActionEvent(this, 1001, (String)action2.getValue("Name"), EventQueue.getMostRecentEventTime(), this.getCurrentEventModifiers()));
    }

    private void installDefaultTransferHandlerIfNecessary() {
        if (this.getTransferHandler() == null) {
            if (defaultTransferHandler == null) {
                defaultTransferHandler = new DefaultTransferHandler();
            }
            this.setTransferHandler(defaultTransferHandler);
        }
    }

    public void moveCaretPosition(int n2) {
        Document document = this.getDocument();
        if (document != null) {
            if (n2 > document.getLength() || n2 < 0) {
                throw new IllegalArgumentException("bad position: " + n2);
            }
            this.caret.moveDot(n2);
        }
    }

    public void setFocusAccelerator(char c2) {
        c2 = Character.toUpperCase(c2);
        char c3 = this.focusAccelerator;
        this.focusAccelerator = c2;
        this.firePropertyChange(FOCUS_ACCELERATOR_KEY, c3, this.focusAccelerator);
    }

    public char getFocusAccelerator() {
        return this.focusAccelerator;
    }

    public void read(Reader reader, Object object) throws IOException {
        EditorKit editorKit = this.getUI().getEditorKit(this);
        Document document = editorKit.createDefaultDocument();
        if (object != null) {
            document.putProperty("stream", object);
        }
        try {
            editorKit.read(reader, document, 0);
            this.setDocument(document);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void write(Writer writer) throws IOException {
        Document document = this.getDocument();
        try {
            this.getUI().getEditorKit(this).write(writer, document, 0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    public void setCaretPosition(int n2) {
        Document document = this.getDocument();
        if (document != null) {
            if (n2 > document.getLength() || n2 < 0) {
                throw new IllegalArgumentException("bad position: " + n2);
            }
            this.caret.setDot(n2);
        }
    }

    public int getCaretPosition() {
        return this.caret.getDot();
    }

    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }

    public String getText() {
        String string;
        Document document = this.getDocument();
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            string = null;
        }
        return string;
    }

    public String getSelectedText() {
        int n2;
        String string = null;
        int n3 = Math.min(this.caret.getDot(), this.caret.getMark());
        if (n3 != (n2 = Math.max(this.caret.getDot(), this.caret.getMark()))) {
            try {
                Document document = this.getDocument();
                string = document.getText(n3, n2 - n3);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
        return string;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl2) {
        if (bl2 != this.editable) {
            boolean bl3 = this.editable;
            this.editable = bl2;
            if (this.editable) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.firePropertyChange("editable", new Boolean(bl3), new Boolean(this.editable));
            this.repaint();
        }
    }

    public int getSelectionStart() {
        int n2 = Math.min(this.caret.getDot(), this.caret.getMark());
        return n2;
    }

    public void setSelectionStart(int n2) {
        this.select(n2, this.getSelectionEnd());
    }

    public int getSelectionEnd() {
        int n2 = Math.max(this.caret.getDot(), this.caret.getMark());
        return n2;
    }

    public void setSelectionEnd(int n2) {
        this.select(this.getSelectionStart(), n2);
    }

    public void select(int n2, int n3) {
        int n4 = this.getDocument().getLength();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n3 < n2) {
            n3 = n2;
        }
        this.setCaretPosition(n2);
        this.moveCaretPosition(n3);
    }

    public void selectAll() {
        Document document = this.getDocument();
        if (document != null) {
            this.setCaretPosition(0);
            this.moveCaretPosition(document.getLength());
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TextUI textUI;
        String string = super.getToolTipText(mouseEvent);
        if (string == null && (textUI = this.getUI()) != null) {
            string = textUI.getToolTipText(this, new Point(mouseEvent.getX(), mouseEvent.getY()));
        }
        return string;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        switch (n2) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n2);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        switch (n2) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n2);
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextComponent();
        }
        return this.accessibleContext;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.caretEvent = new MutableCaretEvent(this);
        this.addMouseListener(this.caretEvent);
        this.addFocusListener(this.caretEvent);
    }

    protected String paramString() {
        String string = this.editable ? "true" : "false";
        String string2 = this.caretColor != null ? this.caretColor.toString() : "";
        String string3 = this.selectionColor != null ? this.selectionColor.toString() : "";
        String string4 = this.selectedTextColor != null ? this.selectedTextColor.toString() : "";
        String string5 = this.disabledTextColor != null ? this.disabledTextColor.toString() : "";
        String string6 = this.margin != null ? this.margin.toString() : "";
        return super.paramString() + ",caretColor=" + string2 + ",disabledTextColor=" + string5 + ",editable=" + string + ",margin=" + string6 + ",selectedTextColor=" + string4 + ",selectionColor=" + string3;
    }

    static final JTextComponent getFocusedComponent() {
        return focusedComponent;
    }

    private int getCurrentEventModifiers() {
        int n2 = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n2 = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n2 = ((ActionEvent)aWTEvent).getModifiers();
        }
        return n2;
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        super.processInputMethodEvent(inputMethodEvent);
        if (!inputMethodEvent.isConsumed()) {
            if (!this.isEditable()) {
                return;
            }
            switch (inputMethodEvent.getID()) {
                case 1100: {
                    this.replaceInputMethodText(inputMethodEvent);
                }
                case 1101: {
                    this.setInputMethodCaretPosition(inputMethodEvent);
                }
            }
            inputMethodEvent.consume();
        }
    }

    public InputMethodRequests getInputMethodRequests() {
        if (this.inputMethodRequestsHandler == null) {
            this.inputMethodRequestsHandler = new InputMethodRequestsHandler();
            Document document = this.getDocument();
            if (document != null) {
                document.addDocumentListener((DocumentListener)((Object)this.inputMethodRequestsHandler));
            }
        }
        return this.inputMethodRequestsHandler;
    }

    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        super.addInputMethodListener(inputMethodListener);
        if (inputMethodListener != null) {
            this.needToSendKeyTypedEvent = false;
            this.checkedInputOverride = true;
        }
    }

    private void replaceInputMethodText(InputMethodEvent inputMethodEvent) {
        int n2;
        int n3 = inputMethodEvent.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        Document document = this.getDocument();
        if (this.composedTextStart != null) {
            try {
                n2 = this.composedTextStart.getOffset();
                document.remove(n2, this.composedTextEnd.getOffset() - n2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.composedTextEnd = null;
            this.composedTextStart = null;
            this.composedText = null;
            this.composedTextContent = null;
        }
        if (attributedCharacterIterator != null) {
            int n4;
            attributedCharacterIterator.first();
            n2 = 0;
            int n5 = 0;
            if (n3 > 0) {
                n2 = this.caret.getDot();
                if (this.shouldSynthensizeKeyEvents()) {
                    char c2 = attributedCharacterIterator.current();
                    while (n3 > 0) {
                        KeyEvent keyEvent = new KeyEvent(this, 400, EventQueue.getMostRecentEventTime(), 0, 0, c2);
                        this.processKeyEvent(keyEvent);
                        c2 = attributedCharacterIterator.next();
                        --n3;
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    char c3 = attributedCharacterIterator.current();
                    while (n3 > 0) {
                        stringBuffer.append(c3);
                        c3 = attributedCharacterIterator.next();
                        --n3;
                    }
                    this.mapCommittedTextToAction(new String(stringBuffer));
                }
                n5 = this.caret.getDot();
            }
            if ((n4 = attributedCharacterIterator.getIndex()) < attributedCharacterIterator.getEndIndex()) {
                this.createComposedString(n4, attributedCharacterIterator);
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(StyleConstants.ComposedTextAttribute, this.composedText);
                try {
                    this.replaceSelection(null);
                    document.insertString(this.caret.getDot(), this.composedTextContent, simpleAttributeSet);
                    this.composedTextStart = document.createPosition(this.caret.getDot() - this.composedTextContent.length());
                    this.composedTextEnd = document.createPosition(this.caret.getDot());
                }
                catch (BadLocationException badLocationException) {
                    this.composedTextEnd = null;
                    this.composedTextStart = null;
                    this.composedText = null;
                    this.composedTextContent = null;
                }
            }
            if (n2 != n5) {
                try {
                    this.latestCommittedTextStart = document.createPosition(n2);
                    this.latestCommittedTextEnd = document.createPosition(n5);
                }
                catch (BadLocationException badLocationException) {
                    this.latestCommittedTextStart = null;
                    this.latestCommittedTextEnd = null;
                }
            } else {
                this.latestCommittedTextStart = null;
                this.latestCommittedTextEnd = null;
            }
        }
    }

    private void createComposedString(int n2, AttributedCharacterIterator attributedCharacterIterator) {
        Document document = this.getDocument();
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = attributedCharacterIterator.setIndex(n2);
        while (c2 != '\uffff') {
            stringBuffer.append(c2);
            c2 = attributedCharacterIterator.next();
        }
        this.composedTextContent = new String(stringBuffer);
        this.composedText = new AttributedString(attributedCharacterIterator, n2, attributedCharacterIterator.getEndIndex());
    }

    private void mapCommittedTextToAction(String string) {
        Keymap keymap = this.getKeymap();
        if (keymap != null) {
            Serializable serializable;
            Action action = null;
            if (string.length() == 1) {
                serializable = KeyStroke.getKeyStroke(string.charAt(0));
                action = keymap.getAction((KeyStroke)serializable);
            }
            if (action == null) {
                action = keymap.getDefaultAction();
            }
            if (action != null) {
                serializable = new ActionEvent(this, 1001, string, EventQueue.getMostRecentEventTime(), this.getCurrentEventModifiers());
                action.actionPerformed((ActionEvent)serializable);
            }
        }
    }

    private void setInputMethodCaretPosition(InputMethodEvent inputMethodEvent) {
        if (this.composedTextStart != null) {
            TextHitInfo textHitInfo;
            int n2 = this.composedTextStart.getOffset();
            if (!(this.caret instanceof ComposedTextCaret)) {
                if (this.composedTextCaret == null) {
                    this.composedTextCaret = new ComposedTextCaret();
                }
                this.originalCaret = this.caret;
                this.exchangeCaret(this.originalCaret, this.composedTextCaret);
            }
            if ((textHitInfo = inputMethodEvent.getCaret()) != null) {
                int n3 = textHitInfo.getInsertionIndex();
                n2 += n3;
                if (n3 == 0) {
                    try {
                        Rectangle rectangle = this.modelToView(n2);
                        Rectangle rectangle2 = this.modelToView(this.composedTextEnd.getOffset());
                        Rectangle rectangle3 = this.getBounds();
                        rectangle.x += Math.min(rectangle2.x - rectangle.x, rectangle3.width);
                        this.scrollRectToVisible(rectangle);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            this.caret.setDot(n2);
        } else if (this.caret instanceof ComposedTextCaret) {
            int n4 = this.caret.getDot();
            this.exchangeCaret(this.caret, this.originalCaret);
            this.caret.setDot(n4);
        }
    }

    private void exchangeCaret(Caret caret, Caret caret2) {
        int n2 = caret.getBlinkRate();
        this.setCaret(caret2);
        this.caret.setBlinkRate(n2);
        this.caret.setVisible(this.hasFocus());
    }

    private boolean shouldSynthensizeKeyEvents() {
        if (!this.checkedInputOverride) {
            this.checkedInputOverride = true;
            this.needToSendKeyTypedEvent = !this.isProcessInputMethodEventOverridden();
        }
        return this.needToSendKeyTypedEvent;
    }

    private boolean isProcessInputMethodEventOverridden() {
        Boolean bl2;
        if (overrideMap == null) {
            overrideMap = Collections.synchronizedMap(new HashMap());
        }
        if ((bl2 = (Boolean)overrideMap.get(this.getClass().getName())) != null) {
            return bl2;
        }
        Boolean bl3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return JTextComponent.isProcessInputMethodEventOverridden(JTextComponent.this.getClass());
            }
        });
        return bl3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        keymapTable = null;
        try {
            keymapTable = new Hashtable(17);
            Keymap keymap = JTextComponent.addKeymap(DEFAULT_KEYMAP, null);
            keymap.setDefaultAction(new DefaultEditorKit.DefaultKeyTypedAction());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class DoSetCaretPosition
    implements Runnable {
        JTextComponent host;
        Position newPos;

        DoSetCaretPosition(JTextComponent jTextComponent2, Position position) {
            this.host = jTextComponent2;
            this.newPos = position;
        }

        public void run() {
            this.host.setCaretPosition(this.newPos.getOffset());
        }
    }

    class ComposedTextCaret
    extends DefaultCaret
    implements Serializable {
        Color bg;

        ComposedTextCaret() {
        }

        public void install(JTextComponent jTextComponent) {
            super.install(jTextComponent);
            Document document = jTextComponent.getDocument();
            if (document instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                Element element = styledDocument.getCharacterElement(jTextComponent.composedTextStart.getOffset());
                AttributeSet attributeSet = element.getAttributes();
                this.bg = styledDocument.getBackground(attributeSet);
            }
            if (this.bg == null) {
                this.bg = jTextComponent.getBackground();
            }
        }

        public void paint(Graphics graphics) {
            if (this.isVisible()) {
                try {
                    Rectangle rectangle = this.component.modelToView(this.getDot());
                    graphics.setXORMode(this.bg);
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                    graphics.setPaintMode();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        protected void positionCaret(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = this.component;
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n2 = jTextComponent.viewToModel(point);
            if (n2 < jTextComponent.composedTextStart.getOffset() || n2 > jTextComponent.composedTextEnd.getOffset()) {
                try {
                    Position position = jTextComponent.getDocument().createPosition(n2);
                    jTextComponent.getInputContext().endComposition();
                    EventQueue.invokeLater(new DoSetCaretPosition(jTextComponent, position));
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(badLocationException);
                }
            } else {
                super.positionCaret(mouseEvent);
            }
        }
    }

    class InputMethodRequestsHandler
    implements InputMethodRequests,
    DocumentListener {
        InputMethodRequestsHandler() {
        }

        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            Document document = JTextComponent.this.getDocument();
            if (document != null && JTextComponent.this.latestCommittedTextStart != null && JTextComponent.this.latestCommittedTextEnd != null) {
                try {
                    int n2 = JTextComponent.this.latestCommittedTextStart.getOffset();
                    int n3 = JTextComponent.this.latestCommittedTextEnd.getOffset();
                    String string = document.getText(n2, n3 - n2);
                    document.remove(n2, n3 - n2);
                    return new AttributedString(string).getIterator();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return null;
        }

        public AttributedCharacterIterator getCommittedText(int n2, int n3, AttributedCharacterIterator.Attribute[] attributeArray) {
            String string;
            int n4 = 0;
            int n5 = 0;
            if (JTextComponent.this.composedTextStart != null) {
                n4 = JTextComponent.this.composedTextStart.getOffset();
                n5 = JTextComponent.this.composedTextEnd.getOffset();
            }
            try {
                if (n2 < n4) {
                    if (n3 <= n4) {
                        string = JTextComponent.this.getText(n2, n3 - n2);
                    } else {
                        int n6 = n4 - n2;
                        string = JTextComponent.this.getText(n2, n6) + JTextComponent.this.getText(n5, n3 - n2 - n6);
                    }
                } else {
                    string = JTextComponent.this.getText(n2 + (n5 - n4), n3 - n2);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException("Invalid range");
            }
            return new AttributedString(string).getIterator();
        }

        public int getCommittedTextLength() {
            Document document = JTextComponent.this.getDocument();
            int n2 = 0;
            if (document != null) {
                n2 = document.getLength();
                if (JTextComponent.this.composedTextContent != null) {
                    n2 -= JTextComponent.this.composedTextContent.length();
                }
            }
            return n2;
        }

        public int getInsertPositionOffset() {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (JTextComponent.this.composedTextStart != null) {
                n3 = JTextComponent.this.composedTextStart.getOffset();
                n4 = JTextComponent.this.composedTextEnd.getOffset();
            }
            if ((n2 = JTextComponent.this.getCaretPosition()) < n3) {
                return n2;
            }
            if (n2 < n4) {
                return n3;
            }
            return n2 - (n4 - n3);
        }

        public TextHitInfo getLocationOffset(int n2, int n3) {
            if (JTextComponent.this.composedText == null) {
                return null;
            }
            Point point = JTextComponent.this.getLocationOnScreen();
            point.x = n2 - point.x;
            point.y = n3 - point.y;
            int n4 = JTextComponent.this.viewToModel(point);
            if (n4 >= JTextComponent.this.composedTextStart.getOffset() && n4 <= JTextComponent.this.composedTextEnd.getOffset()) {
                return TextHitInfo.leading(n4 - JTextComponent.this.composedTextStart.getOffset());
            }
            return null;
        }

        public Rectangle getTextLocation(TextHitInfo textHitInfo) {
            Rectangle rectangle;
            try {
                rectangle = JTextComponent.this.modelToView(JTextComponent.this.getCaretPosition());
                if (rectangle != null) {
                    Point point = JTextComponent.this.getLocationOnScreen();
                    rectangle.translate(point.x, point.y);
                }
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
            }
            if (rectangle == null) {
                rectangle = new Rectangle();
            }
            return rectangle;
        }

        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            String string = JTextComponent.this.getSelectedText();
            if (string != null) {
                return new AttributedString(string).getIterator();
            }
            return null;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            JTextComponent.this.latestCommittedTextStart = null;
            JTextComponent.this.latestCommittedTextEnd = null;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            JTextComponent.this.latestCommittedTextStart = null;
            JTextComponent.this.latestCommittedTextEnd = null;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JTextComponent.this.latestCommittedTextStart = null;
            JTextComponent.this.latestCommittedTextEnd = null;
        }
    }

    static class MutableCaretEvent
    extends CaretEvent
    implements ChangeListener,
    FocusListener,
    MouseListener {
        private boolean dragActive;
        private int dot;
        private int mark;

        MutableCaretEvent(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        final void fire() {
            JTextComponent jTextComponent = (JTextComponent)this.getSource();
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                jTextComponent.fireCaretUpdate(this);
            }
        }

        public final String toString() {
            return "dot=" + this.dot + "," + "mark=" + this.mark;
        }

        public final int getDot() {
            return this.dot;
        }

        public final int getMark() {
            return this.mark;
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            if (!this.dragActive) {
                this.fire();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            focusedComponent = (JTextComponent)focusEvent.getSource();
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.dragActive = true;
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.dragActive = false;
            this.fire();
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
        }

        public final void mouseExited(MouseEvent mouseEvent) {
        }
    }

    static class KeymapActionMap
    extends ActionMap {
        private Keymap keymap;

        KeymapActionMap(Keymap keymap) {
            this.keymap = keymap;
        }

        public Object[] keys() {
            boolean bl2;
            Object[] objectArray = super.keys();
            Object[] objectArray2 = this.keymap.getBoundActions();
            int n2 = objectArray == null ? 0 : objectArray.length;
            int n3 = objectArray2 == null ? 0 : objectArray2.length;
            boolean bl3 = bl2 = this.keymap.getDefaultAction() != null;
            if (bl2) {
                ++n3;
            }
            if (n2 == 0) {
                if (bl2) {
                    Object[] objectArray3 = new Object[n3];
                    if (n3 > 1) {
                        System.arraycopy(objectArray2, 0, objectArray3, 0, n3 - 1);
                    }
                    objectArray3[n3 - 1] = KeymapWrapper.DefaultActionKey;
                    return objectArray3;
                }
                return objectArray2;
            }
            if (n3 == 0) {
                return objectArray;
            }
            Object[] objectArray4 = new Object[n2 + n3];
            System.arraycopy(objectArray, 0, objectArray4, 0, n2);
            if (bl2) {
                if (n3 > 1) {
                    System.arraycopy(objectArray2, 0, objectArray4, n2, n3 - 1);
                }
                objectArray4[n2 + n3 - 1] = KeymapWrapper.DefaultActionKey;
            } else {
                System.arraycopy(objectArray2, 0, objectArray4, n2, n3);
            }
            return objectArray4;
        }

        public int size() {
            int n2;
            Action[] actionArray = this.keymap.getBoundActions();
            int n3 = n2 = actionArray == null ? 0 : actionArray.length;
            if (this.keymap.getDefaultAction() != null) {
                ++n2;
            }
            return super.size() + n2;
        }

        public Action get(Object object) {
            Action action = super.get(object);
            if (action == null) {
                if (object == KeymapWrapper.DefaultActionKey) {
                    action = this.keymap.getDefaultAction();
                } else if (object instanceof Action) {
                    action = (Action)object;
                }
            }
            return action;
        }
    }

    static class KeymapWrapper
    extends InputMap {
        static final Object DefaultActionKey = new Object();
        private Keymap keymap;

        KeymapWrapper(Keymap keymap) {
            this.keymap = keymap;
        }

        public KeyStroke[] keys() {
            int n2;
            KeyStroke[] keyStrokeArray = super.keys();
            KeyStroke[] keyStrokeArray2 = this.keymap.getBoundKeyStrokes();
            int n3 = keyStrokeArray == null ? 0 : keyStrokeArray.length;
            int n4 = n2 = keyStrokeArray2 == null ? 0 : keyStrokeArray2.length;
            if (n3 == 0) {
                return keyStrokeArray2;
            }
            if (n2 == 0) {
                return keyStrokeArray;
            }
            KeyStroke[] keyStrokeArray3 = new KeyStroke[n3 + n2];
            System.arraycopy(keyStrokeArray, 0, keyStrokeArray3, 0, n3);
            System.arraycopy(keyStrokeArray2, 0, keyStrokeArray3, n3, n2);
            return keyStrokeArray3;
        }

        public int size() {
            KeyStroke[] keyStrokeArray = this.keymap.getBoundKeyStrokes();
            int n2 = keyStrokeArray == null ? 0 : keyStrokeArray.length;
            return super.size() + n2;
        }

        public Object get(KeyStroke keyStroke) {
            Object object = this.keymap.getAction(keyStroke);
            if (object == null && (object = super.get(keyStroke)) == null && keyStroke.getKeyChar() != '\uffff' && this.keymap.getDefaultAction() != null) {
                object = DefaultActionKey;
            }
            return object;
        }
    }

    static class DefaultKeymap
    implements Keymap {
        String nm;
        Keymap parent;
        Hashtable bindings;
        Action defaultAction;

        DefaultKeymap(String string, Keymap keymap) {
            this.nm = string;
            this.parent = keymap;
            this.bindings = new Hashtable();
        }

        public Action getDefaultAction() {
            if (this.defaultAction != null) {
                return this.defaultAction;
            }
            return this.parent != null ? this.parent.getDefaultAction() : null;
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public String getName() {
            return this.nm;
        }

        public Action getAction(KeyStroke keyStroke) {
            Action action = (Action)this.bindings.get(keyStroke);
            if (action == null && this.parent != null) {
                action = this.parent.getAction(keyStroke);
            }
            return action;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            KeyStroke[] keyStrokeArray = new KeyStroke[this.bindings.size()];
            int n2 = 0;
            Enumeration enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray[n2++] = (KeyStroke)enumeration.nextElement();
            }
            return keyStrokeArray;
        }

        public Action[] getBoundActions() {
            Action[] actionArray = new Action[this.bindings.size()];
            int n2 = 0;
            Enumeration enumeration = this.bindings.elements();
            while (enumeration.hasMoreElements()) {
                actionArray[n2++] = (Action)enumeration.nextElement();
            }
            return actionArray;
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            KeyStroke[] keyStrokeArray;
            if (action == null) {
                return null;
            }
            Object[] objectArray = null;
            Vector vector = null;
            Enumeration enumeration = this.bindings.keys();
            while (enumeration.hasMoreElements()) {
                keyStrokeArray = enumeration.nextElement();
                if (this.bindings.get(keyStrokeArray) != action) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(keyStrokeArray);
            }
            if (this.parent != null && (keyStrokeArray = this.parent.getKeyStrokesForAction(action)) != null) {
                int n2 = 0;
                int n3 = keyStrokeArray.length - 1;
                while (n3 >= 0) {
                    if (this.isLocallyDefined(keyStrokeArray[n3])) {
                        keyStrokeArray[n3] = null;
                        ++n2;
                    }
                    --n3;
                }
                if (n2 > 0 && n2 < keyStrokeArray.length) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    int n4 = keyStrokeArray.length - 1;
                    while (n4 >= 0) {
                        if (keyStrokeArray[n4] != null) {
                            vector.addElement(keyStrokeArray[n4]);
                        }
                        --n4;
                    }
                } else if (n2 == 0) {
                    if (vector == null) {
                        objectArray = keyStrokeArray;
                    } else {
                        objectArray = new KeyStroke[vector.size() + keyStrokeArray.length];
                        vector.copyInto(objectArray);
                        System.arraycopy(keyStrokeArray, 0, objectArray, vector.size(), keyStrokeArray.length);
                        vector = null;
                    }
                }
            }
            if (vector != null) {
                objectArray = new KeyStroke[vector.size()];
                vector.copyInto(objectArray);
            }
            return objectArray;
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.bindings.containsKey(keyStroke);
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.bindings.put(keyStroke, action);
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.bindings.remove(keyStroke);
        }

        public void removeBindings() {
            this.bindings.clear();
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }

        public String toString() {
            return "Keymap[" + this.nm + "]" + this.bindings;
        }
    }

    static class DefaultTransferHandler
    extends TransferHandler
    implements UIResource {
        DefaultTransferHandler() {
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n2) {
            int n3;
            JTextComponent jTextComponent;
            int n4;
            if (jComponent instanceof JTextComponent && (n4 = (jTextComponent = (JTextComponent)jComponent).getSelectionStart()) != (n3 = jTextComponent.getSelectionEnd())) {
                try {
                    Document document = jTextComponent.getDocument();
                    String string = document.getText(n4, n3 - n4);
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, null);
                    if (n2 == 2) {
                        document.remove(n4, n3 - n4);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor dataFlavor;
            if (jComponent instanceof JTextComponent && (dataFlavor = this.getFlavor(transferable.getTransferDataFlavors())) != null) {
                try {
                    String string = (String)transferable.getTransferData(dataFlavor);
                    ((JTextComponent)jComponent).replaceSelection(string);
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getFlavor(dataFlavorArray) != null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 0;
        }

        private DataFlavor getFlavor(DataFlavor[] dataFlavorArray) {
            if (dataFlavorArray != null) {
                int n2 = 0;
                while (n2 < dataFlavorArray.length) {
                    if (dataFlavorArray[n2].equals(DataFlavor.stringFlavor)) {
                        return dataFlavorArray[n2];
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener,
    AccessibleAction,
    AccessibleEditableText {
        int caretPos;

        public AccessibleJTextComponent() {
            Document document = JTextComponent.this.getDocument();
            if (document != null) {
                document.addDocumentListener(this);
            }
            JTextComponent.this.addCaretListener(this);
            this.caretPos = this.getCaretPosition();
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n2 = caretEvent.getDot();
            int n3 = caretEvent.getMark();
            if (this.caretPos != n2) {
                this.firePropertyChange("AccessibleCaret", new Integer(this.caretPos), new Integer(n2));
                this.caretPos = n2;
            }
            if (n3 != n2) {
                this.firePropertyChange("AccessibleSelection", null, this.getSelectedText());
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Integer n2 = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n2);
            } else {
                Runnable runnable = new Runnable(this, n2){
                    private final /* synthetic */ Integer val$pos;
                    private final /* synthetic */ AccessibleJTextComponent this$1;
                    {
                        this.this$1 = accessibleJTextComponent;
                        this.val$pos = n2;
                    }

                    public void run() {
                        this.this$1.firePropertyChange("AccessibleText", null, this.val$pos);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Integer n2 = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n2);
            } else {
                Runnable runnable = new Runnable(this, n2){
                    private final /* synthetic */ Integer val$pos;
                    private final /* synthetic */ AccessibleJTextComponent this$1;
                    {
                        this.this$1 = accessibleJTextComponent;
                        this.val$pos = n2;
                    }

                    public void run() {
                        this.this$1.firePropertyChange("AccessibleText", null, this.val$pos);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Integer n2 = new Integer(documentEvent.getOffset());
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, n2);
            } else {
                Runnable runnable = new Runnable(this, n2){
                    private final /* synthetic */ Integer val$pos;
                    private final /* synthetic */ AccessibleJTextComponent this$1;
                    {
                        this.this$1 = accessibleJTextComponent;
                        this.val$pos = n2;
                    }

                    public void run() {
                        this.this$1.firePropertyChange("AccessibleText", null, this.val$pos);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JTextComponent.this.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public int getIndexAtPoint(Point point) {
            if (point == null) {
                return -1;
            }
            return JTextComponent.this.viewToModel(point);
        }

        Rectangle getRootEditorRect() {
            Rectangle rectangle = JTextComponent.this.getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                rectangle.y = 0;
                rectangle.x = 0;
                Insets insets = JTextComponent.this.getInsets();
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
                return rectangle;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Rectangle getCharacterBounds(int n2) {
            if (n2 < 0) return null;
            if (n2 > JTextComponent.this.model.getLength() - 1) {
                return null;
            }
            TextUI textUI = JTextComponent.this.getUI();
            if (textUI == null) {
                return null;
            }
            Rectangle rectangle = null;
            Rectangle rectangle2 = this.getRootEditorRect();
            if (rectangle2 == null) {
                return null;
            }
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readLock();
            }
            try {
                block8: {
                    try {
                        View view = textUI.getRootView(JTextComponent.this);
                        if (view == null) break block8;
                        view.setSize(rectangle2.width, rectangle2.height);
                        Shape shape = view.modelToView(n2, Position.Bias.Forward, n2 + 1, Position.Bias.Backward, rectangle2);
                        rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    }
                    catch (BadLocationException badLocationException) {
                        Object var8_9 = null;
                        if (!(JTextComponent.this.model instanceof AbstractDocument)) return rectangle;
                        ((AbstractDocument)JTextComponent.this.model).readUnlock();
                        return rectangle;
                    }
                }
                Object var8_8 = null;
                if (!(JTextComponent.this.model instanceof AbstractDocument)) return rectangle;
                ((AbstractDocument)JTextComponent.this.model).readUnlock();
                return rectangle;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (!(JTextComponent.this.model instanceof AbstractDocument)) throw throwable;
                ((AbstractDocument)JTextComponent.this.model).readUnlock();
                throw throwable;
            }
        }

        public int getCharCount() {
            return JTextComponent.this.model.getLength();
        }

        public int getCaretPosition() {
            return JTextComponent.this.getCaretPosition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getCharacterAttribute(int n2) {
            Element element = null;
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readLock();
            }
            try {
                element = JTextComponent.this.model.getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n3 = element.getElementIndex(n2);
                    element = element.getElement(n3);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (JTextComponent.this.model instanceof AbstractDocument) {
                    ((AbstractDocument)JTextComponent.this.model).readUnlock();
                }
                throw throwable;
            }
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readUnlock();
            }
            return element.getAttributes();
        }

        public int getSelectionStart() {
            return JTextComponent.this.getSelectionStart();
        }

        public int getSelectionEnd() {
            return JTextComponent.this.getSelectionEnd();
        }

        public String getSelectedText() {
            return JTextComponent.this.getSelectedText();
        }

        public String getAtIndex(int n2, int n3) {
            return this.getAtIndex(n2, n3, 0);
        }

        public String getAfterIndex(int n2, int n3) {
            return this.getAtIndex(n2, n3, 1);
        }

        public String getBeforeIndex(int n2, int n3) {
            return this.getAtIndex(n2, n3, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getAtIndex(int n2, int n3, int n4) {
            if (JTextComponent.this.model instanceof AbstractDocument) {
                ((AbstractDocument)JTextComponent.this.model).readLock();
            }
            try {
                try {
                    if (n3 < 0 || n3 >= JTextComponent.this.model.getLength()) {
                        String string = null;
                        Object var7_8 = null;
                        if (!(JTextComponent.this.model instanceof AbstractDocument)) return string;
                        ((AbstractDocument)JTextComponent.this.model).readUnlock();
                        return string;
                    }
                    switch (n2) {
                        case 1: {
                            if (n3 + n4 < JTextComponent.this.model.getLength() && n3 + n4 >= 0) {
                                String string = JTextComponent.this.model.getText(n3 + n4, 1);
                                Object var7_9 = null;
                                if (!(JTextComponent.this.model instanceof AbstractDocument)) return string;
                                ((AbstractDocument)JTextComponent.this.model).readUnlock();
                                return string;
                            }
                            break;
                        }
                        case 2: 
                        case 3: {
                            IndexedSegment indexedSegment = this.getSegmentAt(n2, n3);
                            if (indexedSegment != null) {
                                if (n4 != 0) {
                                    int n5 = n4 < 0 ? indexedSegment.modelOffset - 1 : indexedSegment.modelOffset + n4 * indexedSegment.count;
                                    indexedSegment = n5 >= 0 && n5 <= JTextComponent.this.model.getLength() ? this.getSegmentAt(n2, n5) : null;
                                }
                                if (indexedSegment != null) {
                                    String string = new String(indexedSegment.array, indexedSegment.offset, indexedSegment.count);
                                    Object var7_10 = null;
                                    if (!(JTextComponent.this.model instanceof AbstractDocument)) return string;
                                    ((AbstractDocument)JTextComponent.this.model).readUnlock();
                                    return string;
                                }
                            }
                            break;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    Object var7_12 = null;
                    if (!(JTextComponent.this.model instanceof AbstractDocument)) return null;
                    ((AbstractDocument)JTextComponent.this.model).readUnlock();
                    return null;
                }
                {
                }
                Object var7_11 = null;
                if (!(JTextComponent.this.model instanceof AbstractDocument)) return null;
                ((AbstractDocument)JTextComponent.this.model).readUnlock();
                return null;
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                if (!(JTextComponent.this.model instanceof AbstractDocument)) throw throwable;
                ((AbstractDocument)JTextComponent.this.model).readUnlock();
                throw throwable;
            }
        }

        private Element getParagraphElement(int n2) {
            if (JTextComponent.this.model instanceof PlainDocument) {
                PlainDocument plainDocument = (PlainDocument)JTextComponent.this.model;
                return plainDocument.getParagraphElement(n2);
            }
            if (JTextComponent.this.model instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)JTextComponent.this.model;
                return styledDocument.getParagraphElement(n2);
            }
            Element element = null;
            element = JTextComponent.this.model.getDefaultRootElement();
            while (!element.isLeaf()) {
                int n3 = element.getElementIndex(n2);
                element = element.getElement(n3);
            }
            if (element == null) {
                return null;
            }
            return element.getParentElement();
        }

        private IndexedSegment getParagraphElementText(int n2) throws BadLocationException {
            Element element = this.getParagraphElement(n2);
            if (element != null) {
                IndexedSegment indexedSegment = new IndexedSegment();
                try {
                    int n3 = element.getEndOffset() - element.getStartOffset();
                    JTextComponent.this.model.getText(element.getStartOffset(), n3, indexedSegment);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                indexedSegment.modelOffset = element.getStartOffset();
                return indexedSegment;
            }
            return null;
        }

        private IndexedSegment getSegmentAt(int n2, int n3) throws BadLocationException {
            BreakIterator breakIterator;
            IndexedSegment indexedSegment = this.getParagraphElementText(n3);
            if (indexedSegment == null) {
                return null;
            }
            switch (n2) {
                case 2: {
                    breakIterator = BreakIterator.getWordInstance(this.getLocale());
                    break;
                }
                case 3: {
                    breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                    break;
                }
                default: {
                    return null;
                }
            }
            indexedSegment.first();
            breakIterator.setText(indexedSegment);
            int n4 = breakIterator.following(n3 - indexedSegment.modelOffset + indexedSegment.offset);
            if (n4 == -1) {
                return null;
            }
            if (n4 > indexedSegment.offset + indexedSegment.count) {
                return null;
            }
            int n5 = breakIterator.previous();
            if (n5 == -1 || n5 >= indexedSegment.offset + indexedSegment.count) {
                return null;
            }
            indexedSegment.modelOffset = indexedSegment.modelOffset + n5 - indexedSegment.offset;
            indexedSegment.offset = n5;
            indexedSegment.count = n4 - n5;
            return indexedSegment;
        }

        public AccessibleEditableText getAccessibleEditableText() {
            return this;
        }

        public void setTextContents(String string) {
            JTextComponent.this.setText(string);
        }

        public void insertTextAtIndex(int n2, String string) {
            Document document = JTextComponent.this.getDocument();
            if (document != null) {
                try {
                    if (string != null && string.length() > 0) {
                        document.insertString(n2, string, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(JTextComponent.this);
                }
            }
        }

        public String getTextRange(int n2, int n3) {
            int n4;
            String string = null;
            int n5 = Math.min(n2, n3);
            if (n5 != (n4 = Math.max(n2, n3))) {
                try {
                    Document document = JTextComponent.this.getDocument();
                    string = document.getText(n5, n4 - n5);
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalArgumentException(badLocationException.getMessage());
                }
            }
            return string;
        }

        public void delete(int n2, int n3) {
            if (JTextComponent.this.isEditable() && this.isEnabled()) {
                try {
                    int n4 = Math.min(n2, n3);
                    int n5 = Math.max(n2, n3);
                    if (n4 != n5) {
                        Document document = JTextComponent.this.getDocument();
                        document.remove(n4, n5 - n4);
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(JTextComponent.this);
            }
        }

        public void cut(int n2, int n3) {
            this.selectText(n2, n3);
            JTextComponent.this.cut();
        }

        public void paste(int n2) {
            JTextComponent.this.setCaretPosition(n2);
            JTextComponent.this.paste();
        }

        public void replaceText(int n2, int n3, String string) {
            this.selectText(n2, n3);
            JTextComponent.this.replaceSelection(string);
        }

        public void selectText(int n2, int n3) {
            JTextComponent.this.select(n2, n3);
        }

        public void setAttributes(int n2, int n3, AttributeSet attributeSet) {
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            Action[] actionArray = JTextComponent.this.getActions();
            return actionArray.length;
        }

        public String getAccessibleActionDescription(int n2) {
            Action[] actionArray = JTextComponent.this.getActions();
            if (n2 < 0 || n2 >= actionArray.length) {
                return null;
            }
            return (String)actionArray[n2].getValue("Name");
        }

        public boolean doAccessibleAction(int n2) {
            Action[] actionArray = JTextComponent.this.getActions();
            if (n2 < 0 || n2 >= actionArray.length) {
                return false;
            }
            ActionEvent actionEvent = new ActionEvent(JTextComponent.this, 1001, null, EventQueue.getMostRecentEventTime(), JTextComponent.this.getCurrentEventModifiers());
            actionArray[n2].actionPerformed(actionEvent);
            return true;
        }

        private class IndexedSegment
        extends Segment {
            public int modelOffset;

            private IndexedSegment() {
            }
        }
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke keyStroke, String string) {
            this.key = keyStroke;
            this.actionName = string;
        }
    }
}

