/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.OptionPaneUI;

public class JOptionPane
extends JComponent
implements Accessible {
    private static final String uiClassID = "OptionPaneUI";
    public static final Object UNINITIALIZED_VALUE = "uninitializedValue";
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    public static final String ICON_PROPERTY = "icon";
    public static final String MESSAGE_PROPERTY = "message";
    public static final String VALUE_PROPERTY = "value";
    public static final String OPTIONS_PROPERTY = "options";
    public static final String INITIAL_VALUE_PROPERTY = "initialValue";
    public static final String MESSAGE_TYPE_PROPERTY = "messageType";
    public static final String OPTION_TYPE_PROPERTY = "optionType";
    public static final String SELECTION_VALUES_PROPERTY = "selectionValues";
    public static final String INITIAL_SELECTION_VALUE_PROPERTY = "initialSelectionValue";
    public static final String INPUT_VALUE_PROPERTY = "inputValue";
    public static final String WANTS_INPUT_PROPERTY = "wantsInput";
    protected transient Icon icon;
    protected transient Object message;
    protected transient Object[] options;
    protected transient Object initialValue;
    protected int messageType;
    protected int optionType;
    protected transient Object value;
    protected transient Object[] selectionValues;
    protected transient Object inputValue;
    protected transient Object initialSelectionValue;
    protected boolean wantsInput;
    private static final Object sharedFrameKey = class$javax$swing$JOptionPane == null ? (class$javax$swing$JOptionPane = JOptionPane.class$("javax.swing.JOptionPane")) : class$javax$swing$JOptionPane;
    static /* synthetic */ Class class$javax$swing$JOptionPane;

    public static String showInputDialog(Object object) throws HeadlessException {
        return JOptionPane.showInputDialog(null, object);
    }

    public static String showInputDialog(Object object, Object object2) {
        return JOptionPane.showInputDialog(null, object, object2);
    }

    public static String showInputDialog(Component component, Object object) throws HeadlessException {
        return JOptionPane.showInputDialog(component, object, UIManager.getString((Object)"OptionPane.inputDialogTitle", component), 3);
    }

    public static String showInputDialog(Component component, Object object, Object object2) {
        return (String)JOptionPane.showInputDialog(component, object, UIManager.getString((Object)"OptionPane.inputDialogTitle", component), 3, null, null, object2);
    }

    public static String showInputDialog(Component component, Object object, String string, int n2) throws HeadlessException {
        return (String)JOptionPane.showInputDialog(component, object, string, n2, null, null, null);
    }

    public static Object showInputDialog(Component component, Object object, String string, int n2, Icon icon, Object[] objectArray, Object object2) throws HeadlessException {
        JOptionPane jOptionPane = new JOptionPane(object, n2, 2, icon, null, null);
        jOptionPane.setWantsInput(true);
        jOptionPane.setSelectionValues(objectArray);
        jOptionPane.setInitialSelectionValue(object2);
        jOptionPane.setComponentOrientation((component == null ? JOptionPane.getRootFrame() : component).getComponentOrientation());
        int n3 = JOptionPane.styleFromMessageType(n2);
        JDialog jDialog = jOptionPane.createDialog(component, string, n3);
        jOptionPane.selectInitialValue();
        jDialog.show();
        jDialog.dispose();
        Object object3 = jOptionPane.getInputValue();
        if (object3 == UNINITIALIZED_VALUE) {
            return null;
        }
        return object3;
    }

    public static void showMessageDialog(Component component, Object object) throws HeadlessException {
        JOptionPane.showMessageDialog(component, object, UIManager.getString((Object)"OptionPane.messageDialogTitle", component), 1);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n2) throws HeadlessException {
        JOptionPane.showMessageDialog(component, object, string, n2, null);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n2, Icon icon) throws HeadlessException {
        JOptionPane.showOptionDialog(component, object, string, -1, n2, icon, null, null);
    }

    public static int showConfirmDialog(Component component, Object object) throws HeadlessException {
        return JOptionPane.showConfirmDialog(component, object, UIManager.getString("OptionPane.titleText"), 1);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n2) throws HeadlessException {
        return JOptionPane.showConfirmDialog(component, object, string, n2, 3);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n2, int n3) throws HeadlessException {
        return JOptionPane.showConfirmDialog(component, object, string, n2, n3, null);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n2, int n3, Icon icon) throws HeadlessException {
        return JOptionPane.showOptionDialog(component, object, string, n2, n3, icon, null, null);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n2, int n3, Icon icon, Object[] objectArray, Object object2) throws HeadlessException {
        JOptionPane jOptionPane = new JOptionPane(object, n3, n2, icon, objectArray, object2);
        jOptionPane.setInitialValue(object2);
        jOptionPane.setComponentOrientation((component == null ? JOptionPane.getRootFrame() : component).getComponentOrientation());
        int n4 = JOptionPane.styleFromMessageType(n3);
        JDialog jDialog = jOptionPane.createDialog(component, string, n4);
        jOptionPane.selectInitialValue();
        jDialog.show();
        jDialog.dispose();
        Object object3 = jOptionPane.getValue();
        if (object3 == null) {
            return -1;
        }
        if (objectArray == null) {
            if (object3 instanceof Integer) {
                return (Integer)object3;
            }
            return -1;
        }
        int n5 = 0;
        int n6 = objectArray.length;
        while (n5 < n6) {
            if (objectArray[n5].equals(object3)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    public JDialog createDialog(Component component, String string) throws HeadlessException {
        int n2 = JOptionPane.styleFromMessageType(this.getMessageType());
        return this.createDialog(component, string, n2);
    }

    private JDialog createDialog(Component component, String string, int n2) throws HeadlessException {
        boolean bl2;
        Window window = JOptionPane.getWindowForComponent(component);
        final JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, string, true) : new JDialog((Dialog)window, string, true);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        jDialog.setResizable(false);
        if (JDialog.isDefaultLookAndFeelDecorated() && (bl2 = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            jDialog.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(n2);
        }
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        jDialog.addWindowListener(new WindowAdapter(){
            private boolean gotFocus = false;

            public void windowClosing(WindowEvent windowEvent) {
                JOptionPane.this.setValue(null);
            }

            public void windowGainedFocus(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    JOptionPane.this.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        });
        jDialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                JOptionPane.this.setValue(UNINITIALIZED_VALUE);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jDialog.isVisible() && propertyChangeEvent.getSource() == JOptionPane.this && propertyChangeEvent.getPropertyName().equals(JOptionPane.VALUE_PROPERTY) && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() != UNINITIALIZED_VALUE) {
                    jDialog.setVisible(false);
                }
            }
        });
        return jDialog;
    }

    public static void showInternalMessageDialog(Component component, Object object) {
        JOptionPane.showInternalMessageDialog(component, object, UIManager.getString((Object)"OptionPane.messageDialogTitle", component), 1);
    }

    public static void showInternalMessageDialog(Component component, Object object, String string, int n2) {
        JOptionPane.showInternalMessageDialog(component, object, string, n2, null);
    }

    public static void showInternalMessageDialog(Component component, Object object, String string, int n2, Icon icon) {
        JOptionPane.showInternalOptionDialog(component, object, string, -1, n2, icon, null, null);
    }

    public static int showInternalConfirmDialog(Component component, Object object) {
        return JOptionPane.showInternalConfirmDialog(component, object, UIManager.getString("OptionPane.titleText"), 1);
    }

    public static int showInternalConfirmDialog(Component component, Object object, String string, int n2) {
        return JOptionPane.showInternalConfirmDialog(component, object, string, n2, 3);
    }

    public static int showInternalConfirmDialog(Component component, Object object, String string, int n2, int n3) {
        return JOptionPane.showInternalConfirmDialog(component, object, string, n2, n3, null);
    }

    public static int showInternalConfirmDialog(Component component, Object object, String string, int n2, int n3, Icon icon) {
        return JOptionPane.showInternalOptionDialog(component, object, string, n2, n3, icon, null, null);
    }

    public static int showInternalOptionDialog(Component component, Object object, String string, int n2, int n3, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n3, n2, icon, objectArray, object2);
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        jOptionPane.setInitialValue(object2);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        jOptionPane.selectInitialValue();
        jInternalFrame.setVisible(true);
        jInternalFrame.startModal();
        if (component instanceof JInternalFrame) {
            try {
                ((JInternalFrame)component).setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        Object object3 = jOptionPane.getValue();
        if (component2 != null && component2.isShowing()) {
            component2.requestFocus();
        }
        if (object3 == null) {
            return -1;
        }
        if (objectArray == null) {
            if (object3 instanceof Integer) {
                return (Integer)object3;
            }
            return -1;
        }
        int n4 = 0;
        int n5 = objectArray.length;
        while (n4 < n5) {
            if (objectArray[n4].equals(object3)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public static String showInternalInputDialog(Component component, Object object) {
        return JOptionPane.showInternalInputDialog(component, object, UIManager.getString((Object)"OptionPane.inputDialogTitle", component), 3);
    }

    public static String showInternalInputDialog(Component component, Object object, String string, int n2) {
        return (String)JOptionPane.showInternalInputDialog(component, object, string, n2, null, null, null);
    }

    public static Object showInternalInputDialog(Component component, Object object, String string, int n2, Icon icon, Object[] objectArray, Object object2) {
        Object object3;
        JOptionPane jOptionPane = new JOptionPane(object, n2, 2, icon, null, null);
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        jOptionPane.setWantsInput(true);
        jOptionPane.setSelectionValues(objectArray);
        jOptionPane.setInitialSelectionValue(object2);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        jOptionPane.selectInitialValue();
        jInternalFrame.setVisible(true);
        jInternalFrame.startModal();
        if (component instanceof JInternalFrame) {
            try {
                ((JInternalFrame)component).setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (component2 != null && component2.isShowing()) {
            component2.requestFocus();
        }
        if ((object3 = jOptionPane.getInputValue()) == UNINITIALIZED_VALUE) {
            return null;
        }
        return object3;
    }

    public JInternalFrame createInternalFrame(Component component, String string) {
        Container container = JOptionPane.getDesktopPaneForComponent(component);
        if (container == null && (component == null || (container = component.getParent()) == null)) {
            throw new RuntimeException("JOptionPane: parentComponent does not have a valid parent");
        }
        final JInternalFrame jInternalFrame = new JInternalFrame(string, false, true, false, false);
        jInternalFrame.putClientProperty("JInternalFrame.frameType", "optionDialog");
        jInternalFrame.putClientProperty("JInternalFrame.messageType", new Integer(this.getMessageType()));
        jInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                if (JOptionPane.this.getValue() == UNINITIALIZED_VALUE) {
                    JOptionPane.this.setValue(null);
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jInternalFrame.isVisible() && propertyChangeEvent.getSource() == JOptionPane.this && propertyChangeEvent.getPropertyName().equals(JOptionPane.VALUE_PROPERTY)) {
                    try {
                        jInternalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    jInternalFrame.setVisible(false);
                    jInternalFrame.stopModal();
                }
            }
        });
        jInternalFrame.getContentPane().add((Component)this, "Center");
        if (container instanceof JDesktopPane) {
            container.add((Component)jInternalFrame, JLayeredPane.MODAL_LAYER);
        } else {
            container.add((Component)jInternalFrame, "Center");
        }
        Dimension dimension = jInternalFrame.getPreferredSize();
        Dimension dimension2 = container.getSize();
        Dimension dimension3 = component.getSize();
        jInternalFrame.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        Point point = SwingUtilities.convertPoint(component, 0, 0, container);
        int n2 = (dimension3.width - dimension.width) / 2 + point.x;
        int n3 = (dimension3.height - dimension.height) / 2 + point.y;
        int n4 = n2 + dimension.width - dimension2.width;
        int n5 = n3 + dimension.height - dimension2.height;
        n2 = Math.max(n4 > 0 ? n2 - n4 : n2, 0);
        n3 = Math.max(n5 > 0 ? n3 - n5 : n3, 0);
        jInternalFrame.setBounds(n2, n3, dimension.width, dimension.height);
        container.validate();
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return jInternalFrame;
    }

    public static Frame getFrameForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return JOptionPane.getFrameForComponent(component.getParent());
    }

    static Window getWindowForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return JOptionPane.getWindowForComponent(component.getParent());
    }

    public static JDesktopPane getDesktopPaneForComponent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JDesktopPane) {
            return (JDesktopPane)component;
        }
        return JOptionPane.getDesktopPaneForComponent(component.getParent());
    }

    public static void setRootFrame(Frame frame) {
        if (frame != null) {
            SwingUtilities.appContextPut(sharedFrameKey, frame);
        } else {
            SwingUtilities.appContextRemove(sharedFrameKey);
        }
    }

    public static Frame getRootFrame() throws HeadlessException {
        Frame frame = (Frame)SwingUtilities.appContextGet(sharedFrameKey);
        if (frame == null) {
            frame = SwingUtilities.getSharedOwnerFrame();
            SwingUtilities.appContextPut(sharedFrameKey, frame);
        }
        return frame;
    }

    public JOptionPane() {
        this("JOptionPane message");
    }

    public JOptionPane(Object object) {
        this(object, -1);
    }

    public JOptionPane(Object object, int n2) {
        this(object, n2, -1);
    }

    public JOptionPane(Object object, int n2, int n3) {
        this(object, n2, n3, null);
    }

    public JOptionPane(Object object, int n2, int n3, Icon icon) {
        this(object, n2, n3, icon, null);
    }

    public JOptionPane(Object object, int n2, int n3, Icon icon, Object[] objectArray) {
        this(object, n2, n3, icon, objectArray, null);
    }

    public JOptionPane(Object object, int n2, int n3, Icon icon, Object[] objectArray, Object object2) {
        this.message = object;
        this.options = objectArray;
        this.initialValue = object2;
        this.icon = icon;
        this.setMessageType(n2);
        this.setOptionType(n3);
        this.value = UNINITIALIZED_VALUE;
        this.inputValue = UNINITIALIZED_VALUE;
        this.updateUI();
    }

    public void setUI(OptionPaneUI optionPaneUI) {
        if ((OptionPaneUI)this.ui != optionPaneUI) {
            super.setUI(optionPaneUI);
            this.invalidate();
        }
    }

    public OptionPaneUI getUI() {
        return (OptionPaneUI)this.ui;
    }

    public void updateUI() {
        this.setUI((OptionPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setMessage(Object object) {
        Object object2 = this.message;
        this.message = object;
        this.firePropertyChange(MESSAGE_PROPERTY, object2, this.message);
    }

    public Object getMessage() {
        return this.message;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.icon;
        this.icon = icon;
        this.firePropertyChange(ICON_PROPERTY, icon2, this.icon);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setValue(Object object) {
        Object object2 = this.value;
        this.value = object;
        this.firePropertyChange(VALUE_PROPERTY, object2, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setOptions(Object[] objectArray) {
        Object[] objectArray2 = this.options;
        this.options = objectArray;
        this.firePropertyChange(OPTIONS_PROPERTY, objectArray2, this.options);
    }

    public Object[] getOptions() {
        if (this.options != null) {
            int n2 = this.options.length;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.options, 0, objectArray, 0, n2);
            return objectArray;
        }
        return this.options;
    }

    public void setInitialValue(Object object) {
        Object object2 = this.initialValue;
        this.initialValue = object;
        this.firePropertyChange(INITIAL_VALUE_PROPERTY, object2, this.initialValue);
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public void setMessageType(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3 && n2 != -1) {
            throw new RuntimeException("JOptionPane: type must be one of JOptionPane.ERROR_MESSAGE, JOptionPane.INFORMATION_MESSAGE, JOptionPane.WARNING_MESSAGE, JOptionPane.QUESTION_MESSAGE or JOptionPane.PLAIN_MESSAGE");
        }
        int n3 = this.messageType;
        this.messageType = n2;
        this.firePropertyChange(MESSAGE_TYPE_PROPERTY, n3, this.messageType);
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setOptionType(int n2) {
        if (n2 != -1 && n2 != 0 && n2 != 1 && n2 != 2) {
            throw new RuntimeException("JOptionPane: option type must be one of JOptionPane.DEFAULT_OPTION, JOptionPane.YES_NO_OPTION, JOptionPane.YES_NO_CANCEL_OPTION or JOptionPane.OK_CANCEL_OPTION");
        }
        int n3 = this.optionType;
        this.optionType = n2;
        this.firePropertyChange(OPTION_TYPE_PROPERTY, n3, this.optionType);
    }

    public int getOptionType() {
        return this.optionType;
    }

    public void setSelectionValues(Object[] objectArray) {
        Object[] objectArray2 = this.selectionValues;
        this.selectionValues = objectArray;
        this.firePropertyChange(SELECTION_VALUES_PROPERTY, objectArray2, objectArray);
        if (this.selectionValues != null) {
            this.setWantsInput(true);
        }
    }

    public Object[] getSelectionValues() {
        return this.selectionValues;
    }

    public void setInitialSelectionValue(Object object) {
        Object object2 = this.initialSelectionValue;
        this.initialSelectionValue = object;
        this.firePropertyChange(INITIAL_SELECTION_VALUE_PROPERTY, object2, object);
    }

    public Object getInitialSelectionValue() {
        return this.initialSelectionValue;
    }

    public void setInputValue(Object object) {
        Object object2 = this.inputValue;
        this.inputValue = object;
        this.firePropertyChange(INPUT_VALUE_PROPERTY, object2, object);
    }

    public Object getInputValue() {
        return this.inputValue;
    }

    public int getMaxCharactersPerLineCount() {
        return Integer.MAX_VALUE;
    }

    public void setWantsInput(boolean bl2) {
        boolean bl3 = this.wantsInput;
        this.wantsInput = bl2;
        this.firePropertyChange(WANTS_INPUT_PROPERTY, bl3, bl2);
    }

    public boolean getWantsInput() {
        return this.wantsInput;
    }

    public void selectInitialValue() {
        OptionPaneUI optionPaneUI = this.getUI();
        if (optionPaneUI != null) {
            optionPaneUI.selectInitialValue(this);
        }
    }

    private static int styleFromMessageType(int n2) {
        switch (n2) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n2;
        int n3;
        Vector vector = new Vector();
        objectOutputStream.defaultWriteObject();
        if (this.icon != null && this.icon instanceof Serializable) {
            vector.addElement(ICON_PROPERTY);
            vector.addElement(this.icon);
        }
        if (this.message != null && this.message instanceof Serializable) {
            vector.addElement(MESSAGE_PROPERTY);
            vector.addElement(this.message);
        }
        if (this.options != null) {
            Vector vector2 = new Vector();
            n3 = 0;
            n2 = this.options.length;
            while (n3 < n2) {
                if (this.options[n3] instanceof Serializable) {
                    vector2.addElement(this.options[n3]);
                }
                ++n3;
            }
            if (vector2.size() > 0) {
                int n4 = vector2.size();
                Object[] objectArray = new Object[n4];
                vector2.copyInto(objectArray);
                vector.addElement(OPTIONS_PROPERTY);
                vector.addElement(objectArray);
            }
        }
        if (this.initialValue != null && this.initialValue instanceof Serializable) {
            vector.addElement(INITIAL_VALUE_PROPERTY);
            vector.addElement(this.initialValue);
        }
        if (this.value != null && this.value instanceof Serializable) {
            vector.addElement(VALUE_PROPERTY);
            vector.addElement(this.value);
        }
        if (this.selectionValues != null) {
            boolean bl2 = true;
            n3 = 0;
            n2 = this.selectionValues.length;
            while (n3 < n2) {
                if (this.selectionValues[n3] != null && !(this.selectionValues[n3] instanceof Serializable)) {
                    bl2 = false;
                    break;
                }
                ++n3;
            }
            if (bl2) {
                vector.addElement(SELECTION_VALUES_PROPERTY);
                vector.addElement(this.selectionValues);
            }
        }
        if (this.inputValue != null && this.inputValue instanceof Serializable) {
            vector.addElement(INPUT_VALUE_PROPERTY);
            vector.addElement(this.inputValue);
        }
        if (this.initialSelectionValue != null && this.initialSelectionValue instanceof Serializable) {
            vector.addElement(INITIAL_SELECTION_VALUE_PROPERTY);
            vector.addElement(this.initialSelectionValue);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n2 = 0;
        int n3 = vector.size();
        if (n2 < n3 && vector.elementAt(n2).equals(ICON_PROPERTY)) {
            this.icon = (Icon)vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals(MESSAGE_PROPERTY)) {
            this.message = vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals(OPTIONS_PROPERTY)) {
            this.options = (Object[])vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals(INITIAL_VALUE_PROPERTY)) {
            this.initialValue = vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals(VALUE_PROPERTY)) {
            this.value = vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals(SELECTION_VALUES_PROPERTY)) {
            this.selectionValues = (Object[])vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals(INPUT_VALUE_PROPERTY)) {
            this.inputValue = vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals(INITIAL_SELECTION_VALUE_PROPERTY)) {
            this.initialSelectionValue = vector.elementAt(++n2);
            ++n2;
        }
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string;
        String string2 = this.icon != null ? this.icon.toString() : "";
        String string3 = this.initialValue != null ? this.initialValue.toString() : "";
        String string4 = string = this.message != null ? this.message.toString() : "";
        String string5 = this.messageType == 0 ? "ERROR_MESSAGE" : (this.messageType == 1 ? "INFORMATION_MESSAGE" : (this.messageType == 2 ? "WARNING_MESSAGE" : (this.messageType == 3 ? "QUESTION_MESSAGE" : (this.messageType == -1 ? "PLAIN_MESSAGE" : ""))));
        String string6 = this.optionType == -1 ? "DEFAULT_OPTION" : (this.optionType == 0 ? "YES_NO_OPTION" : (this.optionType == 1 ? "YES_NO_CANCEL_OPTION" : (this.optionType == 2 ? "OK_CANCEL_OPTION" : "")));
        String string7 = this.wantsInput ? "true" : "false";
        return super.paramString() + ",icon=" + string2 + ",initialValue=" + string3 + ",message=" + string + ",messageType=" + string5 + ",optionType=" + string6 + ",wantsInput=" + string7;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJOptionPane();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJOptionPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJOptionPane() {
            super(JOptionPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.OPTION_PANE;
        }
    }
}

