/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractAction
implements Action,
Cloneable,
Serializable {
    protected boolean enabled = true;
    private transient ArrayTable arrayTable;
    protected SwingPropertyChangeSupport changeSupport;

    public AbstractAction() {
    }

    public AbstractAction(String string) {
        this.putValue("Name", string);
    }

    public AbstractAction(String string, Icon icon) {
        this(string);
        this.putValue("SmallIcon", icon);
    }

    public Object getValue(String string) {
        if (this.arrayTable == null) {
            return null;
        }
        return this.arrayTable.get(string);
    }

    public void putValue(String string, Object object) {
        Object object2 = null;
        if (this.arrayTable == null) {
            this.arrayTable = new ArrayTable();
        }
        if (this.arrayTable.containsKey(string)) {
            object2 = this.arrayTable.get(string);
        }
        if (object == null) {
            this.arrayTable.remove(string);
        } else {
            this.arrayTable.put(string, object);
        }
        this.firePropertyChange(string, object2, object);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        boolean bl3 = this.enabled;
        if (bl3 != bl2) {
            this.enabled = bl2;
            this.firePropertyChange("enabled", new Boolean(bl3), new Boolean(bl2));
        }
    }

    public Object[] getKeys() {
        if (this.arrayTable == null) {
            return null;
        }
        Object[] objectArray = new Object[this.arrayTable.size()];
        this.arrayTable.getKeys(objectArray);
        return objectArray;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport == null || object != null && object2 != null && object.equals(object2)) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() throws CloneNotSupportedException {
        AbstractAction abstractAction = (AbstractAction)super.clone();
        AbstractAction abstractAction2 = this;
        synchronized (abstractAction2) {
            if (this.arrayTable != null) {
                abstractAction.arrayTable = (ArrayTable)this.arrayTable.clone();
            }
        }
        return abstractAction;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ArrayTable.writeArrayTable(objectOutputStream, this.arrayTable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt() - 1;
        while (n2 >= 0) {
            this.putValue((String)objectInputStream.readObject(), objectInputStream.readObject());
            --n2;
        }
    }

    static class ArrayTable
    implements Cloneable {
        private Object table = null;
        private static final int ARRAY_BOUNDARY = 8;

        ArrayTable() {
        }

        public void put(Object object, Object object2) {
            if (this.table == null) {
                this.table = new Object[]{object, object2};
            } else {
                int n2 = this.size();
                if (n2 < 8) {
                    if (this.containsKey(object)) {
                        Object[] objectArray = (Object[])this.table;
                        int n3 = 0;
                        while (n3 < objectArray.length - 1) {
                            if (objectArray[n3].equals(object)) {
                                objectArray[n3 + 1] = object2;
                                break;
                            }
                            n3 += 2;
                        }
                    } else {
                        Object[] objectArray = (Object[])this.table;
                        int n4 = objectArray.length;
                        Object[] objectArray2 = new Object[n4 + 2];
                        System.arraycopy(objectArray, 0, objectArray2, 0, n4);
                        objectArray2[n4] = object;
                        objectArray2[n4 + 1] = object2;
                        this.table = objectArray2;
                    }
                } else {
                    if (n2 == 8 && this.isArray()) {
                        this.grow();
                    }
                    ((Hashtable)this.table).put(object, object2);
                }
            }
        }

        public Object get(Object object) {
            Object object2 = null;
            if (this.table != null) {
                if (this.isArray()) {
                    Object[] objectArray = (Object[])this.table;
                    int n2 = 0;
                    while (n2 < objectArray.length - 1) {
                        if (objectArray[n2].equals(object)) {
                            object2 = objectArray[n2 + 1];
                            break;
                        }
                        n2 += 2;
                    }
                } else {
                    object2 = ((Hashtable)this.table).get(object);
                }
            }
            return object2;
        }

        public int size() {
            if (this.table == null) {
                return 0;
            }
            int n2 = this.isArray() ? ((Object[])this.table).length / 2 : ((Hashtable)this.table).size();
            return n2;
        }

        public boolean containsKey(Object object) {
            boolean bl2 = false;
            if (this.table != null) {
                if (this.isArray()) {
                    Object[] objectArray = (Object[])this.table;
                    int n2 = 0;
                    while (n2 < objectArray.length - 1) {
                        if (objectArray[n2].equals(object)) {
                            bl2 = true;
                            break;
                        }
                        n2 += 2;
                    }
                } else {
                    bl2 = ((Hashtable)this.table).containsKey(object);
                }
            }
            return bl2;
        }

        public Object remove(Object object) {
            Object object2 = null;
            if (object == null) {
                return null;
            }
            if (this.table != null) {
                if (this.isArray()) {
                    int n2 = -1;
                    Object[] objectArray = (Object[])this.table;
                    int n3 = objectArray.length - 2;
                    while (n3 >= 0) {
                        if (objectArray[n3].equals(object)) {
                            n2 = n3;
                            object2 = objectArray[n3 + 1];
                            break;
                        }
                        n3 -= 2;
                    }
                    if (n2 != -1) {
                        Object[] objectArray2 = new Object[objectArray.length - 2];
                        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                        if (n2 < objectArray2.length) {
                            System.arraycopy(objectArray, n2 + 2, objectArray2, n2, objectArray2.length - n2);
                        }
                        this.table = objectArray2.length == 0 ? null : objectArray2;
                    }
                } else {
                    object2 = ((Hashtable)this.table).remove(object);
                }
                if (this.size() == 7 && !this.isArray()) {
                    this.shrink();
                }
            }
            return object2;
        }

        public void clear() {
            this.table = null;
        }

        public Object clone() {
            ArrayTable arrayTable = new ArrayTable();
            if (this.isArray()) {
                Object[] objectArray = (Object[])this.table;
                int n2 = 0;
                while (n2 < objectArray.length - 1) {
                    arrayTable.put(objectArray[n2], objectArray[n2 + 1]);
                    n2 += 2;
                }
            } else {
                Hashtable hashtable = (Hashtable)this.table;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    arrayTable.put(object, hashtable.get(object));
                }
            }
            return arrayTable;
        }

        public Object[] getKeys(Object[] objectArray) {
            if (this.table == null) {
                return null;
            }
            if (this.isArray()) {
                Object[] objectArray2 = (Object[])this.table;
                if (objectArray == null) {
                    objectArray = new Object[objectArray2.length / 2];
                }
                int n2 = 0;
                int n3 = 0;
                while (n2 < objectArray2.length - 1) {
                    objectArray[n3] = objectArray2[n2];
                    n2 += 2;
                    ++n3;
                }
            } else {
                Hashtable hashtable = (Hashtable)this.table;
                Enumeration enumeration = hashtable.keys();
                int n4 = hashtable.size();
                if (objectArray == null) {
                    objectArray = new Object[n4];
                }
                while (n4 > 0) {
                    objectArray[--n4] = enumeration.nextElement();
                }
            }
            return objectArray;
        }

        private boolean isArray() {
            return this.table instanceof Object[];
        }

        private void grow() {
            Object[] objectArray = (Object[])this.table;
            Hashtable hashtable = new Hashtable(objectArray.length / 2);
            int n2 = 0;
            while (n2 < objectArray.length) {
                hashtable.put(objectArray[n2], objectArray[n2 + 1]);
                n2 += 2;
            }
            this.table = hashtable;
        }

        private void shrink() {
            Hashtable hashtable = (Hashtable)this.table;
            Object[] objectArray = new Object[hashtable.size() * 2];
            Enumeration enumeration = hashtable.keys();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Object object;
                objectArray[n2] = object = enumeration.nextElement();
                objectArray[n2 + 1] = hashtable.get(object);
                n2 += 2;
            }
            this.table = objectArray;
        }

        static void writeArrayTable(ObjectOutputStream objectOutputStream, ArrayTable arrayTable) throws IOException {
            Object[] objectArray;
            if (arrayTable == null || (objectArray = arrayTable.getKeys(null)) == null) {
                objectOutputStream.writeInt(0);
            } else {
                int n2 = 0;
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (objectArray[n3] instanceof Serializable && arrayTable.get(objectArray[n3]) instanceof Serializable) {
                        ++n2;
                    } else {
                        objectArray[n3] = null;
                    }
                    ++n3;
                }
                objectOutputStream.writeInt(n2);
                if (n2 > 0) {
                    int n4 = 0;
                    while (n4 < objectArray.length) {
                        if (objectArray[n4] != null) {
                            objectOutputStream.writeObject(objectArray[n4]);
                            objectOutputStream.writeObject(arrayTable.get(objectArray[n4]));
                            if (--n2 == 0) break;
                        }
                        ++n4;
                    }
                }
            }
        }
    }
}

