/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Base64;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.prefs.XmlSupport;

public abstract class AbstractPreferences
extends Preferences {
    private final String name;
    private final String absolutePath;
    private final AbstractPreferences parent;
    private final AbstractPreferences root;
    protected boolean newNode = false;
    private Map kidCache = new HashMap();
    private boolean removed = false;
    private PreferenceChangeListener[] prefListeners = new PreferenceChangeListener[0];
    private NodeChangeListener[] nodeListeners = new NodeChangeListener[0];
    protected final Object lock = new Object();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final AbstractPreferences[] EMPTY_ABSTRACT_PREFS_ARRAY = new AbstractPreferences[0];
    private static final List eventQueue = new LinkedList();
    private static Thread eventDispatchThread = null;

    protected AbstractPreferences(AbstractPreferences abstractPreferences, String string) {
        if (abstractPreferences == null) {
            if (!string.equals("")) {
                throw new IllegalArgumentException("Root name '" + string + "' must be \"\"");
            }
            this.absolutePath = "/";
            this.root = this;
        } else {
            if (string.indexOf(47) != -1) {
                throw new IllegalArgumentException("Name '" + string + "' contains '/'");
            }
            if (string.equals("")) {
                throw new IllegalArgumentException("Illegal name: empty string");
            }
            this.root = abstractPreferences.root;
            this.absolutePath = abstractPreferences == this.root ? "/" + string : abstractPreferences.absolutePath() + "/" + string;
        }
        this.name = string;
        this.parent = abstractPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        if (string.length() > 80) {
            throw new IllegalArgumentException("Key too long: " + string);
        }
        if (string2.length() > 8192) {
            throw new IllegalArgumentException("Value too long: " + string2);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            this.putSpi(string, string2);
            this.enqueuePreferenceChangeEvent(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null key");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            String string3 = null;
            try {
                string3 = this.getSpi(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = string3 == null ? string2 : string3;
            return string4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            this.removeSpi(string);
            this.enqueuePreferenceChangeEvent(string, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            String[] stringArray = this.keys();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.remove(stringArray[n2]);
                ++n2;
            }
        }
    }

    public void putInt(String string, int n2) {
        this.put(string, Integer.toString(n2));
    }

    public int getInt(String string, int n2) {
        int n3 = n2;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                n3 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n3;
    }

    public void putLong(String string, long l2) {
        this.put(string, Long.toString(l2));
    }

    public long getLong(String string, long l2) {
        long l3 = l2;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                l3 = Long.parseLong(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l3;
    }

    public void putBoolean(String string, boolean bl2) {
        this.put(string, String.valueOf(bl2));
    }

    public boolean getBoolean(String string, boolean bl2) {
        boolean bl3 = bl2;
        String string2 = this.get(string, null);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("true")) {
                bl3 = true;
            } else if (string2.equalsIgnoreCase("false")) {
                bl3 = false;
            }
        }
        return bl3;
    }

    public void putFloat(String string, float f2) {
        this.put(string, Float.toString(f2));
    }

    public float getFloat(String string, float f2) {
        float f3 = f2;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                f3 = Float.parseFloat(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f3;
    }

    public void putDouble(String string, double d2) {
        this.put(string, Double.toString(d2));
    }

    public double getDouble(String string, double d2) {
        double d3 = d2;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                d3 = Double.parseDouble(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d3;
    }

    public void putByteArray(String string, byte[] byArray) {
        this.put(string, Base64.byteArrayToBase64(byArray));
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        byte[] byArray2 = byArray;
        String string2 = this.get(string, null);
        try {
            if (string2 != null) {
                byArray2 = Base64.base64ToByteArray(string2);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] keys() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            String[] stringArray = this.keysSpi();
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] childrenNames() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            TreeSet treeSet = new TreeSet(this.kidCache.keySet());
            String[] stringArray = this.childrenNamesSpi();
            int n2 = 0;
            while (n2 < stringArray.length) {
                treeSet.add(stringArray[n2]);
                ++n2;
            }
            String[] stringArray2 = (String[])treeSet.toArray(EMPTY_STRING_ARRAY);
            return stringArray2;
        }
    }

    protected final AbstractPreferences[] cachedChildren() {
        return (AbstractPreferences[])this.kidCache.values().toArray(EMPTY_ABSTRACT_PREFS_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences parent() {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            AbstractPreferences abstractPreferences = this.parent;
            return abstractPreferences;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences node(String string) {
        Object object = this.lock;
        synchronized (object) {
            block9: {
                block8: {
                    block7: {
                        if (this.removed) {
                            throw new IllegalStateException("Node has been removed.");
                        }
                        if (!string.equals("")) break block7;
                        AbstractPreferences abstractPreferences = this;
                        return abstractPreferences;
                    }
                    if (!string.equals("/")) break block8;
                    AbstractPreferences abstractPreferences = this.root;
                    return abstractPreferences;
                }
                if (string.charAt(0) == '/') break block9;
                Preferences preferences = this.node(new StringTokenizer(string, "/", true));
                return preferences;
            }
        }
        return this.root.node(new StringTokenizer(string.substring(1), "/", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences node(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        if (string.equals("/")) {
            throw new IllegalArgumentException("Consecutive slashes in path");
        }
        Object object = this.lock;
        synchronized (object) {
            AbstractPreferences abstractPreferences;
            block9: {
                abstractPreferences = (AbstractPreferences)this.kidCache.get(string);
                if (abstractPreferences == null) {
                    if (string.length() > 80) {
                        throw new IllegalArgumentException("Node name " + string + " too long");
                    }
                    abstractPreferences = this.childSpi(string);
                    if (abstractPreferences.newNode) {
                        this.enqueueNodeAddedEvent(abstractPreferences);
                    }
                    this.kidCache.put(string, abstractPreferences);
                }
                if (stringTokenizer.hasMoreTokens()) break block9;
                AbstractPreferences abstractPreferences2 = abstractPreferences;
                return abstractPreferences2;
            }
            stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("Path ends with slash");
            }
            Preferences preferences = abstractPreferences.node(stringTokenizer);
            return preferences;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeExists(String string) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            block9: {
                block8: {
                    block7: {
                        if (!string.equals("")) break block7;
                        boolean bl2 = !this.removed;
                        return bl2;
                    }
                    if (this.removed) {
                        throw new IllegalStateException("Node has been removed.");
                    }
                    if (!string.equals("/")) break block8;
                    boolean bl3 = true;
                    return bl3;
                }
                if (string.charAt(0) == '/') break block9;
                boolean bl4 = this.nodeExists(new StringTokenizer(string, "/", true));
                return bl4;
            }
        }
        return this.root.nodeExists(new StringTokenizer(string.substring(1), "/", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nodeExists(StringTokenizer stringTokenizer) throws BackingStoreException {
        String string = stringTokenizer.nextToken();
        if (string.equals("/")) {
            throw new IllegalArgumentException("Consecutive slashes in path");
        }
        Object object = this.lock;
        synchronized (object) {
            AbstractPreferences abstractPreferences;
            block9: {
                block8: {
                    abstractPreferences = (AbstractPreferences)this.kidCache.get(string);
                    if (abstractPreferences == null) {
                        abstractPreferences = this.getChild(string);
                    }
                    if (abstractPreferences != null) break block8;
                    boolean bl2 = false;
                    return bl2;
                }
                if (stringTokenizer.hasMoreTokens()) break block9;
                boolean bl3 = true;
                return bl3;
            }
            stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("Path ends with slash");
            }
            boolean bl4 = abstractPreferences.nodeExists(stringTokenizer);
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode() throws BackingStoreException {
        if (this == this.root) {
            throw new UnsupportedOperationException("Can't remove the root!");
        }
        Object object = this.parent.lock;
        synchronized (object) {
            this.removeNode2();
            this.parent.kidCache.remove(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode2() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node already removed.");
            }
            String[] stringArray = this.childrenNamesSpi();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (!this.kidCache.containsKey(stringArray[n2])) {
                    this.kidCache.put(stringArray[n2], this.childSpi(stringArray[n2]));
                }
                ++n2;
            }
            Iterator iterator = this.kidCache.values().iterator();
            while (iterator.hasNext()) {
                ((AbstractPreferences)iterator.next()).removeNode2();
            }
            this.kidCache.clear();
            this.removeNodeSpi();
            this.removed = true;
            this.parent.enqueueNodeRemovedEvent(this);
        }
    }

    public String name() {
        return this.name;
    }

    public String absolutePath() {
        return this.absolutePath;
    }

    public boolean isUserNode() {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(AbstractPreferences.this.root == Preferences.userRoot());
            }
        });
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        if (preferenceChangeListener == null) {
            throw new NullPointerException("Change listener is null.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            PreferenceChangeListener[] preferenceChangeListenerArray = this.prefListeners;
            this.prefListeners = new PreferenceChangeListener[preferenceChangeListenerArray.length + 1];
            System.arraycopy(preferenceChangeListenerArray, 0, this.prefListeners, 0, preferenceChangeListenerArray.length);
            this.prefListeners[preferenceChangeListenerArray.length] = preferenceChangeListener;
        }
        AbstractPreferences.startEventDispatchThreadIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void removePreferenceChangeListener(PreferenceChangeListener var1_1) {
        var2_2 = this.lock;
        synchronized (var2_2) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            if (this.prefListeners == null || this.prefListeners.length == 0) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            var3_3 = new PreferenceChangeListener[this.prefListeners.length - 1];
            var4_4 = 0;
            while (var4_4 < var3_3.length && this.prefListeners[var4_4] != var1_1) {
                var3_3[var4_4] = this.prefListeners[var4_4++];
            }
            if (var4_4 != var3_3.length || this.prefListeners[var4_4] == var1_1) ** GOTO lbl16
            throw new IllegalArgumentException("Listener not registered.");
lbl-1000:
            // 1 sources

            {
                var3_3[var4_4++] = this.prefListeners[var4_4];
lbl16:
                // 2 sources

                ** while (var4_4 < var3_3.length)
            }
lbl17:
            // 1 sources

            this.prefListeners = var3_3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeChangeListener(NodeChangeListener nodeChangeListener) {
        if (nodeChangeListener == null) {
            throw new NullPointerException("Change listener is null.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            if (this.nodeListeners == null) {
                this.nodeListeners = new NodeChangeListener[1];
                this.nodeListeners[0] = nodeChangeListener;
            } else {
                NodeChangeListener[] nodeChangeListenerArray = this.nodeListeners;
                this.nodeListeners = new NodeChangeListener[nodeChangeListenerArray.length + 1];
                System.arraycopy(nodeChangeListenerArray, 0, this.nodeListeners, 0, nodeChangeListenerArray.length);
                this.nodeListeners[nodeChangeListenerArray.length] = nodeChangeListener;
            }
        }
        AbstractPreferences.startEventDispatchThreadIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void removeNodeChangeListener(NodeChangeListener var1_1) {
        var2_2 = this.lock;
        synchronized (var2_2) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed.");
            }
            if (this.nodeListeners == null || this.nodeListeners.length == 0) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            var3_3 = new NodeChangeListener[this.nodeListeners.length - 1];
            var4_4 = 0;
            while (var4_4 < this.nodeListeners.length && this.nodeListeners[var4_4] != var1_1) {
                var3_3[var4_4] = this.nodeListeners[var4_4++];
            }
            if (var4_4 != this.nodeListeners.length) ** GOTO lbl16
            throw new IllegalArgumentException("Listener not registered.");
lbl-1000:
            // 1 sources

            {
                var3_3[var4_4++] = this.nodeListeners[var4_4];
lbl16:
                // 2 sources

                ** while (var4_4 < var3_3.length)
            }
lbl17:
            // 1 sources

            this.nodeListeners = var3_3;
        }
    }

    protected abstract void putSpi(String var1, String var2);

    protected abstract String getSpi(String var1);

    protected abstract void removeSpi(String var1);

    protected abstract void removeNodeSpi() throws BackingStoreException;

    protected abstract String[] keysSpi() throws BackingStoreException;

    protected abstract String[] childrenNamesSpi() throws BackingStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractPreferences getChild(String string) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            String[] stringArray = this.childrenNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals(string)) {
                    return this.childSpi(stringArray[n2]);
                }
                ++n2;
            }
            return null;
        }
    }

    protected abstract AbstractPreferences childSpi(String var1);

    public String toString() {
        return (this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    public void sync() throws BackingStoreException {
        this.sync2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync2() throws BackingStoreException {
        AbstractPreferences[] abstractPreferencesArray;
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed");
            }
            this.syncSpi();
            abstractPreferencesArray = this.cachedChildren();
        }
        int n2 = 0;
        while (n2 < abstractPreferencesArray.length) {
            abstractPreferencesArray[n2].sync2();
            ++n2;
        }
    }

    protected abstract void syncSpi() throws BackingStoreException;

    public void flush() throws BackingStoreException {
        this.flush2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush2() throws BackingStoreException {
        AbstractPreferences[] abstractPreferencesArray;
        Object object = this.lock;
        synchronized (object) {
            if (this.removed) {
                throw new IllegalStateException("Node has been removed");
            }
            this.flushSpi();
            abstractPreferencesArray = this.cachedChildren();
        }
        int n2 = 0;
        while (n2 < abstractPreferencesArray.length) {
            abstractPreferencesArray[n2].flush2();
            ++n2;
        }
    }

    protected abstract void flushSpi() throws BackingStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRemoved() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = this.removed;
            return bl2;
        }
    }

    private static synchronized void startEventDispatchThreadIfNecessary() {
        if (eventDispatchThread == null) {
            eventDispatchThread = new EventDispatchThread();
            eventDispatchThread.setDaemon(true);
            eventDispatchThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreferenceChangeListener[] prefListeners() {
        Object object = this.lock;
        synchronized (object) {
            PreferenceChangeListener[] preferenceChangeListenerArray = this.prefListeners;
            return preferenceChangeListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeChangeListener[] nodeListeners() {
        Object object = this.lock;
        synchronized (object) {
            NodeChangeListener[] nodeChangeListenerArray = this.nodeListeners;
            return nodeChangeListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueuePreferenceChangeEvent(String string, String string2) {
        if (this.prefListeners.length != 0) {
            List list = eventQueue;
            synchronized (list) {
                eventQueue.add(new PreferenceChangeEvent(this, string, string2));
                eventQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueNodeAddedEvent(Preferences preferences) {
        if (this.nodeListeners.length != 0) {
            List list = eventQueue;
            synchronized (list) {
                eventQueue.add(new NodeAddedEvent(this, preferences));
                eventQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueNodeRemovedEvent(Preferences preferences) {
        if (this.nodeListeners.length != 0) {
            List list = eventQueue;
            synchronized (list) {
                eventQueue.add(new NodeRemovedEvent(this, preferences));
                eventQueue.notify();
            }
        }
    }

    public void exportNode(OutputStream outputStream) throws IOException, BackingStoreException {
        XmlSupport.export(outputStream, this, false);
    }

    public void exportSubtree(OutputStream outputStream) throws IOException, BackingStoreException {
        XmlSupport.export(outputStream, this, true);
    }

    static /* synthetic */ List access$100() {
        return eventQueue;
    }

    private static class EventDispatchThread
    extends Thread {
        private EventDispatchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void run() {
            block5: while (true) lbl-1000:
            // 4 sources

            {
                block11: {
                    block10: {
                        var1_1 = null;
                        var2_2 = AbstractPreferences.access$100();
                        synchronized (var2_2) {
                            try {
                                while (AbstractPreferences.access$100().isEmpty()) {
                                    AbstractPreferences.access$100().wait();
                                }
                                var1_1 = (EventObject)AbstractPreferences.access$100().remove(0);
                            }
                            catch (InterruptedException var3_4) {
                                return;
                            }
                        }
                        var3_3 = (AbstractPreferences)var1_1.getSource();
                        if (!(var1_1 instanceof PreferenceChangeEvent)) break block10;
                        var4_5 /* !! */  = (PreferenceChangeEvent)var1_1;
                        var5_7 = var3_3.prefListeners();
                        var6_8 = 0;
                        while (true) {
                            if (var6_8 >= var5_7.length) ** GOTO lbl-1000
                            var5_7[var6_8].preferenceChange(var4_5 /* !! */ );
                            ++var6_8;
                        }
                    }
                    var4_5 /* !! */  = (NodeChangeEvent)var1_1;
                    var5_7 = var3_3.nodeListeners();
                    if (!(var4_5 /* !! */  instanceof NodeAddedEvent)) break block11;
                    var6_8 = 0;
                    while (true) {
                        if (var6_8 >= var5_7.length) ** GOTO lbl-1000
                        var5_7[var6_8].childAdded((NodeChangeEvent)var4_5 /* !! */ );
                        ++var6_8;
                    }
                }
                var6_8 = 0;
                while (true) {
                    if (var6_8 >= var5_7.length) continue block5;
                    var5_7[var6_8].childRemoved((NodeChangeEvent)var4_5 /* !! */ );
                    ++var6_8;
                }
                break;
            }
        }
    }

    private class NodeRemovedEvent
    extends NodeChangeEvent {
        NodeRemovedEvent(Preferences preferences, Preferences preferences2) {
            super(preferences, preferences2);
        }
    }

    private class NodeAddedEvent
    extends NodeChangeEvent {
        NodeAddedEvent(Preferences preferences, Preferences preferences2) {
            super(preferences, preferences2);
        }
    }
}

