/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import sun.misc.AtomicLong;

public class Random
implements Serializable {
    static final long serialVersionUID = 3905348978240129619L;
    private AtomicLong seed = AtomicLong.newAtomicLong(0L);
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTES_PER_INT = 4;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("seed", Long.TYPE), new ObjectStreamField("nextNextGaussian", Double.TYPE), new ObjectStreamField("haveNextNextGaussian", Boolean.TYPE)};

    public Random() {
        this(System.currentTimeMillis());
    }

    public Random(long l2) {
        this.setSeed(l2);
    }

    public synchronized void setSeed(long l2) {
        l2 = (l2 ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        while (!this.seed.attemptSet(l2)) {
        }
        this.haveNextNextGaussian = false;
    }

    protected int next(int n2) {
        long l2;
        long l3;
        while (!this.seed.attemptUpdate(l3 = this.seed.get(), l2 = l3 * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        return (int)(l2 >>> 48 - n2);
    }

    public void nextBytes(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        block0: while (true) {
            int n5 = 0;
            while (true) {
                if (n5 >= 4) continue block0;
                if (n3 == n2) {
                    return;
                }
                n4 = n5 == 0 ? this.next(32) : n4 >> 8;
                byArray[n3++] = (byte)n4;
                ++n5;
            }
            break;
        }
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n2) {
        int n3;
        int n4;
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n2 & -n2) == n2) {
            return (int)((long)n2 * (long)this.next(31) >> 31);
        }
        while ((n4 = this.next(31)) - (n3 = n4 % n2) + (n2 - 1) < 0) {
        }
        return n3;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public float nextFloat() {
        int n2 = this.next(24);
        return (float)n2 / 1.6777216E7f;
    }

    public double nextDouble() {
        long l2 = ((long)this.next(26) << 27) + (long)this.next(27);
        return (double)l2 / 9.007199254740992E15;
    }

    public synchronized double nextGaussian() {
        double d2;
        double d3;
        double d4;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((d4 = (d3 = 2.0 * this.nextDouble() - 1.0) * d3 + (d2 = 2.0 * this.nextDouble() - 1.0) * d2) >= 1.0 || d4 == 0.0) {
        }
        double d5 = Math.sqrt(-2.0 * Math.log(d4) / d4);
        this.nextNextGaussian = d2 * d5;
        this.haveNextNextGaussian = true;
        return d3 * d5;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        long l2 = getField.get("seed", -1L);
        if (l2 < 0L) {
            throw new StreamCorruptedException("Random: invalid seed");
        }
        this.seed = AtomicLong.newAtomicLong(l2);
        this.nextNextGaussian = getField.get("nextNextGaussian", 0.0);
        this.haveNextNextGaussian = getField.get("haveNextNextGaussian", false);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("seed", this.seed.get());
        putField.put("nextNextGaussian", this.nextNextGaussian);
        putField.put("haveNextNextGaussian", this.haveNextNextGaussian);
        objectOutputStream.writeFields();
    }
}

