/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Properties
extends Hashtable {
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Properties() {
        this(null);
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    public synchronized Object setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            int n3;
            char c2;
            if (string.length() <= 0 || (c2 = string.charAt(0)) == '#' || c2 == '!') continue;
            while (this.continueLine(string)) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string.substring(0, string.length() - 1);
                n3 = 0;
                n3 = 0;
                while (n3 < string2.length()) {
                    if (whiteSpaceChars.indexOf(string2.charAt(n3)) == -1) break;
                    ++n3;
                }
                string2 = string2.substring(n3, string2.length());
                string = new String(string3 + string2);
            }
            int n4 = string.length();
            int n5 = 0;
            while (n5 < n4) {
                if (whiteSpaceChars.indexOf(string.charAt(n5)) == -1) break;
                ++n5;
            }
            if (n5 == n4) continue;
            n3 = n5;
            while (n3 < n4) {
                n2 = string.charAt(n3);
                if (n2 == 92) {
                    ++n3;
                } else if (keyValueSeparators.indexOf(n2) != -1) break;
                ++n3;
            }
            n2 = n3;
            while (n2 < n4) {
                if (whiteSpaceChars.indexOf(string.charAt(n2)) == -1) break;
                ++n2;
            }
            if (n2 < n4 && strictKeyValueSeparators.indexOf(string.charAt(n2)) != -1) {
                ++n2;
            }
            while (n2 < n4) {
                if (whiteSpaceChars.indexOf(string.charAt(n2)) == -1) break;
                ++n2;
            }
            String string4 = string.substring(n5, n3);
            String string5 = n3 < n4 ? string.substring(n2, n4) : "";
            string4 = this.loadConvert(string4);
            string5 = this.loadConvert(string5);
            this.put(string4, string5);
        }
        return;
    }

    private boolean continueLine(String string) {
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0 && string.charAt(n3--) == '\\') {
            ++n2;
        }
        return n2 % 2 == 1;
    }

    private String loadConvert(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if ((n4 = string.charAt(n3++)) == 92) {
                if ((n4 = string.charAt(n3++)) == 117) {
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < 4) {
                        n4 = string.charAt(n3++);
                        switch (n4) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n5 = (n5 << 4) + n4 - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n5 = (n5 << 4) + 10 + n4 - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n5 = (n5 << 4) + 10 + n4 - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++n6;
                    }
                    stringBuffer.append((char)n5);
                    continue;
                }
                if (n4 == 116) {
                    n4 = 9;
                } else if (n4 == 114) {
                    n4 = 13;
                } else if (n4 == 110) {
                    n4 = 10;
                } else if (n4 == 102) {
                    n4 = 12;
                }
                stringBuffer.append((char)n4);
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    private String saveConvert(String string, boolean bl2) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            switch (c2) {
                case ' ': {
                    if (n3 == 0 || bl2) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    break;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    break;
                }
                default: {
                    if (c2 < ' ' || c2 > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(Properties.toHex(c2 >> 12 & 0xF));
                        stringBuffer.append(Properties.toHex(c2 >> 8 & 0xF));
                        stringBuffer.append(Properties.toHex(c2 >> 4 & 0xF));
                        stringBuffer.append(Properties.toHex(c2 & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(c2) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c2);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public synchronized void save(OutputStream outputStream, String string) {
        try {
            this.store(outputStream, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            Properties.writeln(bufferedWriter, "#" + string);
        }
        Properties.writeln(bufferedWriter, "#" + new Date().toString());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.get(string2);
            string2 = this.saveConvert(string2, true);
            string3 = this.saveConvert(string3, false);
            Properties.writeln(bufferedWriter, string2 + "=" + string3);
        }
        bufferedWriter.flush();
    }

    private static void writeln(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    public String getProperty(String string) {
        Object object = super.get(string);
        String string2 = object instanceof String ? (String)object : null;
        return string2 == null && this.defaults != null ? this.defaults.getProperty(string) : string2;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    public Enumeration propertyNames() {
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        return hashtable.keys();
    }

    public void list(PrintStream printStream) {
        printStream.println("-- listing properties --");
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string2.length() > 40) {
                string2 = string2.substring(0, 37) + "...";
            }
            printStream.println(string + "=" + string2);
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.println("-- listing properties --");
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string2.length() > 40) {
                string2 = string2.substring(0, 37) + "...";
            }
            printWriter.println(string + "=" + string2);
        }
    }

    private synchronized void enumerate(Hashtable hashtable) {
        if (this.defaults != null) {
            this.defaults.enumerate(hashtable);
        }
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, this.get(string));
        }
    }

    private static char toHex(int n2) {
        return hexDigit[n2 & 0xF];
    }
}

