/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapIntBufferR;
import java.nio.IntBuffer;

class HeapIntBuffer
extends IntBuffer {
    HeapIntBuffer(int n2, int n3) {
        super(-1, 0, n3, n2, new int[n2], 0);
    }

    HeapIntBuffer(int[] nArray, int n2, int n3) {
        super(-1, n2, n2 + n3, nArray.length, nArray, 0);
    }

    protected HeapIntBuffer(int[] nArray, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, nArray, n6);
    }

    public IntBuffer slice() {
        return new HeapIntBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position());
    }

    public IntBuffer duplicate() {
        return new HeapIntBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public IntBuffer asReadOnlyBuffer() {
        return new HeapIntBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n2) {
        return n2 + this.offset;
    }

    public int get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public int get(int n2) {
        return this.hb[this.ix(this.checkIndex(n2))];
    }

    public IntBuffer get(int[] nArray, int n2, int n3) {
        Buffer.checkBounds(n2, n3, nArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), nArray, n2, n3);
        this.position(this.position() + n3);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public IntBuffer put(int n2) {
        this.hb[this.ix((int)this.nextPutIndex())] = n2;
        return this;
    }

    public IntBuffer put(int n2, int n3) {
        this.hb[this.ix((int)this.checkIndex((int)n2))] = n3;
        return this;
    }

    public IntBuffer put(int[] nArray, int n2, int n3) {
        Buffer.checkBounds(n2, n3, nArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(nArray, n2, this.hb, this.ix(this.position()), n3);
        this.position(this.position() + n3);
        return this;
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer instanceof HeapIntBuffer) {
            if (intBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapIntBuffer heapIntBuffer = (HeapIntBuffer)intBuffer;
            int n2 = heapIntBuffer.remaining();
            if (n2 > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapIntBuffer.hb, heapIntBuffer.ix(heapIntBuffer.position()), this.hb, this.ix(this.position()), n2);
            heapIntBuffer.position(heapIntBuffer.position() + n2);
            this.position(this.position() + n2);
        } else {
            super.put(intBuffer);
        }
        return this;
    }

    public IntBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

