/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;

public class InvocationEvent
extends AWTEvent
implements ActiveEvent {
    public static final int INVOCATION_FIRST = 1200;
    public static final int INVOCATION_DEFAULT = 1200;
    public static final int INVOCATION_LAST = 1200;
    protected Runnable runnable;
    protected Object notifier;
    protected boolean catchExceptions;
    private Exception exception = null;
    private long when;
    private static final long serialVersionUID = 436056344909459450L;

    public InvocationEvent(Object object, Runnable runnable) {
        this(object, runnable, null, false);
    }

    public InvocationEvent(Object object, Runnable runnable, Object object2, boolean bl2) {
        this(object, 1200, runnable, object2, bl2);
    }

    protected InvocationEvent(Object object, int n2, Runnable runnable, Object object2, boolean bl2) {
        super(object, n2);
        this.runnable = runnable;
        this.notifier = object2;
        this.catchExceptions = bl2;
        this.when = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        if (this.catchExceptions) {
            try {
                this.runnable.run();
            }
            catch (Exception exception) {
                this.exception = exception;
            }
        } else {
            this.runnable.run();
        }
        if (this.notifier != null) {
            Object object = this.notifier;
            synchronized (object) {
                this.notifier.notifyAll();
            }
        }
    }

    public Exception getException() {
        return this.catchExceptions ? this.exception : null;
    }

    public long getWhen() {
        return this.when;
    }

    public String paramString() {
        String string;
        switch (this.id) {
            case 1200: {
                string = "INVOCATION_DEFAULT";
                break;
            }
            default: {
                string = "unknown type";
            }
        }
        return string + ",runnable=" + this.runnable + ",notifier=" + this.notifier + ",catchExceptions=" + this.catchExceptions + ",when=" + this.when;
    }
}

