/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayoutInfo;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

public class GridBagLayout
implements LayoutManager2,
Serializable {
    protected static final int MAXGRIDSIZE = 512;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected Hashtable comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    protected GridBagLayoutInfo layoutInfo;
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    transient boolean rightToLeft = false;
    static final long serialVersionUID = 8838754796412211005L;

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.comptable.put(component, gridBagConstraints.clone());
    }

    public GridBagConstraints getConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        }
        return (GridBagConstraints)gridBagConstraints.clone();
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        }
        return gridBagConstraints;
    }

    private void removeConstraints(Component component) {
        this.comptable.remove(component);
    }

    public Point getLayoutOrigin() {
        Point point = new Point(0, 0);
        if (this.layoutInfo != null) {
            point.x = this.layoutInfo.startx;
            point.y = this.layoutInfo.starty;
        }
        return point;
    }

    public int[][] getLayoutDimensions() {
        if (this.layoutInfo == null) {
            return new int[2][0];
        }
        int[][] nArrayArray = new int[][]{new int[this.layoutInfo.width], new int[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.minWidth, 0, nArrayArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.minHeight, 0, nArrayArray[1], 0, this.layoutInfo.height);
        return nArrayArray;
    }

    public double[][] getLayoutWeights() {
        if (this.layoutInfo == null) {
            return new double[2][0];
        }
        double[][] dArrayArray = new double[][]{new double[this.layoutInfo.width], new double[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.weightX, 0, dArrayArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.weightY, 0, dArrayArray[1], 0, this.layoutInfo.height);
        return dArrayArray;
    }

    public Point location(int n2, int n3) {
        int n4;
        Point point = new Point(0, 0);
        if (this.layoutInfo == null) {
            return point;
        }
        int n5 = this.layoutInfo.startx;
        if (!this.rightToLeft) {
            n4 = 0;
            while (n4 < this.layoutInfo.width) {
                if ((n5 += this.layoutInfo.minWidth[n4]) <= n2) {
                    ++n4;
                    continue;
                }
                break;
            }
        } else {
            n4 = this.layoutInfo.width - 1;
            while (n4 >= 0) {
                if (n5 > n2) break;
                n5 += this.layoutInfo.minWidth[n4];
                --n4;
            }
            ++n4;
        }
        point.x = n4;
        n5 = this.layoutInfo.starty;
        n4 = 0;
        while (n4 < this.layoutInfo.height) {
            if ((n5 += this.layoutInfo.minHeight[n4]) > n3) break;
            ++n4;
        }
        point.y = n4;
        return point;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof GridBagConstraints) {
            this.setConstraints(component, (GridBagConstraints)object);
        } else if (object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraints must be a GridBagConstraint");
        }
    }

    public void removeLayoutComponent(Component component) {
        this.removeConstraints(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    public Dimension minimumLayoutSize(Container container) {
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 1);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        this.arrangeGrid(container);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected GridBagLayoutInfo getLayoutInfo(Container container, int n2) {
        return this.GetLayoutInfo(container, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridBagLayoutInfo GetLayoutInfo(Container container, int n2) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            GridBagConstraints gridBagConstraints;
            Component component;
            GridBagLayoutInfo gridBagLayoutInfo = new GridBagLayoutInfo();
            Component[] componentArray = container.getComponents();
            gridBagLayoutInfo.height = 0;
            gridBagLayoutInfo.width = 0;
            int n10 = -1;
            int n11 = -1;
            int[] nArray = new int[512];
            int[] nArray2 = new int[512];
            int n12 = 0;
            while (n12 < componentArray.length) {
                component = componentArray[n12];
                if (component.isVisible()) {
                    gridBagConstraints = this.lookupConstraints(component);
                    n9 = gridBagConstraints.gridx;
                    n8 = gridBagConstraints.gridy;
                    n7 = gridBagConstraints.gridwidth;
                    if (n7 <= 0) {
                        n7 = 1;
                    }
                    if ((n6 = gridBagConstraints.gridheight) <= 0) {
                        n6 = 1;
                    }
                    if (n9 < 0 && n8 < 0) {
                        if (n11 >= 0) {
                            n8 = n11;
                        } else if (n10 >= 0) {
                            n9 = n10;
                        } else {
                            n8 = 0;
                        }
                    }
                    if (n9 < 0) {
                        n5 = 0;
                        n4 = n8;
                        while (n4 < n8 + n6) {
                            n5 = Math.max(n5, nArray[n4]);
                            ++n4;
                        }
                        if ((n9 = n5 - n9 - 1) < 0) {
                            n9 = 0;
                        }
                    } else if (n8 < 0) {
                        n3 = 0;
                        n4 = n9;
                        while (n4 < n9 + n7) {
                            n3 = Math.max(n3, nArray2[n4]);
                            ++n4;
                        }
                        if ((n8 = n3 - n8 - 1) < 0) {
                            n8 = 0;
                        }
                    }
                    n5 = n9 + n7;
                    while (gridBagLayoutInfo.width < n5) {
                        ++gridBagLayoutInfo.width;
                    }
                    n3 = n8 + n6;
                    while (gridBagLayoutInfo.height < n3) {
                        ++gridBagLayoutInfo.height;
                    }
                    n4 = n9;
                    while (n4 < n9 + n7) {
                        nArray2[n4] = n3;
                        ++n4;
                    }
                    n4 = n8;
                    while (n4 < n8 + n6) {
                        nArray[n4] = n5;
                        ++n4;
                    }
                    Dimension dimension = n2 == 2 ? component.getPreferredSize() : component.getMinimumSize();
                    gridBagConstraints.minWidth = dimension.width;
                    gridBagConstraints.minHeight = dimension.height;
                    if (gridBagConstraints.gridheight == 0 && gridBagConstraints.gridwidth == 0) {
                        n10 = -1;
                        n11 = -1;
                    }
                    if (gridBagConstraints.gridheight == 0 && n11 < 0) {
                        n10 = n9 + n7;
                    } else if (gridBagConstraints.gridwidth == 0 && n10 < 0) {
                        n11 = n8 + n6;
                    }
                }
                ++n12;
            }
            if (this.columnWidths != null && gridBagLayoutInfo.width < this.columnWidths.length) {
                gridBagLayoutInfo.width = this.columnWidths.length;
            }
            if (this.rowHeights != null && gridBagLayoutInfo.height < this.rowHeights.length) {
                gridBagLayoutInfo.height = this.rowHeights.length;
            }
            n10 = -1;
            n11 = -1;
            nArray = new int[512];
            nArray2 = new int[512];
            n12 = 0;
            while (n12 < componentArray.length) {
                component = componentArray[n12];
                if (component.isVisible()) {
                    gridBagConstraints = this.lookupConstraints(component);
                    n9 = gridBagConstraints.gridx;
                    n8 = gridBagConstraints.gridy;
                    n7 = gridBagConstraints.gridwidth;
                    n6 = gridBagConstraints.gridheight;
                    if (n9 < 0 && n8 < 0) {
                        if (n11 >= 0) {
                            n8 = n11;
                        } else if (n10 >= 0) {
                            n9 = n10;
                        } else {
                            n8 = 0;
                        }
                    }
                    if (n9 < 0) {
                        if (n6 <= 0 && (n6 += gridBagLayoutInfo.height - n8) < 1) {
                            n6 = 1;
                        }
                        n5 = 0;
                        n4 = n8;
                        while (n4 < n8 + n6) {
                            n5 = Math.max(n5, nArray[n4]);
                            ++n4;
                        }
                        if ((n9 = n5 - n9 - 1) < 0) {
                            n9 = 0;
                        }
                    } else if (n8 < 0) {
                        if (n7 <= 0 && (n7 += gridBagLayoutInfo.width - n9) < 1) {
                            n7 = 1;
                        }
                        n3 = 0;
                        n4 = n9;
                        while (n4 < n9 + n7) {
                            n3 = Math.max(n3, nArray2[n4]);
                            ++n4;
                        }
                        if ((n8 = n3 - n8 - 1) < 0) {
                            n8 = 0;
                        }
                    }
                    if (n7 <= 0 && (n7 += gridBagLayoutInfo.width - n9) < 1) {
                        n7 = 1;
                    }
                    if (n6 <= 0 && (n6 += gridBagLayoutInfo.height - n8) < 1) {
                        n6 = 1;
                    }
                    n5 = n9 + n7;
                    n3 = n8 + n6;
                    n4 = n9;
                    while (n4 < n9 + n7) {
                        nArray2[n4] = n3;
                        ++n4;
                    }
                    n4 = n8;
                    while (n4 < n8 + n6) {
                        nArray[n4] = n5;
                        ++n4;
                    }
                    if (gridBagConstraints.gridheight == 0 && gridBagConstraints.gridwidth == 0) {
                        n10 = -1;
                        n11 = -1;
                    }
                    if (gridBagConstraints.gridheight == 0 && n11 < 0) {
                        n10 = n9 + n7;
                    } else if (gridBagConstraints.gridwidth == 0 && n10 < 0) {
                        n11 = n8 + n6;
                    }
                    gridBagConstraints.tempX = n9;
                    gridBagConstraints.tempY = n8;
                    gridBagConstraints.tempWidth = n7;
                    gridBagConstraints.tempHeight = n6;
                }
                ++n12;
            }
            if (this.columnWidths != null) {
                System.arraycopy(this.columnWidths, 0, gridBagLayoutInfo.minWidth, 0, this.columnWidths.length);
            }
            if (this.rowHeights != null) {
                System.arraycopy(this.rowHeights, 0, gridBagLayoutInfo.minHeight, 0, this.rowHeights.length);
            }
            if (this.columnWeights != null) {
                System.arraycopy(this.columnWeights, 0, gridBagLayoutInfo.weightX, 0, this.columnWeights.length);
            }
            if (this.rowWeights != null) {
                System.arraycopy(this.rowWeights, 0, gridBagLayoutInfo.weightY, 0, this.rowWeights.length);
            }
            int n13 = Integer.MAX_VALUE;
            n4 = 1;
            while (n4 != Integer.MAX_VALUE) {
                n12 = 0;
                while (n12 < componentArray.length) {
                    component = componentArray[n12];
                    if (component.isVisible()) {
                        int n14;
                        double d2;
                        double d3;
                        double d4;
                        int n15;
                        double d5;
                        gridBagConstraints = this.lookupConstraints(component);
                        if (gridBagConstraints.tempWidth == n4) {
                            n5 = gridBagConstraints.tempX + gridBagConstraints.tempWidth;
                            d5 = gridBagConstraints.weightx;
                            n15 = gridBagConstraints.tempX;
                            while (n15 < n5) {
                                d5 -= gridBagLayoutInfo.weightX[n15];
                                ++n15;
                            }
                            if (d5 > 0.0) {
                                d4 = 0.0;
                                n15 = gridBagConstraints.tempX;
                                while (n15 < n5) {
                                    d4 += gridBagLayoutInfo.weightX[n15];
                                    ++n15;
                                }
                                n15 = gridBagConstraints.tempX;
                                while (d4 > 0.0 && n15 < n5) {
                                    d3 = gridBagLayoutInfo.weightX[n15];
                                    d2 = d3 * d5 / d4;
                                    int n16 = n15++;
                                    gridBagLayoutInfo.weightX[n16] = gridBagLayoutInfo.weightX[n16] + d2;
                                    d5 -= d2;
                                    d4 -= d3;
                                }
                                int n17 = n5 - 1;
                                gridBagLayoutInfo.weightX[n17] = gridBagLayoutInfo.weightX[n17] + d5;
                            }
                            n14 = gridBagConstraints.minWidth + gridBagConstraints.ipadx + gridBagConstraints.insets.left + gridBagConstraints.insets.right;
                            n15 = gridBagConstraints.tempX;
                            while (n15 < n5) {
                                n14 -= gridBagLayoutInfo.minWidth[n15];
                                ++n15;
                            }
                            if (n14 > 0) {
                                d4 = 0.0;
                                n15 = gridBagConstraints.tempX;
                                while (n15 < n5) {
                                    d4 += gridBagLayoutInfo.weightX[n15];
                                    ++n15;
                                }
                                n15 = gridBagConstraints.tempX;
                                while (d4 > 0.0 && n15 < n5) {
                                    d3 = gridBagLayoutInfo.weightX[n15];
                                    int n18 = (int)(d3 * (double)n14 / d4);
                                    int n19 = n15++;
                                    gridBagLayoutInfo.minWidth[n19] = gridBagLayoutInfo.minWidth[n19] + n18;
                                    n14 -= n18;
                                    d4 -= d3;
                                }
                                int n20 = n5 - 1;
                                gridBagLayoutInfo.minWidth[n20] = gridBagLayoutInfo.minWidth[n20] + n14;
                            }
                        } else if (gridBagConstraints.tempWidth > n4 && gridBagConstraints.tempWidth < n13) {
                            n13 = gridBagConstraints.tempWidth;
                        }
                        if (gridBagConstraints.tempHeight == n4) {
                            n3 = gridBagConstraints.tempY + gridBagConstraints.tempHeight;
                            d5 = gridBagConstraints.weighty;
                            n15 = gridBagConstraints.tempY;
                            while (n15 < n3) {
                                d5 -= gridBagLayoutInfo.weightY[n15];
                                ++n15;
                            }
                            if (d5 > 0.0) {
                                d4 = 0.0;
                                n15 = gridBagConstraints.tempY;
                                while (n15 < n3) {
                                    d4 += gridBagLayoutInfo.weightY[n15];
                                    ++n15;
                                }
                                n15 = gridBagConstraints.tempY;
                                while (d4 > 0.0 && n15 < n3) {
                                    d3 = gridBagLayoutInfo.weightY[n15];
                                    d2 = d3 * d5 / d4;
                                    int n21 = n15++;
                                    gridBagLayoutInfo.weightY[n21] = gridBagLayoutInfo.weightY[n21] + d2;
                                    d5 -= d2;
                                    d4 -= d3;
                                }
                                int n22 = n3 - 1;
                                gridBagLayoutInfo.weightY[n22] = gridBagLayoutInfo.weightY[n22] + d5;
                            }
                            n14 = gridBagConstraints.minHeight + gridBagConstraints.ipady + gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
                            n15 = gridBagConstraints.tempY;
                            while (n15 < n3) {
                                n14 -= gridBagLayoutInfo.minHeight[n15];
                                ++n15;
                            }
                            if (n14 > 0) {
                                d4 = 0.0;
                                n15 = gridBagConstraints.tempY;
                                while (n15 < n3) {
                                    d4 += gridBagLayoutInfo.weightY[n15];
                                    ++n15;
                                }
                                n15 = gridBagConstraints.tempY;
                                while (d4 > 0.0 && n15 < n3) {
                                    d3 = gridBagLayoutInfo.weightY[n15];
                                    int n23 = (int)(d3 * (double)n14 / d4);
                                    int n24 = n15++;
                                    gridBagLayoutInfo.minHeight[n24] = gridBagLayoutInfo.minHeight[n24] + n23;
                                    n14 -= n23;
                                    d4 -= d3;
                                }
                                int n25 = n3 - 1;
                                gridBagLayoutInfo.minHeight[n25] = gridBagLayoutInfo.minHeight[n25] + n14;
                            }
                        } else if (gridBagConstraints.tempHeight > n4 && gridBagConstraints.tempHeight < n13) {
                            n13 = gridBagConstraints.tempHeight;
                        }
                    }
                    ++n12;
                }
                n4 = n13;
                n13 = Integer.MAX_VALUE;
            }
            GridBagLayoutInfo gridBagLayoutInfo2 = gridBagLayoutInfo;
            return gridBagLayoutInfo2;
        }
    }

    protected void adjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        this.AdjustForGravity(gridBagConstraints, rectangle);
    }

    protected void AdjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        rectangle.x = !this.rightToLeft ? (rectangle.x += gridBagConstraints.insets.left) : (rectangle.x -= rectangle.width - gridBagConstraints.insets.right);
        rectangle.width -= gridBagConstraints.insets.left + gridBagConstraints.insets.right;
        rectangle.y += gridBagConstraints.insets.top;
        rectangle.height -= gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
        int n2 = 0;
        if (gridBagConstraints.fill != 2 && gridBagConstraints.fill != 1 && rectangle.width > gridBagConstraints.minWidth + gridBagConstraints.ipadx) {
            n2 = rectangle.width - (gridBagConstraints.minWidth + gridBagConstraints.ipadx);
            rectangle.width = gridBagConstraints.minWidth + gridBagConstraints.ipadx;
        }
        int n3 = 0;
        if (gridBagConstraints.fill != 3 && gridBagConstraints.fill != 1 && rectangle.height > gridBagConstraints.minHeight + gridBagConstraints.ipady) {
            n3 = rectangle.height - (gridBagConstraints.minHeight + gridBagConstraints.ipady);
            rectangle.height = gridBagConstraints.minHeight + gridBagConstraints.ipady;
        }
        switch (gridBagConstraints.anchor) {
            case 10: {
                rectangle.x += n2 / 2;
                rectangle.y += n3 / 2;
                break;
            }
            case 11: 
            case 19: {
                rectangle.x += n2 / 2;
                break;
            }
            case 12: {
                rectangle.x += n2;
                break;
            }
            case 13: {
                rectangle.x += n2;
                rectangle.y += n3 / 2;
                break;
            }
            case 14: {
                rectangle.x += n2;
                rectangle.y += n3;
                break;
            }
            case 15: 
            case 20: {
                rectangle.x += n2 / 2;
                rectangle.y += n3;
                break;
            }
            case 16: {
                rectangle.y += n3;
                break;
            }
            case 17: {
                rectangle.y += n3 / 2;
                break;
            }
            case 18: {
                break;
            }
            case 21: {
                if (this.rightToLeft) {
                    rectangle.x += n2;
                }
                rectangle.y += n3 / 2;
                break;
            }
            case 22: {
                if (!this.rightToLeft) {
                    rectangle.x += n2;
                }
                rectangle.y += n3 / 2;
                break;
            }
            case 23: {
                if (!this.rightToLeft) break;
                rectangle.x += n2;
                break;
            }
            case 24: {
                if (this.rightToLeft) break;
                rectangle.x += n2;
                break;
            }
            case 25: {
                if (this.rightToLeft) {
                    rectangle.x += n2;
                }
                rectangle.y += n3;
                break;
            }
            case 26: {
                if (!this.rightToLeft) {
                    rectangle.x += n2;
                }
                rectangle.y += n3;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
        }
    }

    protected Dimension getMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        return this.GetMinSize(container, gridBagLayoutInfo);
    }

    protected Dimension GetMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        Dimension dimension = new Dimension();
        Insets insets = container.getInsets();
        int n2 = 0;
        int n3 = 0;
        while (n3 < gridBagLayoutInfo.width) {
            n2 += gridBagLayoutInfo.minWidth[n3];
            ++n3;
        }
        dimension.width = n2 + insets.left + insets.right;
        n2 = 0;
        n3 = 0;
        while (n3 < gridBagLayoutInfo.height) {
            n2 += gridBagLayoutInfo.minHeight[n3];
            ++n3;
        }
        dimension.height = n2 + insets.top + insets.bottom;
        return dimension;
    }

    protected void arrangeGrid(Container container) {
        this.ArrangeGrid(container);
    }

    protected void ArrangeGrid(Container container) {
        int n2;
        int n3;
        double d2;
        Insets insets = container.getInsets();
        Component[] componentArray = container.getComponents();
        Rectangle rectangle = new Rectangle();
        boolean bl2 = this.rightToLeft = !container.getComponentOrientation().isLeftToRight();
        if (!(componentArray.length != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return;
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        Dimension dimension = this.getMinSize(container, gridBagLayoutInfo);
        if (container.width < dimension.width || container.height < dimension.height) {
            gridBagLayoutInfo = this.getLayoutInfo(container, 1);
            dimension = this.getMinSize(container, gridBagLayoutInfo);
        }
        this.layoutInfo = gridBagLayoutInfo;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        int n4 = container.width - rectangle.width;
        if (n4 != 0) {
            d2 = 0.0;
            n3 = 0;
            while (n3 < gridBagLayoutInfo.width) {
                d2 += gridBagLayoutInfo.weightX[n3];
                ++n3;
            }
            if (d2 > 0.0) {
                n3 = 0;
                while (n3 < gridBagLayoutInfo.width) {
                    n2 = (int)((double)n4 * gridBagLayoutInfo.weightX[n3] / d2);
                    int n5 = n3;
                    gridBagLayoutInfo.minWidth[n5] = gridBagLayoutInfo.minWidth[n5] + n2;
                    rectangle.width += n2;
                    if (gridBagLayoutInfo.minWidth[n3] < 0) {
                        rectangle.width -= gridBagLayoutInfo.minWidth[n3];
                        gridBagLayoutInfo.minWidth[n3] = 0;
                    }
                    ++n3;
                }
            }
            n4 = container.width - rectangle.width;
        } else {
            n4 = 0;
        }
        int n6 = container.height - rectangle.height;
        if (n6 != 0) {
            d2 = 0.0;
            n3 = 0;
            while (n3 < gridBagLayoutInfo.height) {
                d2 += gridBagLayoutInfo.weightY[n3];
                ++n3;
            }
            if (d2 > 0.0) {
                n3 = 0;
                while (n3 < gridBagLayoutInfo.height) {
                    n2 = (int)((double)n6 * gridBagLayoutInfo.weightY[n3] / d2);
                    int n7 = n3;
                    gridBagLayoutInfo.minHeight[n7] = gridBagLayoutInfo.minHeight[n7] + n2;
                    rectangle.height += n2;
                    if (gridBagLayoutInfo.minHeight[n3] < 0) {
                        rectangle.height -= gridBagLayoutInfo.minHeight[n3];
                        gridBagLayoutInfo.minHeight[n3] = 0;
                    }
                    ++n3;
                }
            }
            n6 = container.height - rectangle.height;
        } else {
            n6 = 0;
        }
        gridBagLayoutInfo.startx = n4 / 2 + insets.left;
        gridBagLayoutInfo.starty = n6 / 2 + insets.top;
        int n8 = 0;
        while (n8 < componentArray.length) {
            Component component = componentArray[n8];
            if (component.isVisible()) {
                GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
                if (!this.rightToLeft) {
                    rectangle.x = gridBagLayoutInfo.startx;
                    n3 = 0;
                    while (n3 < gridBagConstraints.tempX) {
                        rectangle.x += gridBagLayoutInfo.minWidth[n3];
                        ++n3;
                    }
                } else {
                    rectangle.x = container.width - (n4 / 2 + insets.right);
                    n3 = 0;
                    while (n3 < gridBagConstraints.tempX) {
                        rectangle.x -= gridBagLayoutInfo.minWidth[n3];
                        ++n3;
                    }
                }
                rectangle.y = gridBagLayoutInfo.starty;
                n3 = 0;
                while (n3 < gridBagConstraints.tempY) {
                    rectangle.y += gridBagLayoutInfo.minHeight[n3];
                    ++n3;
                }
                rectangle.width = 0;
                n3 = gridBagConstraints.tempX;
                while (n3 < gridBagConstraints.tempX + gridBagConstraints.tempWidth) {
                    rectangle.width += gridBagLayoutInfo.minWidth[n3];
                    ++n3;
                }
                rectangle.height = 0;
                n3 = gridBagConstraints.tempY;
                while (n3 < gridBagConstraints.tempY + gridBagConstraints.tempHeight) {
                    rectangle.height += gridBagLayoutInfo.minHeight[n3];
                    ++n3;
                }
                this.adjustForGravity(gridBagConstraints, rectangle);
                if (rectangle.x < 0) {
                    rectangle.width -= rectangle.x;
                    rectangle.x = 0;
                }
                if (rectangle.y < 0) {
                    rectangle.height -= rectangle.y;
                    rectangle.y = 0;
                }
                if (rectangle.width <= 0 || rectangle.height <= 0) {
                    component.setBounds(0, 0, 0, 0);
                } else if (component.x != rectangle.x || component.y != rectangle.y || component.width != rectangle.width || component.height != rectangle.height) {
                    component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
            ++n8;
        }
    }
}

