/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import com.sun.security.auth.PolicyParser;
import com.sun.security.auth.PrincipalComparator;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import sun.security.util.Debug;

class SubjectCodeSource
extends CodeSource
implements Serializable {
    private static final ResourceBundle rb = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });
    private Subject subject;
    private LinkedList principals;
    private static final Class[] PARAMS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SubjectCodeSource.class$("java.lang.String")) : class$java$lang$String};
    private static final Debug debug = Debug.getInstance("auth", "\t[Auth Access]");
    private ClassLoader sysClassLoader;
    static /* synthetic */ Class class$java$lang$String;

    SubjectCodeSource(Subject subject, LinkedList linkedList, URL uRL, Certificate[] certificateArray) {
        super(uRL, certificateArray);
        this.subject = subject;
        this.principals = linkedList == null ? new LinkedList() : new LinkedList(linkedList);
        this.sysClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    LinkedList getPrincipals() {
        return this.principals;
    }

    Subject getSubject() {
        return this.subject;
    }

    /*
     * Unable to fully structure code
     */
    public boolean implies(CodeSource var1_1) {
        var2_2 = null;
        if (var1_1 == null || !(var1_1 instanceof SubjectCodeSource) || !super.implies(var1_1)) {
            if (SubjectCodeSource.debug != null) {
                SubjectCodeSource.debug.println("\tSubjectCodeSource.implies: FAILURE 1");
            }
            return false;
        }
        var3_3 = (SubjectCodeSource)var1_1;
        if (this.principals == null) {
            if (SubjectCodeSource.debug != null) {
                SubjectCodeSource.debug.println("\tSubjectCodeSource.implies: PASS 1");
            }
            return true;
        }
        if (var3_3.getSubject() == null || var3_3.getSubject().getPrincipals().size() == 0) {
            if (SubjectCodeSource.debug != null) {
                SubjectCodeSource.debug.println("\tSubjectCodeSource.implies: FAILURE 2");
            }
            return false;
        }
        var4_4 = this.principals.listIterator(0);
        while (var4_4.hasNext()) {
            block17: {
                var5_5 = (PolicyParser.PrincipalEntry)var4_4.next();
                try {
                    var6_7 = Class.forName(var5_5.principalClass, true, this.sysClassLoader);
                    var7_8 = var6_7.getConstructor(SubjectCodeSource.PARAMS);
                    var8_9 = (PrincipalComparator)var7_8.newInstance(new Object[]{var5_5.principalName});
                    if (!var8_9.implies(var3_3.getSubject())) {
                        if (SubjectCodeSource.debug != null) {
                            SubjectCodeSource.debug.println("\tSubjectCodeSource.implies: FAILURE 3");
                        }
                        return false;
                    }
                    if (SubjectCodeSource.debug != null) {
                        SubjectCodeSource.debug.println("\tSubjectCodeSource.implies: PASS 2");
                    }
                    return true;
                }
                catch (Exception var6_6) {
                    if (var2_2 != null) break block17;
                    if (var3_3.getSubject() == null) {
                        if (SubjectCodeSource.debug != null) {
                            SubjectCodeSource.debug.println("\tSubjectCodeSource.implies: FAILURE 4");
                        }
                        return false;
                    }
                    var7_8 = var3_3.getSubject().getPrincipals().iterator();
                    var2_2 = new LinkedList();
                    ** while (var7_8.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    var8_9 = (Principal)var7_8.next();
                    var9_10 = new PolicyParser.PrincipalEntry(var8_9.getClass().getName(), var8_9.getName());
                    var2_2.add(var9_10);
                    continue;
                }
            }
            if (this.subjectListImpliesPrincipalEntry(var2_2, var5_5)) continue;
            if (SubjectCodeSource.debug != null) {
                SubjectCodeSource.debug.println("\tSubjectCodeSource.implies: FAILURE 5");
            }
            return false;
        }
        if (SubjectCodeSource.debug != null) {
            SubjectCodeSource.debug.println("\tSubjectCodeSource.implies: PASS 3");
        }
        return true;
    }

    private boolean subjectListImpliesPrincipalEntry(LinkedList linkedList, PolicyParser.PrincipalEntry principalEntry) {
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry2 = (PolicyParser.PrincipalEntry)listIterator.next();
            if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.principalClass.equals(principalEntry2.principalClass) || !principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME") && !principalEntry.principalName.equals(principalEntry2.principalName)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SubjectCodeSource)) {
            return false;
        }
        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)object;
        try {
            if (this.getSubject() != subjectCodeSource.getSubject()) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        if (this.principals == null && subjectCodeSource.principals != null || this.principals != null && subjectCodeSource.principals == null) {
            return false;
        }
        return this.principals == null || subjectCodeSource.principals == null || this.principals.containsAll(subjectCodeSource.principals) && subjectCodeSource.principals.containsAll(this.principals);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        Object object;
        String string = super.toString();
        if (this.getSubject() != null) {
            if (debug != null) {
                object = this.getSubject();
                string = string + "\n" + AccessController.doPrivileged(new PrivilegedAction((Subject)object){
                    private final /* synthetic */ Subject val$finalSubject;
                    {
                        this.val$finalSubject = subject;
                    }

                    public Object run() {
                        return this.val$finalSubject.toString();
                    }
                });
            } else {
                string = string + "\n" + this.getSubject().toString();
            }
        }
        if (this.principals != null) {
            object = this.principals.listIterator();
            while (object.hasNext()) {
                PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)object.next();
                string = string + rb.getString("\n") + principalEntry.principalClass + " " + principalEntry.principalName;
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

