/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.File;
import java.io.FileFilter;
import java.io.FilePermission;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import sun.plugin.cache.CleanupThread;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.Trace;
import sun.plugin.usability.UserProfile;

public class Cache {
    protected static long maxSize;
    protected static long threadThresholdSize;
    protected static long deleteThresholdSize;
    protected static boolean cachingDisabled;
    protected static Random random;
    protected static CleanupThread cleanupThread;
    protected static final byte INCOMPLETE = 0;
    protected static final byte UNUSABLE = 1;
    protected static final byte INUSE = 2;
    protected static final byte VERSION = 16;
    protected static final String INDEX_FILE_EXT = ".idx";
    protected static final long CLEANUP_INTERVAL = 1L;
    protected static final long MINIMUM_CACHE_SIZE = 5L;
    protected static final String DISABLED_PROP = "javaplugin.cache.disabled";
    protected static final String DIRECTORY_PROP = "javaplugin.cache.directory";
    protected static final String SIZE_PROP = "javaplugin.cache.size";
    protected static String KB;
    protected static String MB;
    protected static String BYTES;
    protected static String UNLIMITED;

    public static void init() {
    }

    protected static final boolean isSupportedProtocol(URL uRL) {
        String string = uRL.getProtocol();
        return string != null && (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https"));
    }

    protected static final void message(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        Trace.println(messageFormat.format(objectArray), 2);
    }

    protected static final Object privileged(CacheIOAction cacheIOAction) throws IOException {
        try {
            return AccessController.doPrivileged(cacheIOAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    protected static final File getIndexFile(File file, URL uRL) {
        String string = file.getName();
        string = string.substring(0, string.length() - Cache.getFileExtension(uRL.toString()).length());
        string = string + INDEX_FILE_EXT;
        return new File(file.getParentFile(), string);
    }

    protected static final File getDataFile(File file, String string) {
        String string2 = file.getName();
        string2 = string2.substring(0, string2.length() - INDEX_FILE_EXT.length());
        string2 = string2 + Cache.getFileExtension(string);
        return new File(file.getParentFile(), string2);
    }

    protected static final String getFileExtension(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(n);
        }
        if (string2.equalsIgnoreCase(".jar") || string2.equalsIgnoreCase(".jarjar")) {
            string2 = ".zip";
        }
        return string2;
    }

    protected static String generateCacheFileName(File file, URL uRL) throws IOException {
        File file2;
        String string;
        File file3;
        String string2 = Cache.getKey(uRL);
        do {
            string = string2 + Integer.toString(Cache.getRandom(), 16);
            file2 = new File(file, string + Cache.getFileExtension(uRL.toString()));
        } while ((file3 = new File(file, string + INDEX_FILE_EXT)).exists() || file2.exists());
        file3 = null;
        file2 = null;
        return string;
    }

    protected static Enumeration getMatchingFiles(File file, URL uRL) {
        final String string = Cache.getKey(uRL);
        final File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(string);
            }
        });
        return new Enumeration(){
            private int index = 0;

            public boolean hasMoreElements() {
                return this.index < fileArray.length;
            }

            public Object nextElement() {
                return fileArray[this.index++];
            }
        };
    }

    protected static final void touch(final File file) throws IOException {
        Cache.privileged(new CacheIOAction(){

            public Object run() throws IOException {
                file.setLastModified(System.currentTimeMillis());
                return null;
            }
        });
    }

    protected static String getKey(URL uRL) {
        int n;
        String string = uRL.getPath();
        int n2 = string.lastIndexOf("/");
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        if ((n = uRL.hashCode()) < 0) {
            n += Integer.MIN_VALUE;
        }
        return string + "-" + Integer.toString(n, 16) + "-";
    }

    protected static String parseKey(String string) {
        String string2 = null;
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string2 = string.substring(0, n + 1);
        }
        return string2;
    }

    protected static final int getRandom() {
        return 0x10000000 + random.nextInt(0x6FFFFFFF);
    }

    protected static void checkPermission(URLConnection uRLConnection) throws IOException {
        SecurityManager securityManager;
        Permission permission = uRLConnection.getPermission();
        URL uRL = uRLConnection.getURL();
        if (permission != null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
    }

    protected static long getFileSizeFromServer(URL uRL) throws IOException {
        long l = -1L;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("HEAD");
        l = httpURLConnection.getContentLength();
        httpURLConnection.disconnect();
        return l;
    }

    protected static void addToTable(File file, Hashtable hashtable) {
        String string = Cache.parseKey(file.getName());
        ArrayList<File> arrayList = (ArrayList<File>)hashtable.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<File>();
            arrayList.add(file);
            hashtable.put(string, arrayList);
        } else if (arrayList.indexOf(file) == -1) {
            arrayList.add(file);
        }
    }

    protected static void removeFromTable(File file, Hashtable hashtable) {
        String string = Cache.parseKey(file.getName());
        ArrayList arrayList = (ArrayList)hashtable.get(string);
        if (arrayList != null) {
            int n = arrayList.indexOf(file);
            if (n != -1) {
                arrayList.remove(n);
            }
            if (arrayList.size() == 0) {
                hashtable.remove(string);
            }
        }
    }

    protected static boolean updateTable(File file, Hashtable hashtable, final String string) {
        boolean bl = false;
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(Cache.INDEX_FILE_EXT) && file.getName().startsWith(string);
            }
        });
        int n = 0;
        while (n < fileArray.length) {
            ArrayList<File> arrayList = (ArrayList<File>)hashtable.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<File>();
                arrayList.add(fileArray[n]);
                hashtable.put(string, arrayList);
                bl = true;
            } else if (arrayList.indexOf(fileArray[n]) == -1) {
                arrayList.add(fileArray[n]);
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    protected static void createTable(File file, Hashtable hashtable) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(Cache.INDEX_FILE_EXT);
            }
        });
        int n = 0;
        while (n < fileArray.length) {
            String string = Cache.parseKey(fileArray[n].getName());
            ArrayList<File> arrayList = (ArrayList<File>)hashtable.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<File>();
                arrayList.add(fileArray[n]);
                hashtable.put(string, arrayList);
            } else {
                arrayList.add(fileArray[n]);
            }
            ++n;
        }
    }

    static {
        cachingDisabled = false;
        random = new Random();
        cleanupThread = null;
        KB = "{0} KB";
        MB = "{0} MB";
        BYTES = "{0} bytes";
        UNLIMITED = "unlimited";
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                long l;
                MessageFormat messageFormat;
                long l2;
                String string2 = System.getProperty(Cache.DISABLED_PROP, "false");
                cachingDisabled = string2.equalsIgnoreCase("true");
                if (cachingDisabled) {
                    Cache.message(ResourceHandler.getMessage("cache.disabled"), null);
                    return null;
                }
                string2 = System.getProperty(Cache.SIZE_PROP, "50m");
                string2.trim();
                if (string2.endsWith("M") || string2.endsWith("m")) {
                    l2 = 0x100000L;
                    string2 = string2.substring(0, string2.length() - 1);
                    messageFormat = new MessageFormat(MB);
                } else if (string2.endsWith("K") || string2.endsWith("k")) {
                    l2 = 1024L;
                    string2 = string2.substring(0, string2.length() - 1);
                    messageFormat = new MessageFormat(KB);
                } else {
                    l2 = 1L;
                    messageFormat = new MessageFormat(BYTES);
                }
                try {
                    l = Long.valueOf(string2);
                    maxSize = l2 * l;
                }
                catch (NumberFormatException numberFormatException) {
                    l = 50L;
                    maxSize = 0x3200000L;
                    messageFormat = new MessageFormat(MB);
                }
                if (l > 0L) {
                    string = messageFormat.format(new Object[]{new Long(l)});
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup.getParent() != null) {
                        threadGroup = threadGroup.getParent();
                    }
                    if (maxSize >= 0x500000L) {
                        threadThresholdSize = maxSize - 0x100000L;
                        deleteThresholdSize = maxSize - 0x200000L;
                        cleanupThread = new CleanupThread(threadGroup, 60000L);
                        cleanupThread.start();
                    } else {
                        cachingDisabled = true;
                        Cache.message(ResourceHandler.getMessage("cache.minSize"), new Object[]{string});
                        string = null;
                    }
                } else {
                    string = UNLIMITED;
                }
                if (string != null) {
                    Cache.message(ResourceHandler.getMessage("cache.enabled"), null);
                    Cache.message(ResourceHandler.getMessage("cache.location"), new Object[]{UserProfile.getCommonCacheDir()});
                    Cache.message(ResourceHandler.getMessage("cache.maxSize"), new Object[]{string});
                }
                return null;
            }
        });
    }

    protected static class CacheIOAction
    implements PrivilegedExceptionAction {
        protected CacheIOAction() {
        }

        public Object run() throws IOException {
            return null;
        }
    }
}

