/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Locale
implements Serializable,
Cloneable {
    public static final Locale ENGLISH = new Locale("en", "");
    public static final Locale FRENCH = new Locale("fr", "");
    public static final Locale GERMAN = new Locale("de", "");
    public static final Locale ITALIAN = new Locale("it", "");
    public static final Locale JAPANESE = new Locale("ja", "");
    public static final Locale KOREAN = new Locale("ko", "");
    public static final Locale CHINESE = new Locale("zh", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale("zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = new Locale("zh", "TW");
    public static final Locale FRANCE = new Locale("fr", "FR");
    public static final Locale GERMANY = new Locale("de", "DE");
    public static final Locale ITALY = new Locale("it", "IT");
    public static final Locale JAPAN = new Locale("ja", "JP");
    public static final Locale KOREA = new Locale("ko", "KR");
    public static final Locale CHINA;
    public static final Locale PRC;
    public static final Locale TAIWAN;
    public static final Locale UK;
    public static final Locale US;
    public static final Locale CANADA;
    public static final Locale CANADA_FRENCH;
    static final long serialVersionUID = 9149081749638150636L;
    private String language;
    private String country;
    private String variant;
    private int hashcode;
    private static Locale defaultLocale;

    private String convertLanguage(String language) {
        if (language.equals("")) {
            return language;
        }
        int index = "iw,in,ji".indexOf(language = language.toLowerCase());
        if (index != -1) {
            return "he,id,yi".substring(index, index + 2);
        }
        return language;
    }

    public Locale(String language, String country, String variant) {
        this.language = this.convertLanguage(language);
        this.country = country.toUpperCase();
        this.variant = variant.toUpperCase();
        this.hashcode = this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
    }

    public Locale(String language, String country) {
        this(language, country, "");
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    public static void setDefault(Locale newLocale) {
        defaultLocale = newLocale;
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{ENGLISH, FRENCH, GERMAN, new Locale("ga", "")};
    }

    public static String[] getISOCountries() {
        return new String[]{"AF", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ", "BM", "BT", "BO", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN", "CX", "CC", "CO", "KM", "CG", "CK", "CR", "CI", "HR", "CU", "CY", "CZ", "DK", "DJ", "DM", "DO", "TP", "EC", "EG", "SV", "GQ", "ER", "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "FX", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GN", "GW", "GY", "HT", "HM", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IL", "IT", "JM", "JP", "JO", "KZ", "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT", "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "AN", "NC", "NZ", "NI", "NE", "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW", "KN", "LC", "VC", "WS", "SM", "ST", "SA", "SN", "SC", "SL", "SG", "SK", "SI", "SB", "SO", "ZA", "GS", "ES", "LK", "SH", "PM", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC", "TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VA", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "YU", "ZR", "ZM", "ZW"};
    }

    public static String[] getISOLanguages() {
        return new String[]{"aa", "ab", "af", "am", "ar", "as", "ay", "az", "ba", "be", "bg", "bh", "bi", "bn", "bo", "br", "ca", "co", "cs", "cy", "da", "de", "dz", "el", "en", "eo", "es", "et", "eu", "fa", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "ha", "iw", "he", "hi", "hr", "hu", "hy", "ia", "in", "id", "ie", "ik", "is", "it", "iu", "ja", "jw", "ka", "kk", "kl", "km", "kn", "ko", "ks", "ku", "ky", "la", "ln", "lo", "lt", "lv", "mg", "mi", "mk", "ml", "mn", "mo", "mr", "ms", "mt", "my", "na", "ne", "nl", "no", "oc", "om", "or", "pa", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sd", "sg", "sh", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ug", "uk", "ur", "uz", "vi", "vo", "wo", "xh", "ji", "yi", "yo", "za", "zh", "zu"};
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public final String toString() {
        StringBuffer result = new StringBuffer(this.language);
        String underscore = "";
        if (this.language.length() != 0) {
            underscore = "_";
        }
        if (this.country.length() != 0) {
            result.append(underscore);
            result.append(this.country);
            underscore = "_";
        }
        if (this.variant.length() != 0) {
            result.append(underscore);
            result.append(this.variant);
        }
        return result.toString();
    }

    public String getISO3Language() throws MissingResourceException {
        int index = "aa,ab,af,am,ar,as,ay,az,ba,be,bg,bh,bi,bn,bo,br,ca,co,cs,cy,da,de,dz,el,en,eo,es,et,eu,fa,fi,fj,fo,fr,fy,ga,gd,gl,gn,gu,gv,ha,hi,hr,hu,hy,ia,ie,ik,id,is,it,iu,he,ja,yi,jw,ka,kk,kl,km,kn,ko,ks,ku,kw,ky,la,lb,ln,lo,lt,lv,mg,mi,mk,ml,mn,mo,mr,ms,mt,my,na,ne,nl,no,oc,om,or,pa,pl,ps,pt,qu,rm,rn,ro,ru,rw,sa,sd,se,sg,sh,si,sk,sl,sm,sn,so,sq,sr,ss,st,su,sv,sw,ta,te,tg,th,ti,tk,tl,tn,to,tr,ts,tt,tw,ug,uk,ur,uz,vi,vo,wo,xh,yo,za,zh,zu,".indexOf(this.language + ",");
        if (index == -1 || this.language.length() != 2) {
            throw new MissingResourceException("Can't find ISO3 language for " + this.language, "java.util.Locale", this.language);
        }
        return "aarabkaframharaasmaymazebakbelbulbihbisbenbodbrecatcoscescymdandeudzoellengepospaesteusfasfinfijfaofrafrygaigdhglggrngujmaxhauhinhrvhunhyeinaileipkindislitaikuhebjpnyidjawkatkazkalkhmkankorkaskurcorkirlatltzlinlaolitlavmlgmrimkdmalmonmolmarmsamltmyanaunepnldnorociormoripanpolpusporquerohrunronruskinsansndsmisagsrpsinslkslvsmosnasomsqisrpsswsotsunsweswatamteltgkthatirtuktgltsntonturtsotattwiuigukrurduzbvievolwolxhoyorzhazhozul".substring(index, index + 3);
    }

    public String getISO3Country() throws MissingResourceException {
        int index = "AF,AL,DZ,AS,AD,AO,AI,AQ,AG,AR,AM,AW,AU,AT,AZ,BS,BH,BD,BB,BY,BE,BZ,BJ,BM,BT,BO,BA,BW,BV,BR,IO,BN,BG,BF,BI,KH,CM,CA,CV,KY,CF,TD,CL,CN,CX,CC,CO,KM,CG,CD,CK,CR,CI,HR,CU,CY,CZ,DK,DJ,DM,DO,TP,EC,EG,SV,GQ,ER,EE,ET,FK,FO,FJ,FI,FR,FX,GF,PF,TF,GA,GM,GE,DE,GH,GI,GR,GL,GD,GP,GU,GT,GN,GW,GY,HT,HM,VA,HN,HK,HU,IS,IN,ID,IR,IQ,IE,IL,IT,JM,JP,JO,KZ,KE,KI,KP,KR,KW,KG,LA,LV,LB,LS,LR,LY,LI,LT,LU,MO,MK,MG,MW,MY,MV,ML,MT,MH,MQ,MR,MU,YT,MX,FM,MD,MC,MN,MS,MA,MZ,MM,NA,NR,NP,NL,AN,NC,NZ,NI,NE,NG,NU,NF,MP,NO,OM,PK,PW,PA,PG,PY,PE,PH,PN,PL,PT,PR,QA,RE,RO,RU,RW,KN,LC,VC,WS,SM,ST,SA,SN,SC,SL,SG,SK,SI,SB,SO,ZA,GS,ES,LK,SH,PM,SD,SR,SJ,SZ,SE,CH,SY,TW,TJ,TZ,TH,TG,TK,TO,TT,TN,TR,TM,TC,TV,UG,UA,AE,GB,US,UM,UY,UZ,VU,VE,VN,VG,VI,WF,EH,YE,YU,ZM,ZW,".indexOf(this.country + ",");
        if (index == -1 || this.language.length() != 2) {
            throw new MissingResourceException("Can't find ISO3 country for " + this.country, "java.util.Locale", this.country);
        }
        return "AFGALBDZAASMANDAGOAIAATAATGARGARMABWAUSAUTAZEBHSBHRBGDBRBBLRBELBLZBENBMUBTNBOLBIHBWABVTBRAIOTBRNBGRBFABDIKHMCMRCANCPVCYMCAFTCDCHLCHNCXRCCKCOLCOMCOGCODCOKCRICIVHRVCUBCYPCZEDNKDJIDMADOMTMPECUEGYSLVGNQERIESTETHFLKFROFJIFINFRAFXXGUFPYFATFGABGMBGEODEUGHAGIBGRCGRLGRDGLPGUMGTMGINGNBGUYHTIHMDVATHNDHKGHUNISLINDIDNIRNIRQIRLISRITAJAMJPNJORKAZKENKIRPRKKORKWTKGZLAOLVALBNLSOLBRLBYLIELTULUXMACMKDMDGMWIMYSMDVMLIMLTMHLMTQMRTMUSMYTMEXFSMMDAMCOMNGMSRMARMOZMMRNAMNRUNPLNLDANTNCLNZLNICNERNGANIUNFKMNPNOROMNPAKPLWPANPNGPRYPERPHLPCNPOLPRTPRIQATREUROMRUSRWAKNALCAVCTWSMSMRSTPSAUSENSYCSLESGPSVKSVNSLBSOMZAFSGSESPLKASHNSPMSDNSURSJMSWZSWECHESYRTWNTJKTZATHATGOTKLTONTTOTUNTURTKMTCATUVUGAUKRAREGBRUSAUMIURYUZBVUTVENVNMVGBVIRWLFESHYEMYUGZMBZWE".substring(index, index + 3);
    }

    public String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("gnu.java.locale.iso639", locale);
            return bundle.getString(this.language);
        }
        catch (MissingResourceException ex) {
            return this.language;
        }
    }

    public String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("gnu.java.locale.iso3166", locale);
            return bundle.getString(this.country);
        }
        catch (MissingResourceException ex) {
            return this.country;
        }
    }

    public String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        return this.variant;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        StringBuffer result = new StringBuffer();
        int count = 0;
        String[] delimiters = new String[]{"", " (", ","};
        if (this.language.length() != 0) {
            result.append(delimiters[count++]);
            result.append(this.getDisplayLanguage(locale));
        }
        if (this.country.length() != 0) {
            result.append(delimiters[count++]);
            result.append(this.getDisplayCountry(locale));
        }
        if (this.variant.length() != 0) {
            result.append(delimiters[count++]);
            result.append(this.getDisplayVariant(locale));
        }
        if (count > 1) {
            result.append(")");
        }
        return result.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public synchronized int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Locale)) {
            return false;
        }
        Locale l = (Locale)obj;
        return this.language.equals(l.language) && this.country.equals(l.country) && this.variant.equals(l.variant);
    }

    private synchronized void writeObject(ObjectOutputStream output) throws IOException {
        int tmpHashcode = this.hashcode;
        this.hashcode = -1;
        output.defaultWriteObject();
        this.hashcode = tmpHashcode;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.hashcode = this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
    }

    static {
        PRC = CHINA = SIMPLIFIED_CHINESE;
        TAIWAN = TRADITIONAL_CHINESE;
        UK = new Locale("en", "GB");
        US = new Locale("en", "US");
        CANADA = new Locale("en", "CA");
        CANADA_FRENCH = new Locale("fr", "CA");
        defaultLocale = new Locale(System.getProperty("user.language", ""), System.getProperty("user.region", ""), System.getProperty("user.variant", ""));
    }
}

