/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.gcj.runtime.VMClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;

public abstract class ClassLoader {
    private ClassLoader parent;
    private HashMap definedPackages;
    static final Permission protectionDomainPermission = new RuntimePermission("getProtectionDomain");
    static ProtectionDomain unknownProtectionDomain;
    static ProtectionDomain defaultProtectionDomain;

    private /* synthetic */ void finit$() {
        this.definedPackages = new HashMap();
    }

    public final ClassLoader getParent() {
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        return VMClassLoader.instance;
    }

    protected ClassLoader() {
        this(null);
    }

    protected ClassLoader(ClassLoader parent) {
        this.finit$();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.parent = parent;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean link) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            try {
                if (this.parent != null) {
                    return this.parent.loadClass(name, link);
                }
                c = ((ClassLoader)VMClassLoader.instance).findClass(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (c == null) {
            c = this.findClass(name);
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (link) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    protected final Class defineClass(byte[] data, int off, int len) throws ClassFormatError {
        return this.defineClass(null, data, off, len, defaultProtectionDomain);
    }

    protected final Class defineClass(String name, byte[] data, int off, int len) throws ClassFormatError {
        return this.defineClass(name, data, off, len, defaultProtectionDomain);
    }

    protected final synchronized Class defineClass(String name, byte[] data, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        if (data == null || data.length < off + len || off < 0 || len < 0) {
            throw new ClassFormatError("arguments to defineClass are meaningless");
        }
        if (name != null && this.findLoadedClass(name) != null) {
            throw new LinkageError("class " + name + " already loaded");
        }
        if (protectionDomain == null) {
            protectionDomain = defaultProtectionDomain;
        }
        try {
            return this.defineClass0(name, data, off, len, protectionDomain);
        }
        catch (LinkageError x) {
            throw x;
        }
        catch (VirtualMachineError x) {
            throw x;
        }
        catch (Throwable x) {
            throw new InternalError("Unexpected exception while defining class " + name + ": " + x.toString());
        }
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5) throws ClassFormatError;

    protected final void resolveClass(Class clazz) {
        ClassLoader.resolveClass0(clazz);
    }

    static void resolveClass0(Class clazz) {
        Class clazz2 = clazz;
        synchronized (clazz2) {
            try {
                try {
                    ClassLoader.linkClass0(clazz);
                }
                catch (Throwable x) {
                    ClassLoader.markClassErrorState0(clazz);
                    if (x instanceof Error) {
                        throw (Error)x;
                    }
                    throw new InternalError("unexpected exception during linking: " + x);
                }
                Object var2_3 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
        }
    }

    private static native void linkClass0(Class var0);

    private static native void markClassErrorState0(Class var0);

    protected Package definePackage(String name, String specTitle, String specVendor, String specVersion, String implTitle, String implVendor, String implVersion, URL sealed) {
        if (this.getPackage(name) != null) {
            throw new IllegalArgumentException("Package " + name + " already defined");
        }
        Package p = new Package(name, specTitle, specVendor, specVersion, implTitle, implVendor, implVersion, sealed);
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            try {
                this.definedPackages.put(name, p);
            }
            finally {
                Object var11_11 = null;
            }
            Package package_ = p;
            return package_;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Package getPackage(String name) {
        Package p = this.parent == null ? null : this.parent.getPackage(name);
        if (p != null) return p;
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            try {
                p = (Package)this.definedPackages.get(name);
                return p;
            }
            finally {
                Object var4_4 = null;
            }
        }
    }

    protected Package[] getPackages() {
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            Object[] allPackages;
            Object[] packages;
            try {
                packages = new Package[this.definedPackages.size()];
                this.definedPackages.values().toArray(packages);
            }
            finally {
                Object var4_3 = null;
            }
            if (this.parent != null) {
                Package[] parentPackages = this.parent.getPackages();
                allPackages = new Package[parentPackages.length + packages.length];
                System.arraycopy(parentPackages, 0, allPackages, 0, parentPackages.length);
                System.arraycopy(packages, 0, allPackages, parentPackages.length, packages.length);
            } else {
                allPackages = packages;
            }
            Object[] objectArray = allPackages;
            return objectArray;
        }
    }

    protected final Class findSystemClass(String name) throws ClassNotFoundException {
        return VMClassLoader.instance.loadClass(name);
    }

    protected final void setSigners(Class claz, Object[] signers) {
    }

    protected final native Class findLoadedClass(String var1);

    public static InputStream getSystemResourceAsStream(String name) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(name);
    }

    public static URL getSystemResource(String name) {
        return ClassLoader.getSystemClassLoader().getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL res = this.getResource(name);
            if (res == null) {
                return null;
            }
            return res.openStream();
        }
        catch (IOException x) {
            return null;
        }
    }

    public URL getResource(String name) {
        URL result = null;
        ClassLoader delegate = this.parent;
        if (delegate == null) {
            delegate = ClassLoader.getSystemClassLoader();
        }
        if (this != delegate) {
            result = delegate.getResource(name);
        }
        if (result != null) {
            return result;
        }
        return this.findResource(name);
    }

    protected URL findResource(String name) {
        return null;
    }

    public final Enumeration getResources(String name) throws IOException {
        Enumeration result = null;
        ClassLoader delegate = this.parent;
        if (delegate == null) {
            delegate = ClassLoader.getSystemClassLoader();
        }
        if (this != delegate) {
            result = delegate.getResources(name);
        }
        if (result != null) {
            return result;
        }
        return this.findResources(name);
    }

    protected Enumeration findResources(String name) throws IOException {
        return null;
    }

    static {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        unknownProtectionDomain = new ProtectionDomain(null, permissions);
        CodeSource cs = new CodeSource(null, null);
        defaultProtectionDomain = new ProtectionDomain(cs, Policy.getPolicy().getPermissions(cs));
    }
}

