/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServicesListener;
import java.io.Serializable;

public class BeanContextChildSupport
implements BeanContextChild,
BeanContextServicesListener,
Serializable {
    public BeanContextChild beanContextChildPeer;
    protected transient BeanContext beanContext;
    protected transient boolean rejectedSetBCOnce;
    protected PropertyChangeSupport pcSupport;
    protected VetoableChangeSupport vcSupport;

    public BeanContextChildSupport() {
        this(null);
    }

    public BeanContextChildSupport(BeanContextChild peer) {
        if (peer == null) {
            peer = this;
        }
        this.beanContextChildPeer = peer;
        this.pcSupport = new PropertyChangeSupport(peer);
        this.vcSupport = new VetoableChangeSupport(peer);
    }

    public void setBeanContext(BeanContext newBeanContext) throws PropertyVetoException {
        BeanContextChild beanContextChild = this.beanContextChildPeer;
        synchronized (beanContextChild) {
            try {
                if (newBeanContext == this.beanContext) {
                    Object var3_3 = null;
                    return;
                }
                if (!this.rejectedSetBCOnce) {
                    if (!this.validatePendingSetBeanContext(newBeanContext)) {
                        this.rejectedSetBCOnce = true;
                        throw new PropertyVetoException("validatePendingSetBeanContext() rejected change", new PropertyChangeEvent(this.beanContextChildPeer, "beanContext", this.beanContext, newBeanContext));
                    }
                    try {
                        this.fireVetoableChange("beanContext", this.beanContext, newBeanContext);
                    }
                    catch (PropertyVetoException e) {
                        this.rejectedSetBCOnce = true;
                        throw e;
                    }
                }
                this.releaseBeanContextResources();
                this.beanContext = newBeanContext;
                this.rejectedSetBCOnce = false;
                this.firePropertyChange("beanContext", this.beanContext, newBeanContext);
                this.initializeBeanContextResources();
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
            Object var3_5 = null;
        }
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public BeanContextChild getBeanContextChildPeer() {
        return this.beanContextChildPeer;
    }

    public boolean isDelegated() {
        return this.beanContextChildPeer == this;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vcSupport.addVetoableChangeListener(propertyName, listener);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vcSupport.removeVetoableChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldVal, Object newVal) {
        this.pcSupport.firePropertyChange(propertyName, oldVal, newVal);
    }

    public void fireVetoableChange(String propertyName, Object oldVal, Object newVal) throws PropertyVetoException {
        this.vcSupport.fireVetoableChange(propertyName, oldVal, newVal);
    }

    public void serviceRevoked(BeanContextServiceRevokedEvent event) {
    }

    public void serviceAvailable(BeanContextServiceAvailableEvent event) {
    }

    public boolean validatePendingSetBeanContext(BeanContext newBeanContext) {
        return true;
    }

    protected void releaseBeanContextResources() {
    }

    protected void initializeBeanContextResources() {
    }
}

