.TH INITEX 1 "27 December 1992"
.\"=====================================================================
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP\" for troff
.el .ds OX TeX\" for nroff
.\" the same but obliqued
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.\"=====================================================================
.SH NAME
initex \- initial TeX for making format (.fmt) files
.SH DESCRIPTION
.B initex
is a special version of the \*(TX program that has
no preloaded macro packages, but is capable of
converting a macro package into a special
preformatted binary file, called a
.I format
.RI ( .fmt )
file.  That format file can subsequently be read
at high speed by
.BR virtex .
.PP
Major macro packages may require \*(TX to process
many thousands of lines of macros, and open and
read scores of font files, all of which would
contribute to a sizable startup overhead if the
job had to be done every time \*(TX was run.
.B initex
allows \*(TX to do the job once, and then save the
results in a binary format file that can be later
loaded more rapidly by
.BR virtex .
.PP
.B initex
is normally required only at the time \*(TX is
installed, or whenever major macro packages are
updated.  Thus, it will be rare for anyone but
system installers to invoke it.  Nevertheless, it
is just a normal program without special
privileges, so ordinary users can use it to
prepare a private format file.
.PP
Here is how you can ask
.B initex
to prepare format files for several major
packages:
.PP
For plain
.BR tex :
.RS
.nf
.I "initex 'plain \\\\dump'"
.I "mv plain.fmt tex.fmt"
.fi
The single quotes are necessary to protect
the backslash from interpretation as a Unix shell
escape character.
.RE
.PP
For
.BR amstex :
.RS
.nf
.I "initex '&tex amstex \\\\dump'"
.fi
The single quotes around the first argument
protect the ampersand from interpretation as a
Unix shell background request.
.RE
.PP
For
.BR etex :
.RS
.nf
.I "initex '&tex eplain \\\\dump'"
.I "mv eplain.fmt etex.fmt"
.fi
.RE
.PP
For
.BR lamstex :
.RS
.nf
.I "initex '&tex amstexl \\\\input lamstex \\\\dump'"
.I "mv amstexl.fmt lamstex.fmt"
.fi
.RE
.PP
For
.BR latex :
.RS
.nf
.I "initex 'lplain \\\\dump'"
.I "mv lplain.fmt latex.fmt"
.fi
.RE
.PP
For
.BR slitex :
.RS
.nf
.I "initex 'splain \\\\dump'"
.I "mv splain.fmt slitex.fmt"
.fi
.RE
.PP
For
.BR texinfo :
.RS
.nf
.I "initex '&tex texinfo @dump'"
.fi
The last argument is different from the previous
examples because
.B texinfo
redefines the \*(TX escape character from
backslash to at-sign.  As for
.BR amstex ,
the file
.I tex.fmt
must already be available.
.RE
.PP
Note that several of these require that the format file for plain
\*(TX be available, since the first argument word
.I &tex
asks for the loading of the file
.IR tex.fmt .
.PP
It does not matter whether the command-line arguments are passed as a
single argument, or as separate arguments, since \*(TX reconstructs
the command line anyway.
.\"=====================================================================
.SH "SEE ALSO"
.BR amslatex (1),
.BR amstex (1),
.BR lamstex (1),
.BR latex (1),
.BR slitex (1),
.BR tex (1),
.BR virtex (1).
