;;; $Id: emacspeak-setup.def,v 6.0 1997/05/01 18:06:27 raman Exp $
;;; $Author: raman $ 
;;; Description:  File for setting up and starting Emacspeak
;;; Keywords: Emacspeak, Setup, Spoken Output
;;{{{  LCD Archive entry: 
;;; LCD Archive Entry:
;;; emacspeak| T. V. Raman |raman@crl.dec.com 
;;; A speech interface to Emacs |
;;; $date: $ |
;;;  $Revision: 6.0 $ | 
;;; Location undetermined
;;;

;;}}}
;;{{{  Copyright:

;;; Copyright (c) 1994, 1995 by Digital Equipment Corporation.
;;; All Rights Reserved. 
;;;
;;; This file is not part of GNU Emacs, but the same permissions apply.
;;;
;;; GNU Emacs is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; GNU Emacs is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;}}}

(require 'cl)
(eval-when (compile)
(require 'emacspeak-speak))
(defvar emacspeak-dir
  (expand-file-name  "/usr/share/emacs/site-lisp/emacspeak")
  "Directory where emacspeak is installed. ")

  (defvar emacspeak-sounds-directory
(concat emacspeak-dir
          "/sounds/")

            "Directory containing auditory icons for Emacspeak.")

(defvar emacspeak-play-program
  (or (getenv "PLAY_PROGRAM")
(concat emacspeak-dir "/play"))
"Name of executable that plays sound files. ")

(unless (featurep 'emacspeak)
(setq load-path
      (cons emacspeak-dir 
                              load-path )))

(load-library "emacspeak")
;;; The next 3    lines are to suppress warnings from the byte-compiler
  (eval-when (compile)
    (require 'dtk-speak)
(require 'voice-lock)
(require 'emacspeak)
)

(defvar dtk-default-speech-rate 225
"Default speech rate at which Dectalk is started. ")

(add-hook 'dtk-startup-hook 
(function (lambda () 
(dtk-set-rate dtk-default-speech-rate  t))))

(setq emacspeak-startup-hook nil )
;;; Use (add-hook 'emacspeak-startup-hook ...)
;;; to add your personal settings. 

(emacspeak)

                  ;;; turn on automatic voice locking for modes
 (mapcar
  (function (lambda (hook)
              (add-hook hook
                        (function (lambda ()
                                    (setq dtk-punctuation-mode "all")
(emacspeak-dtk-sync))))))
  (list 'c-mode-hook
 'lisp-mode-hook
 'emacs-lisp-mode-hook
'lisp-interaction-mode-hook
 'perl-mode-hook
 'text-mode-hook
 'tcl-mode-hook
 'dired-mode-hook))
