.TH PIC2GRAPH @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH NAME
pic2graph \- convert a PIC diagram into a cropped image
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" This documentation is released to the public domain.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY pic2graph
.OP \-unsafe
.OP \-format output-format
.OP \-eqn delimiters
.RI [ convert-arguments ]
.YS
.
.SY pic2graph
.B \-\-help
.YS
.
.SY pic2graph
.B \-v
.SY pic2graph
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
.I pic2graph
reads a
.IR @g@pic (@MAN1EXT@)
program from the standard input and writes an image file,
by default in Portable Network Graphics (PNG) format,
to the standard output.
.
It furthermore translates
.IR @g@eqn (@MAN1EXT@)
constructs, so it can be used for generating images of mathematical
formulae.
.
.
.PP
The input PIC code should
.I not
be wrapped with the
.B \&.PS
and
.B \&.PE
macros that normally guard it within
.IR groff (@MAN1EXT@)
documents.
.
.
.\" FIXME: How old?  This text hasn't been touched since 2008 at latest.
.\" Older versions of
.\" .I \%convert
.\" will produce a black-on-white graphic; newer ones may produce a
.\" black-on-transparent graphic.
.
.PP
Arguments not recognized by
.I pic2graph
are passed to the ImageMagick or GraphicsMagick program
.IR \%convert (1).
.
.
By specifying these, you can give your image a border,
.\" Transparent backgrounds are the default in 2018.
.\" force the background transparent,
set the image's pixel density,
or perform other useful transformations.
.
.
.PP
The output image is clipped using
.IR \%convert 's
.B \-trim
option to the smallest possible bounding box that contains all the black
pixels.
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
.TP
.BI "\-eqn " delimiters
Use
.I delimiters
as the opening and closing
characters that delimit
.I @g@eqn
directives;
the default is \(lq$$\(rq.
.
The option argument
.I delimiters
should be a two-character string,
but an empty string (\(dq\(dq) is accepted as a directive to disable
.I @g@eqn
processing.
.
.
.TP
.BI "\-format " output-format
Write the image in
.IR output-format ,
which must be understood by
.IR \%convert ;
the default is PNG.
.
.
.TP
.B \-\-help
Display a usage message and exit.
.
.
.TP
.B \-unsafe
Run
.I groff
in
.I unsafe
mode, enabling the PIC command
.B sh
to execute arbitrary Unix shell commands.
.
The
.I groff
default is to forbid this.
.
.
.TP
.B \-v
.TQ
.B \-\-version
Display version information and exit.
.
.
.\" ====================================================================
.SH ENVIRONMENT
.\" ====================================================================
.
.TP
.I \%GROFF_TMPDIR
.TQ
.I \%TMPDIR
.TQ
.I TMP
.TQ
.I TEMP
These environment variables are searched in the given order to determine
the directory where temporary files will be created.
.
If none are set,
.I /tmp
is used.
.
.
.\" ====================================================================
.SH AUTHORS
.\" ====================================================================
.
.I pic2graph
was written by
.MT esr@\:thyrsus.com
Eric S.\& Raymond
.ME ,
based on a recipe by W.\& Richard Stevens.
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
W.\& Richard Stevens,
.UR http://\:www.kohala.com/\:start/\:troff/\:pic2html.html
.I Turning PIC into HTML
.UE
.
.
.PP
.IR eqn2graph (@MAN1EXT@),
.IR grap2graph (@MAN1EXT@),
.IR @g@pic (@MAN1EXT@),
.IR @g@eqn (@MAN1EXT@),
.IR groff (@MAN1EXT@),
.IR \%convert (1)
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
