var browserTests = [
["foo[]bar",
    [["createlink","http://www.google.com/"]],
    "foo[]bar",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<p>[foo</p> <p>bar]</p>",
    [["createlink","http://www.google.com/"]],
    "<p><a href=\"http://www.google.com/\">[foo</a></p> <p><a href=\"http://www.google.com/\">bar]</a></p>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<span>[foo</span> <span>bar]</span>",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\"><span>[foo</span> <span>bar]</span></a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["createlink","http://www.google.com/"]],
    "<p><a href=\"http://www.google.com/\">[foo</a></p><p> <a href=\"http://www.google.com/\"><span>bar</span></a> </p><p><a href=\"http://www.google.com/\">baz]</a></p>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<p>[foo<p><br><p>bar]",
    [["createlink","http://www.google.com/"]],
    "<p><a href=\"http://www.google.com/\">[foo</a></p><p><a href=\"http://www.google.com/\"><br></a></p><p><a href=\"http://www.google.com/\">bar]</a></p>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<b>foo[]bar</b>",
    [["createlink","http://www.google.com/"]],
    "<b>foo[]bar</b>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<i>foo[]bar</i>",
    [["createlink","http://www.google.com/"]],
    "<i>foo[]bar</i>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<span>foo</span>{}<span>bar</span>",
    [["createlink","http://www.google.com/"]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<span>foo[</span><span>]bar</span>",
    [["createlink","http://www.google.com/"]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo[bar]baz",
    [["createlink","http://www.google.com/"]],
    "foo<a href=\"http://www.google.com/\">[bar]</a>baz",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo[bar<b>baz]qoz</b>quz",
    [["createlink","http://www.google.com/"]],
    "foo<a href=\"http://www.google.com/\">[bar</a><b><a href=\"http://www.google.com/\">baz]</a>qoz</b>quz",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo[bar<i>baz]qoz</i>quz",
    [["createlink","http://www.google.com/"]],
    "foo<a href=\"http://www.google.com/\">[bar</a><i><a href=\"http://www.google.com/\">baz]</a>qoz</i>quz",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["{<p><p> <p>foo</p>}",
    [["createlink","http://www.google.com/"]],
    "{<p></p><p> </p><p><a href=\"http://www.google.com/\">foo</a></p>}",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["createlink","http://www.google.com/"]],
    "<table><tbody><tr><td>foo</td><td>b<a href=\"http://www.google.com/\">[a]</a>r</td><td>baz</td></tr></tbody></table>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["createlink","http://www.google.com/"]],
    "<table><tbody><tr><td>foo</td>{<td><a href=\"http://www.google.com/\">bar</a></td>}<td>baz</td></tr></tbody></table>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["createlink","http://www.google.com/"]],
    "<table><tbody><tr>{<td><a href=\"http://www.google.com/\">foo</a></td><td><a href=\"http://www.google.com/\">bar</a></td>}<td>baz</td></tr></tbody></table>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["createlink","http://www.google.com/"]],
    "<table><tbody>{<tr><td><a href=\"http://www.google.com/\">foo</a></td><td><a href=\"http://www.google.com/\">bar</a></td><td><a href=\"http://www.google.com/\">baz</a></td></tr>}</tbody></table>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["createlink","http://www.google.com/"]],
    "<table>{<tbody><tr><td><a href=\"http://www.google.com/\">foo</a></td><td><a href=\"http://www.google.com/\">bar</a></td><td><a href=\"http://www.google.com/\">baz</a></td></tr></tbody>}</table>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["createlink","http://www.google.com/"]],
    "{<table><tbody><tr><td><a href=\"http://www.google.com/\">foo</a></td><td><a href=\"http://www.google.com/\">bar</a></td><td><a href=\"http://www.google.com/\">baz</a></td></tr></tbody></table>}",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a href=http://www.google.com/>foo[bar]baz</a>",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">foo[bar]baz</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a href=http://www.google.com/>foo[barbaz</a>}",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">foo[barbaz</a>}",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["{<a href=http://www.google.com/>foobar]baz</a>",
    [["createlink","http://www.google.com/"]],
    "{<a href=\"http://www.google.com/\">foobar]baz</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["{<a href=http://www.google.com/>foobarbaz</a>}",
    [["createlink","http://www.google.com/"]],
    "{<a href=\"http://www.google.com/\">foobarbaz}</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a href=http://www.google.com/>[foobarbaz]</a>",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">[foobarbaz]</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com/>[bar]</a>baz",
    [["createlink","http://www.google.com/"]],
    "foo<a href=\"http://www.google.com/\">[bar]</a>baz",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["[foo]<a href=http://www.google.com/>bar</a>baz",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">[foo]bar</a>baz",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com/>bar</a>[baz]",
    [["createlink","http://www.google.com/"]],
    "foo<a href=\"http://www.google.com/\">bar[baz]</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo[<a href=http://www.google.com/>bar</a>]baz",
    [["createlink","http://www.google.com/"]],
    "foo[<a href=\"http://www.google.com/\">bar</a>]baz",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo<a href=http://www.google.com/>[bar</a>baz]",
    [["createlink","http://www.google.com/"]],
    "foo<a href=\"http://www.google.com/\">[barbaz]</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com/>bar]</a>baz",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">[foobar]</a>baz",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["[foo<a href=http://www.google.com/>bar</a>baz]",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">[foobarbaz]</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl>foo[bar]baz</a>",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">foo[bar]baz</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl>foo[barbaz</a>}",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">foo[barbaz</a>}",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["{<a href=otherurl>foobar]baz</a>",
    [["createlink","http://www.google.com/"]],
    "{<a href=\"http://www.google.com/\">foobar]baz</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["{<a href=otherurl>foobarbaz</a>}",
    [["createlink","http://www.google.com/"]],
    "{<a href=\"http://www.google.com/\">foobarbaz}</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl>[foobarbaz]</a>",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">[foobarbaz]</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo<a href=otherurl>[bar]</a>baz",
    [["createlink","http://www.google.com/"]],
    "foo<a href=\"http://www.google.com/\">[bar]</a>baz",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo[<a href=otherurl>bar</a>]baz",
    [["createlink","http://www.google.com/"]],
    "foo[<a href=\"http://www.google.com/\">bar</a>]baz",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo<a href=otherurl>[bar</a>baz]",
    [["createlink","http://www.google.com/"]],
    "foo<a href=\"http://www.google.com/\">[barbaz]</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["[foo<a href=otherurl>bar]</a>baz",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">[foobar]</a>baz",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["[foo<a href=otherurl>bar</a>baz]",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\">[foobarbaz]</a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl><b>foo[bar]baz</b></a>",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\"><b>foo[bar]baz</b></a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl><b>foo[barbaz</b></a>}",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\"><b>foo[barbaz</b></a>}",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["{<a href=otherurl><b>foobar]baz</b></a>",
    [["createlink","http://www.google.com/"]],
    "{<a href=\"http://www.google.com/\"><b>foobar]baz</b></a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a href=otherurl><b>[foobarbaz]</b></a>",
    [["createlink","http://www.google.com/"]],
    "<a href=\"http://www.google.com/\"><b>[foobarbaz]</b></a>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a name=abc>foo[bar]baz</a>",
    [["createlink","http://www.google.com/"]],
    "<span name=\"abc\">foo<a href=\"http://www.google.com/\">[bar]</a>baz</span>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["<a name=abc><b>foo[bar]baz</b></a>",
    [["createlink","http://www.google.com/"]],
    "<span name=\"abc\"><b>foo<a href=\"http://www.google.com/\">[bar]</a>baz</b></span>",
    [true],
    {"createlink":[false,false,"",false,false,""]}],
["foo[bar]baz",
    [["createlink",""]],
    "foo[bar]baz",
    [false],
    {"createlink":[false,false,"",false,false,""]}]
]
