# Contributing to Node.js

* [Code of Conduct](#code-of-conduct)
* [Issues](#issues)
* [Pull Requests](#pull-requests)
* [Developer's Certificate of Origin 1.1](#developers-certificate-of-origin-11)

## [Code of Conduct](./doc/guides/contributing/coc.md)

The Node.js project has a
[Code of Conduct](https://github.com/nodejs/admin/blob/master/CODE_OF_CONDUCT.md)
to which all contributors must adhere.

See [details on our policy on Code of Conduct](./doc/guides/contributing/coc.md).

## [Issues](./doc/guides/contributing/issues.md)

* [How to Contribute in Issues](./doc/guides/contributing/issues.md#how-to-contribute-in-issues)
* [Asking for General Help](./doc/guides/contributing/issues.md#asking-for-general-help)
* [Discussing non-technical topics](./doc/guides/contributing/issues.md#discussing-non-technical-topics)
* [Submitting a Bug Report](./doc/guides/contributing/issues.md#submitting-a-bug-report)
* [Triaging a Bug Report](./doc/guides/contributing/issues.md#triaging-a-bug-report)
* [Resolving a Bug Report](./doc/guides/contributing/issues.md#resolving-a-bug-report)

## [Pull Requests](./doc/guides/contributing/pull-requests.md)

* [Dependencies](./doc/guides/contributing/pull-requests.md#dependencies)
* [Setting up your local environment](./doc/guides/contributing/pull-requests.md#setting-up-your-local-environment)
* [The Process of Making Changes](./doc/guides/contributing/pull-requests.md#the-process-of-making-changes)
* [Reviewing Pull Requests](./doc/guides/contributing/pull-requests.md#reviewing-pull-requests)
* [Notes](./doc/guides/contributing/pull-requests.md#notes)

<a id="developers-certificate-of-origin"></a>
## Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

* (a) The contribution was created in whole or in part by me and I
  have the right to submit it under the open source license
  indicated in the file; or

* (b) The contribution is based upon previous work that, to the best
  of my knowledge, is covered under an appropriate open source
  license and I have the right under that license to submit that
  work with modifications, whether created in whole or in part
  by me, under the same open source license (unless I am
  permitted to submit under a different license), as indicated
  in the file; or

* (c) The contribution was provided directly to me by some other
  person who certified (a), (b) or (c) and I have not modified
  it.

* (d) I understand and agree that this project and the contribution
  are public and that a record of the contribution (including all
  personal information I submit with it, including my sign-off) is
  maintained indefinitely and may be redistributed consistent with
  this project or the open source license(s) involved.
