/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.Bound;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class SameTermFilterOptimizer
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new SameTermFilterVisitor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BoundOptimizer
    extends QueryModelVisitorBase<RuntimeException> {
        private boolean inSP;
        private List<Boolean> innerJoins = new ArrayList<Boolean>();
        private List<Var> vars = new ArrayList<Var>();

        protected BoundOptimizer() {
        }

        @Override
        public void meet(Filter filter) {
            if (filter.getCondition() instanceof Bound) {
                Bound bound = (Bound)filter.getCondition();
                this.vars.add(bound.getArg());
                this.innerJoins.add(Boolean.FALSE);
                filter.getArg().visit(this);
                this.vars.remove(this.vars.size() - 1);
                if (this.innerJoins.remove(this.innerJoins.size() - 1).booleanValue()) {
                    filter.replaceWith(filter.getArg());
                }
            } else {
                filter.visitChildren(this);
            }
        }

        @Override
        public void meet(Join join) throws RuntimeException {
            join.visitChildren(this);
        }

        @Override
        public void meet(LeftJoin leftJoin) throws RuntimeException {
            leftJoin.getLeftArg().visit(this);
        }

        @Override
        public void meet(Union union) throws RuntimeException {
            List<Boolean> orig = this.innerJoins;
            this.innerJoins = new ArrayList<Boolean>(orig);
            ArrayList<Boolean> left = this.innerJoins;
            union.getLeftArg().visit(this);
            this.innerJoins = new ArrayList<Boolean>(orig);
            ArrayList<Boolean> right = this.innerJoins;
            union.getRightArg().visit(this);
            if (!((Object)left).equals(right)) {
                this.innerJoins = orig;
            }
        }

        @Override
        protected void meetBinaryTupleOperator(BinaryTupleOperator node) throws RuntimeException {
        }

        @Override
        protected void meetUnaryTupleOperator(UnaryTupleOperator node) throws RuntimeException {
        }

        @Override
        public void meet(StatementPattern sp) throws RuntimeException {
            this.inSP = true;
            super.meet(sp);
            this.inSP = false;
        }

        @Override
        public void meet(Var var) throws RuntimeException {
            if (this.inSP && this.vars.contains(var)) {
                this.innerJoins.set(this.vars.indexOf(var), Boolean.TRUE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VarBinder
    extends QueryModelVisitorBase<RuntimeException> {
        private String varName;
        private Value value;

        public VarBinder(String varName, Value value) {
            this.varName = varName;
            this.value = value;
        }

        @Override
        public void meet(Var var) {
            if (var.getName().equals(this.varName)) {
                var.setValue(this.value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VarRenamer
    extends QueryModelVisitorBase<RuntimeException> {
        private String oldName;
        private String newName;

        public VarRenamer(String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public void meet(Var var) {
            if (var.getName().equals(this.oldName)) {
                var.setName(this.newName);
            }
        }

        @Override
        public void meet(ProjectionElem projElem) throws RuntimeException {
            if (projElem.getSourceName().equals(this.oldName)) {
                projElem.setSourceName(this.newName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SameTermFilterVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected SameTermFilterVisitor() {
        }

        @Override
        public void meet(Filter filter) {
            super.meet(filter);
            if (filter.getCondition() instanceof SameTerm) {
                SameTerm sameTerm = (SameTerm)filter.getCondition();
                TupleExpr filterArg = filter.getArg();
                ValueExpr leftArg = sameTerm.getLeftArg();
                ValueExpr rightArg = sameTerm.getRightArg();
                Set<String> bindingNames = filterArg.getBindingNames();
                if (leftArg instanceof Var && !bindingNames.contains(((Var)leftArg).getName()) || rightArg instanceof Var && !bindingNames.contains(((Var)rightArg).getName())) {
                    filter.replaceWith(new EmptySet());
                    return;
                }
                if (leftArg instanceof Var && rightArg instanceof Var) {
                    this.renameVar((Var)rightArg, (Var)leftArg, filter);
                } else if (leftArg instanceof Var && rightArg instanceof ValueConstant) {
                    this.bindVar((Var)leftArg, (ValueConstant)rightArg, filter);
                } else if (rightArg instanceof Var && leftArg instanceof ValueConstant) {
                    this.bindVar((Var)rightArg, (ValueConstant)leftArg, filter);
                }
            }
        }

        private void renameVar(Var oldVar, Var newVar, Filter filter) {
            filter.getArg().visit(new VarRenamer(oldVar.getName(), newVar.getName()));
            Extension extension = new Extension(filter.getArg());
            extension.addElement(new ExtensionElem(new Var(newVar.getName()), oldVar.getName()));
            filter.replaceWith(extension);
        }

        private void bindVar(Var var, ValueConstant valueConstant, Filter filter) {
            filter.getArg().visit(new VarBinder(var.getName(), valueConstant.getValue()));
            filter.setCondition(new Bound(var));
            filter.visit(new BoundOptimizer());
        }
    }
}

