/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TOUCH_EVENTS)

#include "JSTouch.h"

#include "EventTarget.h"
#include "JSEventTarget.h"
#include "Touch.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSTouch);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTouchTableValues[10] =
{
    { "clientX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchClientX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "clientY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchClientY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "screenX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchScreenX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "screenY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchScreenY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "pageX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchPageX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "pageY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchPageY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "target", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchTarget), (intptr_t)0 THUNK_GENERATOR(0) },
    { "identifier", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchIdentifier), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTouchTable = { 32, 31, JSTouchTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTouchConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTouchConstructorTable = { 1, 0, JSTouchConstructorTableValues, 0 };
class JSTouchConstructor : public DOMConstructorObject {
public:
    JSTouchConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSTouchConstructor::s_info = { "TouchConstructor", &DOMConstructorObject::s_info, &JSTouchConstructorTable, 0 };

JSTouchConstructor::JSTouchConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSTouchPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSTouchConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTouchConstructor, JSDOMWrapper>(exec, &JSTouchConstructorTable, this, propertyName, slot);
}

bool JSTouchConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTouchConstructor, JSDOMWrapper>(exec, &JSTouchConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTouchPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTouchPrototypeTable = { 1, 0, JSTouchPrototypeTableValues, 0 };
const ClassInfo JSTouchPrototype::s_info = { "TouchPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSTouchPrototypeTable, 0 };

JSObject* JSTouchPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTouch>(exec, globalObject);
}

const ClassInfo JSTouch::s_info = { "Touch", &JSDOMWrapper::s_info, &JSTouchTable, 0 };

JSTouch::JSTouch(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Touch> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSTouch::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSTouchPrototype(exec->globalData(), globalObject, JSTouchPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSTouch::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTouch, Base>(exec, &JSTouchTable, this, propertyName, slot);
}

bool JSTouch::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTouch, Base>(exec, &JSTouchTable, this, propertyName, descriptor);
}

JSValue jsTouchClientX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTouch* castedThis = static_cast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* imp = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(imp->clientX());
    return result;
}


JSValue jsTouchClientY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTouch* castedThis = static_cast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* imp = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(imp->clientY());
    return result;
}


JSValue jsTouchScreenX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTouch* castedThis = static_cast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* imp = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(imp->screenX());
    return result;
}


JSValue jsTouchScreenY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTouch* castedThis = static_cast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* imp = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(imp->screenY());
    return result;
}


JSValue jsTouchPageX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTouch* castedThis = static_cast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* imp = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(imp->pageX());
    return result;
}


JSValue jsTouchPageY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTouch* castedThis = static_cast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* imp = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(imp->pageY());
    return result;
}


JSValue jsTouchTarget(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTouch* castedThis = static_cast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* imp = static_cast<Touch*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->target()));
    return result;
}


JSValue jsTouchIdentifier(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTouch* castedThis = static_cast<JSTouch*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Touch* imp = static_cast<Touch*>(castedThis->impl());
    JSValue result = jsNumber(imp->identifier());
    return result;
}


JSValue jsTouchConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTouch* domObject = static_cast<JSTouch*>(asObject(slotBase));
    return JSTouch::getConstructor(exec, domObject->globalObject());
}

JSValue JSTouch::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTouchConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Touch* impl)
{
    return wrap<JSTouch>(exec, globalObject, impl);
}

Touch* toTouch(JSC::JSValue value)
{
    return value.inherits(&JSTouch::s_info) ? static_cast<JSTouch*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(TOUCH_EVENTS)
