/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-François Wauthy (pollux@xfce.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef	__XFPRINT_VPAGES_PAGE_H__
#define	__XFPRINT_VPAGES_PAGE_H__

#include <gtk/gtk.h>
#include <xfprintsettings.h>

#ifdef	__cplusplus
extern "C"
{
#endif                          /* !__cplusplus */

#define VPAGES_PAGE(obj)						\
	G_TYPE_CHECK_INSTANCE_CAST(obj, vpages_page_get_type(), VpagesPage)
#define VPAGES_PAGE_CLASS(klass)					\
	G_TYPE_CHECK_CLASS_CAST(klass, vpages_page_get_type(), VpagesPage)
#define VPAGES_IS_PAGE(obj)						\
	G_TYPE_CHECK_INSTANCE_TYPE(obj, vpages_page_get_type())

  typedef struct _VpagesPage VpagesPage;
  typedef struct _VpagesPageClass VpagesPageClass;

  struct _VpagesPage
  {
    GtkTable table;

    GtkWidget *clineno;
    GtkWidget *lineno;
    GtkWidget *clpp;
    GtkWidget *lpp;
    GtkWidget *ccpl;
    GtkWidget *cpl;
    GtkWidget *tabsize;
    GtkWidget *nprfmt;
  };

  struct _VpagesPageClass
  {
    GtkTableClass parent_class;
  };

  extern GtkType vpages_page_get_type (void);
  extern GtkWidget *vpages_page_new (void);
  extern void vpages_page_set_settings (VpagesPage *, const XfprintSettingsVirtualPages *);
  extern void vpages_page_get_settings (VpagesPage *, XfprintSettingsVirtualPages *);

#ifdef	__cplusplus
}
#endif                          /* !__cplusplus */

#endif                          /* !__XFPRINT_VPAGES_PAGE_H__ */
