/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.HashSet;
import java.util.Set;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationStatistics {
    public double getCardinality(TupleExpr expr) {
        return this.getCardinality(expr, new HashSet<String>());
    }

    public double getCardinality(TupleExpr expr, Set<String> boundVars) {
        CardinalityCalculator cc = this.getCardinalityCalculator(boundVars);
        expr.visit(cc);
        return cc.getCardinality();
    }

    protected CardinalityCalculator getCardinalityCalculator(Set<String> boundVars) {
        return new CardinalityCalculator(boundVars);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CardinalityCalculator
    extends QueryModelVisitorBase<RuntimeException> {
        protected Set<String> boundVars;
        protected double cardinality;

        public CardinalityCalculator(Set<String> boundVars) {
            this.boundVars = boundVars;
        }

        public double getCardinality() {
            return this.cardinality;
        }

        @Override
        public void meet(EmptySet node) {
            this.cardinality = 0.0;
        }

        @Override
        public void meet(SingletonSet node) {
            this.cardinality = 1.0;
        }

        @Override
        public void meet(StatementPattern sp) {
            this.cardinality = 1000.0;
            int constantVarCount = this.countConstantVars(sp);
            int boundVarCount = this.countBoundVars(sp);
            int sqrtFactor = 2 * boundVarCount + constantVarCount;
            if (sqrtFactor >= 2) {
                this.cardinality = Math.pow(this.cardinality, 1.0 / (double)sqrtFactor);
            }
        }

        protected int countConstantVars(StatementPattern sp) {
            Var[] spVars;
            int constantVarCount = 0;
            for (Var var : spVars = new Var[]{sp.getSubjectVar(), sp.getPredicateVar(), sp.getObjectVar(), sp.getContextVar()}) {
                if (var == null || !var.hasValue()) continue;
                ++constantVarCount;
            }
            return constantVarCount;
        }

        protected int countBoundVars(StatementPattern sp) {
            Var[] spVars;
            int boundVarCount = 0;
            for (Var var : spVars = new Var[]{sp.getSubjectVar(), sp.getPredicateVar(), sp.getObjectVar(), sp.getContextVar()}) {
                if (var == null || !this.boundVars.contains(var.getName())) continue;
                ++boundVarCount;
            }
            return boundVarCount;
        }

        @Override
        public void meet(Join node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        public void meet(LeftJoin node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        protected void meetBinaryTupleOperator(BinaryTupleOperator node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality += leftArgCost;
        }

        @Override
        protected void meetUnaryTupleOperator(UnaryTupleOperator node) {
            node.getArg().visit(this);
        }

        @Override
        protected void meetNode(QueryModelNode node) {
            throw new IllegalArgumentException("Unhandled node type: " + node.getClass());
        }
    }
}

