labelText = 'QTable'
iconName = 'inline_table'

helpText = """From the docs: 'The QTable class provides a flexible 
editable table widget.'
"""

import csv
import os

from qt import QFrame, QStringList, QVBoxLayout, SIGNAL
from qttable import QTable

from kdeui import KTextEdit

contrib = os.path.join(os.path.split(__file__)[0], 'CONTRIB')


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.help = KTextEdit(helpText, '', self)

        data = csv.reader(open(contrib))
        header = data.next()
        items = [item for item in data]

        self.table = table = QTable(len(items), len(header), self)
        headers = QStringList()
        for headertext in header:
            headers.append(headertext)
        table.setColumnLabels(headers)

        cols = range(len(header))
        for row, record in enumerate(items):
            for col in cols:
                table.setText(row, col, record[col])

        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        layout.addWidget(self.table)
        layout.addStretch(1)
