/***************************************************************************
* $Id: CheckLists.java 138535 2002-02-25 14:36:46Z rdale $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.kde.qt.*;
import java.util.*;

class CheckLists  extends QWidget
{

protected QListView lv1, lv2;
protected QLabel label;

/*
  Constructor
 *
  Create all child widgets of the CheckList Widget
 */

CheckLists( )
{
	this(null, null);
}

CheckLists( QWidget parent, String name )
{
    super( parent, name );
    QHBoxLayout lay = new QHBoxLayout( this );
    lay.setMargin( 5 );

    // create a widget which layouts its childs in a column
    QVBoxLayout vbox1 = new QVBoxLayout( lay );
    vbox1.setMargin( 5 );

    // First child: a Label
    vbox1.addWidget( new QLabel( "Check some items!", this ) );

    // Second child: the ListView
    lv1 = new QListView( this );
    vbox1.addWidget( lv1 );
    lv1.addColumn( "Items" );
    lv1.setRootIsDecorated( true );

    // create a list with 4 ListViewItems which will be parent items of other ListViewItems
    ArrayList parentList = new ArrayList();

    parentList.add( new QListViewItem( lv1, "Parent Item 1" ) );
    parentList.add( new QListViewItem( lv1, "Parent Item 2" ) );
    parentList.add( new QListViewItem( lv1, "Parent Item 3" ) );
    parentList.add( new QListViewItem( lv1, "Parent Item 4" ) );

    QListViewItem item = null;
    int num = 1;
    // go through the list of parent items...
    for ( Iterator it = parentList.iterator(); it.hasNext(); num++ ) {
	item = (QListViewItem) it.next();
	item.setOpen( true );
	// ...and create 5 checkable child ListViewItems for each parent item
	for ( int i = 1; i <= 5; i++ )
	    new QCheckListItem( item, i + ". Child of Parent " + num, QCheckListItem.CheckBox );
    }

    // Create another widget for layouting
    QVBoxLayout tmp = new QVBoxLayout( lay );
    tmp.setMargin( 5 );

    // create a pushbutton
    QPushButton copy1 = new QPushButton( "  ->  ", this );
    tmp.addWidget( copy1 );
    copy1.setMaximumWidth( copy1.sizeHint().width() );
    // connect the SIGNAL clicked() of the pushbutton with the SLOT copy1to2()
    connect( copy1, SIGNAL(" clicked()"), this, SLOT(" copy1to2()") );

    // another widget for layouting
    QVBoxLayout vbox2 = new QVBoxLayout( lay );
    vbox2.setMargin( 5 );

    // and another label
    vbox2.addWidget( new QLabel( "Check one item!", this ) );

    // create the second listview
    lv2 = new QListView( this );
    vbox2.addWidget( lv2 );
    lv2.addColumn( "Items" );
    lv2.setRootIsDecorated( true );

    // another widget needed for layouting only
    tmp = new QVBoxLayout( lay );
    tmp.setMargin( 5 );

    // create another pushbutton...
    QPushButton copy2 = new QPushButton( "  ->  ", this );
    lay.addWidget( copy2 );
    copy2.setMaximumWidth( copy2.sizeHint().width() );
    // ...and connect its clicked() SIGNAL to the copy2to3() SLOT
    connect( copy2, SIGNAL(" clicked()"), this, SLOT(" copy2to3()") );

    tmp = new QVBoxLayout( lay );
    tmp.setMargin( 5 );

    // and create a label which will be at the right of the window
    label = new QLabel( "No Item yet...", this );
    tmp.addWidget( label );
}

/*
  SLOT copy1to2()
 *
  Copies all checked ListViewItems from the first ListView to
  the second one, and inserts them as Radio-ListViewItem.
 */

public void copy1to2()
{
    // create an iterator which operates on the first ListView
    Iterator it = lv1.itemList().iterator();

    lv2.clear();

    // Insert first a controller Item into the second ListView. Always if Radio-ListViewItems
    // are inserted into a Listview, the parent item of these MUST be a controller Item!
    QCheckListItem item = new QCheckListItem( lv2, "Controller", QCheckListItem.Controller );
    item.setOpen( true );

    // iterate through the first ListView...
    while ( it.hasNext() ) {
		QListViewItem current = (QListViewItem) it.next();
	// ...check state of childs, and...
	if ( current.parent() != null )
	    // ...if the item is checked...
	    if ( ( (QCheckListItem) current ).isOn() )
		// ...insert a Radio-ListViewItem with the same text into the second ListView
		new QCheckListItem( item, current.text( 0 ), QCheckListItem.RadioButton );

	}
    if ( item.firstChild() != null )
	( ( QCheckListItem )item.firstChild() ).setOn( true );
}

/*
  SLOT copy2to3()
 *
  Copies the checked item of the second ListView into the
  Label at the right.
 */

public void copy2to3()
{
    // create an iterator which operates on the second ListView
    Iterator it = lv2.itemList().iterator();

    label.setText( "No Item checked" );

    // iterate through the second ListView...
    while ( it.hasNext() ) {
		QListViewItem current = (QListViewItem) it.next();
	// ...check state of childs, and...
	if ( current.parent() != null )
	    // ...if the item is checked...
	    if ( ( (QCheckListItem) current ).isOn() )
		// ...set the text of the item to the label
		label.setText( current.text( 0 ) );
	}
}
}

