


#include <qcstring.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qcanvas.h>
#include "qcanvaspolygon_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasPolygonImp::QCanvasPolygonImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasPolygonImp::~QCanvasPolygonImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasPolygonImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasPolygonImp *meth = new QCanvasPolygonImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasPolygonImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_setPoints_3, "setPoints" },
        { Method_points_4, "points" },
        { Method_moveBy_5, "moveBy" },
        { Method_areaPoints_6, "areaPoints" },
        { Method_rtti_7, "rtti" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasPolygonImp *meth = new QCanvasPolygonImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a QCanvasPolygon pointer from an Object.
 */
QCanvasPolygon *QCanvasPolygonImp::toQCanvasPolygon( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QCanvasPolygon *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QCanvasPolygon" )
        return 0;

    return op->toNative<QCanvasPolygon>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasPolygonImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasPolygon_1:
             return QCanvasPolygon_1( exec, args );
             break;

         default:
             break;
    }

    QString msg = i18n("QCanvasPolygonCons has no constructor with id '%1',").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object QCanvasPolygonImp::QCanvasPolygon_1( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter QCanvas *
    return KJS::Object();

    QCanvas * arg0; // Dummy


    // We should now create an instance of the QCanvasPolygon object

    QCanvasPolygon *ret = new QCanvasPolygon(

          arg0 );


}

KJS::Value QCanvasPolygonImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasPolygonImp::toQCanvasPolygon( self );

    switch( id ) {

    case Method_setPoints_3:
        return setPoints_3( exec, self, args );
        break;

    case Method_points_4:
        return points_4( exec, self, args );
        break;

    case Method_moveBy_5:
        return moveBy_5( exec, self, args );
        break;

    case Method_areaPoints_6:
        return areaPoints_6( exec, self, args );
        break;

    case Method_rtti_7:
        return rtti_7( exec, self, args );
        break;

    default:
        break;
    }

    QString msg = i18n( "QCanvasPolygonImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value QCanvasPolygonImp::setPoints_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QPointArray
    return KJS::Value();

    QPointArray arg0; // Dummy

      instance->setPoints(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasPolygonImp::points_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->points(  );
      return KJS::Value(); // Returns 'QPointArray'

}

KJS::Value QCanvasPolygonImp::moveBy_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

    double arg1 = extractDouble(exec, args, 1);

      instance->moveBy(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasPolygonImp::areaPoints_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->areaPoints(  );
      return KJS::Value(); // Returns 'QPointArray'

}

KJS::Value QCanvasPolygonImp::rtti_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


