/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected Inflater inf;
    protected int len;

    protected void fill() throws IOException {
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len != -1) {
            this.inf.setInput(this.buf, 0, this.len);
        }
    }

    public InflaterInputStream(InputStream in) {
        this(in, new Inflater(), 512);
    }

    public InflaterInputStream(InputStream in, Inflater infl) {
        this(in, infl, 512);
    }

    public InflaterInputStream(InputStream in, Inflater inf, int size) {
        super(in);
        if (in == null) {
            throw new NullPointerException("in may not be null");
        }
        if (inf == null) {
            throw new NullPointerException("inf may not be null");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size may not be negative");
        }
        this.inf = inf;
        this.buf = new byte[size];
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int r = this.read(buf, 0, 1);
        if (r != -1) {
            r = buf[0] & 0xFF;
        }
        return r;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (len == 0) {
            return 0;
        }
        if (this.inf.finished()) {
            return -1;
        }
        int count = 0;
        while (count == 0) {
            if (this.inf.needsInput()) {
                this.fill();
            }
            try {
                count = this.inf.inflate(buf, off, len);
                if (count != 0) continue;
                if (this.len == -1) {
                    return -1;
                }
                if (!this.inf.needsDictionary()) continue;
                throw new ZipException("Inflater needs Dictionary");
            }
            catch (DataFormatException dfe) {
                throw new ZipException(dfe.getMessage());
            }
        }
        return count;
    }

    public void close() throws IOException {
        this.inf = null;
        super.close();
    }

    public int available() throws IOException {
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (this.inf.finished()) {
            return 0;
        }
        return 1;
    }

    public long skip(long n) throws IOException {
        int r;
        if (this.inf == null) {
            throw new IOException("stream closed");
        }
        if (n == 0L) {
            return 0L;
        }
        int min = (int)Math.min(n, (long)1024);
        byte[] buf = new byte[min];
        long s = 0L;
        while (n > 0L && (r = this.read(buf, 0, min)) != -1) {
            s += (long)r;
            min = (int)Math.min(n -= (long)r, (long)1024);
        }
        return s;
    }
}

