/*
 *  Hamlib CI-V backend - description of IC-R71
 *  Copyright (c) 2000-2003 by Stephane Fillod
 *
 *	$Id: icr71.c,v 1.2 2005/04/03 19:53:51 fillods Exp $
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>

#include "hamlib/rig.h"
#include "icom.h"

/* FM optional */
#define ICR71_MODES (RIG_MODE_AM|RIG_MODE_CW|RIG_MODE_SSB|RIG_MODE_FM|RIG_MODE_RTTY)

#define ICR71_FUNC_ALL (RIG_FUNC_NONE)

#define ICR71_LEVEL_ALL (RIG_LEVEL_NONE)

#define ICR71_VFO_ALL (RIG_VFO_A)

#define ICR71_VFO_OPS (RIG_OP_FROM_VFO|RIG_OP_TO_VFO)
#define ICR71_SCAN_OPS (RIG_SCAN_NONE)

static const struct icom_priv_caps icr71_priv_caps = { 
		0x1a,	/* default address */
		0,		/* 731 mode */
		ic737_ts_sc_list	/* none actually */
};

const struct rig_caps icr71_caps = {
.rig_model =  RIG_MODEL_ICR71,
.model_name = "IC-R71", 
.mfg_name =  "Icom", 
.version =  BACKEND_VER, 
.copyright =  "LGPL",
.status =  RIG_STATUS_UNTESTED,
.rig_type =  RIG_TYPE_RECEIVER,
.ptt_type =  RIG_PTT_NONE,
.dcd_type =  RIG_DCD_NONE,
.port_type =  RIG_PORT_SERIAL,
.serial_rate_min =  300,
.serial_rate_max =  1200,
.serial_data_bits =  8,
.serial_stop_bits =  1,
.serial_parity =  RIG_PARITY_NONE,
.serial_handshake =  RIG_HANDSHAKE_NONE, 
.write_delay =  0,
.post_write_delay =  0,
.timeout =  200,
.retry =  3, 
.has_get_func =  ICR71_FUNC_ALL,
.has_set_func =  ICR71_FUNC_ALL, 
.has_get_level =  ICR71_LEVEL_ALL,
.has_set_level =  RIG_LEVEL_SET(ICR71_LEVEL_ALL),
.has_get_parm =  RIG_PARM_NONE,
.has_set_parm =  RIG_PARM_NONE,
.level_gran =  {},
.parm_gran =  {},
.ctcss_list =  NULL,
.dcs_list =  NULL,
.preamp =   { RIG_DBLST_END, },
.attenuator =   { RIG_DBLST_END, },
.max_rit =  Hz(0),
.max_xit =  Hz(0),
.max_ifshift =  Hz(0),
.targetable_vfo =  0,
.vfo_ops =  ICR71_VFO_OPS,
.scan_ops =  ICR71_SCAN_OPS,
.transceive =  RIG_TRN_RIG,
.bank_qty =   0,
.chan_desc_sz =  0,

.chan_list =  {
		{   1,  99, RIG_MTYPE_MEM, IC_MIN_MEM_CAP  },
		RIG_CHAN_END,
	},

.rx_range_list1 =   {
	{kHz(100),MHz(30),ICR71_MODES,-1,-1,ICR71_VFO_ALL},
	RIG_FRNG_END, },
.tx_range_list1 =   { RIG_FRNG_END, },

.rx_range_list2 =   {
	{kHz(100),MHz(30),ICR71_MODES,-1,-1,ICR71_VFO_ALL},
	RIG_FRNG_END, },
.tx_range_list2 =   { RIG_FRNG_END, },

.tuning_steps = 	{
	 {ICR71_MODES,Hz(10)},	/* resolution */
	 RIG_TS_END,
	},
	/* mode/filter list, remember: order matters! */
.filters = 	{
		{RIG_MODE_SSB|RIG_MODE_CW|RIG_MODE_RTTY, kHz(2.3)},
		{RIG_MODE_AM, kHz(6)},
		{RIG_MODE_FM, kHz(15)},	/* optional w/ IC-EX257 unit */
		RIG_FLT_END,
	},

.cfgparams =  icom_cfg_params,
.set_conf =  icom_set_conf,
.get_conf =  icom_get_conf,

.priv =  (void*)&icr71_priv_caps,
.rig_init =   icom_init,
.rig_cleanup =   icom_cleanup,
.rig_open =  NULL,
.rig_close =  NULL,

.set_freq =  icom_set_freq,
.get_freq =  icom_get_freq,
.set_mode =  icom_set_mode,
.get_mode =  icom_get_mode,
.set_vfo =  icom_set_vfo,

.decode_event =  icom_decode_event,
.set_mem =  icom_set_mem,
.vfo_op =  icom_vfo_op,

};


