.\"
.\" $XdotOrg: xc/programs/Xserver/hw/xfree86/xf86cfg/xorgcfg.man,v 1.3 2005/04/22 22:11:26 alanc Exp $
.\" Copyright (c) 2000 by Conectiva S.A. (http://www.conectiva.com)
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" CONECTIVA LINUX BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of Conectiva Linux shall
.\" not be used in advertising or otherwise to promote the sale, use or other
.\" dealings in this Software without prior written authorization from
.\" Conectiva Linux.
.\"
.\" Author: Paulo César Pereira de Andrade <pcpa@conectiva.com.br>
.\"
.\" $XFree86: xc/programs/Xserver/hw/xfree86/xf86cfg/xf86cfg.man,v 1.9 2002/12/30 14:34:02 herrb Exp $
.\"
.TH xorgcfg __appmansuffix__ __vendorversion__
.SH NAME
xorgcfg - Graphical configuration tool for __xservername__
.SH SYNOPSIS
.B xorgcfg
[-config \fIconfigfile\fP] [-modulepath \fImoduledir\fP] 
[-fontpath \fIfontsdir\fP] [-toolkitoption ...]
.SH DESCRIPTION
.I Xorgcfg
is a tool to configure\fI __xservername__\fP, and can be used to either write the
initial configuration file or make customizations to the current configuration.
.PP
When the \fBDISPLAY\fP environment variable is not set, xorgcfg will run
the command\fI __xservername__ -configure\fP to allow the xserver to detect the
hardware in the computer, and write an initial\fI __xconfigfile__\fP file
in the user's home directory. Then, it will start 
__xservername__ and allow customizations.
.PP
If the \fBDISPLAY\fP environment variable is set, xorgcfg will read the
default\fI __xconfigfile__\fP, which may or may not be the one being used by 
the current server, and allow customizations.
.PP
To use an alternative location for modules or fonts the respective search
paths may be specified.
.PP
Unless there is an \fBApply\fP button in the current xorgcfg dialog, the
changes made will take place the next time\fI __xservername__\fP is started.
.PP
Xorgcfg allows addition and configuration of new devices, such as video cards,
monitors, keyboards and mouses.
.PP
Screen layout configuration for xinerama or traditional multi-head is also
available.
.PP
Modelines can be configured or optimized.
.PP
AccessX basic configurations can be made in the xorgcfg's accessx section.

.SH OPTIONS
.TP 8
.I -config
Specifies an alternate __xconfigfile__ file for configuration.
.TP 8
.I -modulepath
Specifies where xorgcfg, and the server it may start, should look for
__xservername__ modules.
.TP 8
.I -serverpath
Specifies the complete path, not including the binary name, of the
__xservername__ binary.
.TP 8
.I -fontpath
Specifies the path to the fonts that should be used by the server started
by xorgcfg.
.TP 8
.I -rgbpath
Specifies the path to the rgb.txt file that should be used by the server
started by xorgcfg, if any.
.TP 8
.I -textmode
If xorgcfg was compiled with support for ncurses, this option makes xorgcfg
enter a text mode interface.
.TP 8
.I -nomodules
When built with support for loading modules, this options changes xorgcfg
behaviour, so that it will not load any modules, and thus start quicker.

.SH ENVIRONMENT
.TP 8
.I DISPLAY
Default host and display number.
.TP 8
.I XWINHOME
Directory where __xservername__ was installed, defaults to __projectroot__.
.TP 8
.I XENVIRONMENT
Name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.

.SH FILES
.TP 8
.I /etc/__xconfigfile__
Server configuration file
.TP 8
.I /etc/X11/__xconfigfile__
Server configuration file
.TP 8
.I __projectroot__/etc/__xconfigfile__
Server configuration file
.TP 8
.IR __projectroot__/lib/X11/__xconfigfile__. hostname
Server configuration file
.TP 8
.I __projectroot__/lib/X11/__xconfigfile__
Server configuration file
.TP 8
.I __projectroot__/lib/X11/app-default/XOrgCfg
Specifies xorgcfg resources
.TP 8
.I __projectroot__/lib/X11/xkb/X0-config.keyboard
Keyboard specific configuration

.SH "SEE ALSO"
.IR __xservername__ (__appmansuffix__),
.IR __xconfigfile__ (__filemansuffix__)

.SH COPYRIGHT
.TP 8
Copyright 2000, Conectiva Linux S.A.
\fIhttp://www.conectiva.com\fP
.TP 8
Copyright 2000, The XFree86 Project
\fIhttp://www.XFree86.org\fP

.SH AUTHORS
.TP 8
Paulo C\'esar Pereira de Andrade \fI<pcpa@conectiva.com.br>\fP
originally for The XFree86 Project.

.SH BUGS
Probably.
