#this file contains the following macros
#KDE_CREATE_LIBTOOL_FILE(target) - create the la file for a plugin
#LT_TARGET_LINK_CONV_LIBRARIES(target convenicene libs...) - use this to link to static conv. libs
#LT_TARGET_LINK_LIBRARIES(target libs... )
# replacement for TARGET_LINK_LIBRARIES() - handles static libs like libtool conv. libs, DOESN'T WORK YET


#this is a hack right now to support the behaviour of libtool convenience libs
#for other platforms:
#Darwin: -all_load $convenience
#GNU ld:  --whole-archive $convenience --no-whole-archive (depending on the ld version! must test if it supports the flag)
#Solaris 2: -z allextract $convenience -z defaultextract
#cmake 2,2 will come with some feature to support this in some way
MACRO (LT_TARGET_LINK_CONV_LIBRARIES _target)
   TARGET_LINK_LIBRARIES(${_target} "-Wl,--whole-archive" ${ARGN} "-Wl,--no-whole-archive")
ENDMACRO (LT_TARGET_LINK_CONV_LIBRARIES)


MACRO(LT_TARGET_LINK_LIBRARIES _target_NAME)
   GET_TARGET_PROPERTY(_target_TYPE ${_target_NAME} TYPE)
#   MESSAGE(STATUS "type: ${_target_TYPE}")
   IF (${_target_TYPE} STREQUAL "SHARED_LIBRARY" OR ${_target_TYPE} STREQUAL "MODULE_LIBRARY")

      FOREACH (_current_LIB ${ARGN})
         GET_TARGET_PROPERTY(_lib_TYPE ${_current_LIB} TYPE)

#         MESSAGE(STATUS "linking to lib: ${_current_LIB} type: ${_lib_TYPE}")

         IF (${_lib_TYPE} STREQUAL "STATIC_LIBRARY")
            SET(_fake_LIBS ${_fake_LIBS} ${_current_LIB})
         ELSE (${_lib_TYPE} STREQUAL "STATIC_LIBRARY")
            SET(_normal_LIBS ${_normal_LIBS} ${_current_LIB})
         ENDIF (${_lib_TYPE} STREQUAL "STATIC_LIBRARY")

      ENDFOREACH (_current_LIB)

      TARGET_LINK_LIBRARIES(${_target_NAME} ${_normal_LIBS})

      IF(_fake_LIBS)
         LT_TARGET_LINK_CONV_LIBRARIES(${_target_NAME} ${_fake_LIBS})
      ENDIF(_fake_LIBS)

   ELSE (${_target_TYPE} STREQUAL "SHARED_LIBRARY" OR ${_target_TYPE} STREQUAL "MODULE_LIBRARY")

      TARGET_LINK_LIBRARIES(${_target_NAME} ${ARGN})
   ENDIF (${_target_TYPE} STREQUAL "SHARED_LIBRARY" OR ${_target_TYPE} STREQUAL "MODULE_LIBRARY")

ENDMACRO(LT_TARGET_LINK_LIBRARIES _target_NAME)

MACRO(KDE_CREATE_LIBTOOL_FILE _target)
   GET_TARGET_PROPERTY(_target_location ${_target} LOCATION)

   GET_FILENAME_COMPONENT(_laname ${_target_location} NAME_WE)
   GET_FILENAME_COMPONENT(_soname ${_target_location} NAME)
   SET(_laname ${_laname}.la)

   FILE(WRITE ${_laname} "# ${_laname} - a libtool library file, generated by cmake \n")
   FILE(APPEND ${_laname} "# The name that we can dlopen(3).\n")
   FILE(APPEND ${_laname} "dlname='${_soname}'\n")
   FILE(APPEND ${_laname} "# Names of this library\n")
   FILE(APPEND ${_laname} "library_names='${_soname} ${_soname} ${_soname}'\n")
   FILE(APPEND ${_laname} "# The name of the static archive\n")
   FILE(APPEND ${_laname} "old_library=''\n")
   FILE(APPEND ${_laname} "# Libraries that this one depends upon.\n")
   FILE(APPEND ${_laname} "dependency_libs=''\n")
#   FILE(APPEND ${_laname} "dependency_libs='${${_target}_LIB_DEPENDS}'\n")
   FILE(APPEND ${_laname} "# Version information.\ncurrent=0\nage=0\nrevision=0\n")
   FILE(APPEND ${_laname} "# Is this an already installed library?\ninstalled=yes\n")
   FILE(APPEND ${_laname} "# Should we warn about portability when linking against -modules?\nshouldnotlink=yes\n")
   FILE(APPEND ${_laname} "# Files to dlopen/dlpreopen\ndlopen=''\ndlpreopen=''\n")
   FILE(APPEND ${_laname} "# Directory that this library needs to be installed in:\n")
   FILE(APPEND ${_laname} "libdir='${CMAKE_INSTALL_PREFIX}/lib/kde3'\n")

   INSTALL_FILES(/lib/kde3 FILES ${_laname})
ENDMACRO(KDE_CREATE_LIBTOOL_FILE)
