/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;

public final class ActivationDesc
implements Serializable {
    static final long serialVersionUID = 7455834104417690957L;
    private ActivationGroupID groupid;
    private String classname;
    private String location;
    private MarshalledObject data;
    private boolean restart;

    public ActivationDesc(String className, String location, MarshalledObject data) throws ActivationException {
        this(ActivationGroup.currentGroupID(), className, location, data, false);
    }

    public ActivationDesc(String className, String location, MarshalledObject data, boolean restart) throws ActivationException {
        this(ActivationGroup.currentGroupID(), className, location, data, restart);
    }

    public ActivationDesc(ActivationGroupID groupID, String className, String location, MarshalledObject data) {
        this(groupID, className, location, data, false);
    }

    public ActivationDesc(ActivationGroupID groupID, String className, String location, MarshalledObject data, boolean restart) {
        this.groupid = groupID;
        this.classname = className;
        this.location = location;
        this.data = data;
        this.restart = restart;
    }

    public ActivationGroupID getGroupID() {
        return this.groupid;
    }

    public String getClassName() {
        return this.classname;
    }

    public String getLocation() {
        return this.location;
    }

    public MarshalledObject getData() {
        return this.data;
    }

    public boolean getRestartMode() {
        return this.restart;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ActivationDesc)) {
            return false;
        }
        ActivationDesc that = (ActivationDesc)obj;
        return this.groupid.equals(that.groupid) && this.classname.equals(that.classname) && this.location.equals(that.location) && this.data.equals(that.data) && this.restart == that.restart;
    }

    public int hashCode() {
        return this.groupid.hashCode() ^ this.classname.hashCode() ^ this.location.hashCode() ^ this.data.hashCode();
    }
}

