/***************************************************************************
 *   Copyright (C) 2004 by Richard Moore                                   *
 *   rich@kde.org                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "embedviewimp.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("A KDE Application");

static const char version[] = "0.1";

int main(int argc, char **argv)
{
    KAboutData about("embedjs", I18N_NOOP("EmbedJS"), version, description,
                     KAboutData::License_LGPL, "(C) 2004 Ian Reinhart Geiser", 0, 0, "geiseri@kde.org");
    about.addAuthor( "Ian Reinhart Geiser", 0, "geiseri@kde.org" );
    KCmdLineArgs::init(argc, argv, &about);
    KApplication app;

    EmbedViewImp *view = new EmbedViewImp;
    app.setMainWidget(view);
    view->show();
    view->runScript("test.js");
    return app.exec();
}
