//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import org.kde.qt.QWidget;

/**

 @class Loads a KControl Module.
 @description KCModuleLoader tries in several ways 
 to locate and load a KCModule. If loading fails a 
 zero pointer is returned. \n
 It is very unlikely KCModuleLoader is what you want 
 and {@link KCModuleProxy} suits your needs.
		@author Frans Englich <frans.englich@telia.com>

		@short    @class Loads a KControl Module.

*/
public class KCModuleLoader implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KCModuleLoader(Class dummy){}

	/**	
		 Determines the way errors are reported
		     		@short    Determines the way errors are reported
	*/
	public static final int None = 0;
	public static final int Inline = 1;
	public static final int Dialog = 2;
	public static final int Both = 3;

	public KCModuleLoader() {
		newKCModuleLoader();
	}
	private native void newKCModuleLoader();
	/**	
		 Loads a {@link KCModule}. If loading fails a zero pointer is returned.
			@param module what module to load
			@param report @see ErrorReporting
			@param withFallback if true and loading failed a separate window
		 with the module may appear and a zero pointer is a returned
				@return a pointer to the loaded @ref KCModule

		@short    Loads a @ref KCModule.
	*/
	public static native KCModule loadModule(KCModuleInfo module, int report, boolean withFallback, QWidget parent, String name, String[] args);
	public static native KCModule loadModule(KCModuleInfo module, int report, boolean withFallback, QWidget parent, String name);
	public static native KCModule loadModule(KCModuleInfo module, int report, boolean withFallback, QWidget parent);
	public static native KCModule loadModule(KCModuleInfo module, int report, boolean withFallback);
	public static native KCModule loadModule(KCModuleInfo module, int report);
	/**	
		 Loads a {@link KCModule}. If loading fails a zero pointer is returned.
			@param module what module to load
			@param report @see ErrorReporting
		 with the module may appear and a zero pointer is a returned
				@return a pointer to the loaded @ref KCModule

		@short    Loads a @ref KCModule.
	*/
	public static native KCModule loadModule(String module, int report, QWidget parent, String name, String[] args);
	public static native KCModule loadModule(String module, int report, QWidget parent, String name);
	public static native KCModule loadModule(String module, int report, QWidget parent);
	public static native KCModule loadModule(String module, int report);
	/**	
		 Unloads the module's library
			@param mod What module to unload for
		     		@short    Unloads the module's library
	*/
	public static native void unloadModule(KCModuleInfo mod);
	/**	
		 Checks whether an KCModule should be shown by running its 
		 test function. If it is unsure whether a module should be shown, it should 
		 be made available, leaving the decision to the user.
		 If false is returned, the module should not be loaded in any interface.
			 A module declares it needs to be tested by having "X-KDE-Test-Module=true" in 
		 its desktop file. When that line exists, the following code must be available 
		 in the module's library:
			 <pre>
		 extern "C"
		 {
		    boolean test_moduleName()
		    {
		      // Code testing for hardware/software presence.
		      return true; // and the modue will be loaded.
		    }
			 }
		 </pre>
			 where moduleName is the library name for the module.
			@param module the module to check
				@return true if the module should be loaded

		@short    Checks whether an KCModule should be shown by running its   test function.
	*/
	public static native boolean testModule(String module);
	/**	
		 Convenience function, essentially the same as above.
			@param module the module to check
				@return true if the module should be loaded

		@short    Convenience function, essentially the same as above.
	*/
	public static native boolean testModule(KCModuleInfo module);
	/**	
		 Returns a @see KCModule containing the messages <code>report</code> and <code>text.</code>
			@param report the type of error reporting, @see ErrorReporting
			@param text the main message
			@param details any additional details
			     		@short    Returns a @see KCModule containing the messages <code>report</code> and <code>text.</code>
	*/
	public static native KCModule reportError(int report, String text, String details, QWidget parent);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
