/**
 * This file is part of the HTML rendering engine for KDE.
 *
 * Copyright (C) 2004 Allan Sandfeld Jensen (kde@carewolf.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifndef ENUMERATE_H
#define ENUMERATE_H

class QChar;
class QString;

namespace khtml {

namespace Enumerate {

// Numeric
    QString toNumeric( int number, int base );
    QString toArabicIndic( int number );
    QString toPersianUrdu( int number );

// Alphabetic
    QString toLatin( int number, int base );
    QString toAlphabetic( int number, int base, const QChar alphabet[] );
    QString toLowerGreek( int number );
    QString toUpperGreek( int number );
    QString toHiragana( int number );
    QString toHiraganaIroha( int number );
    QString toKatakana( int number );
    QString toKatakanaIroha( int number );

// Algorithmic
    QString toRoman( int number, bool upper );
    QString toHebrew( int number );
    QString toGeorgian( int number );
    QString toArmenian( int number );

}} // namespaces

#endif
