/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.DatagramChannelImpl;
import gnu.java.nio.DatagramChannelSelectionKey;
import gnu.java.nio.SelectionKeyImpl;
import gnu.java.nio.ServerSocketChannelImpl;
import gnu.java.nio.ServerSocketChannelSelectionKey;
import gnu.java.nio.SocketChannelImpl;
import gnu.java.nio.SocketChannelSelectionKey;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SelectorImpl
extends AbstractSelector {
    private Set keys;
    private Set selected;
    private Object selectThreadMutex;
    private Thread selectThread;
    private boolean unhandledWakeup;

    private /* synthetic */ void finit$() {
        this.selectThreadMutex = new Object();
    }

    public SelectorImpl(SelectorProvider provider) {
        super(provider);
        this.finit$();
        this.keys = new HashSet();
        this.selected = new HashSet();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected final void implCloseSelector() throws IOException {
        this.wakeup();
        Set set = this.keys;
        // MONITORENTER : set
        try {
            Set set2 = this.selected;
            // MONITORENTER : set2
            try {
                Set set3 = this.cancelledKeys();
                // MONITORENTER : set3
                // MONITOREXIT : set3
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                // MONITOREXIT : set2
                throw throwable;
            }
            Object var3_3 = null;
            // MONITOREXIT : set2
            var3_3 = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            // MONITOREXIT : set
            throw throwable;
        }
    }

    public final Set keys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return Collections.unmodifiableSet(this.keys);
    }

    public final int selectNow() throws IOException {
        return this.select(1L);
    }

    public final int select() throws IOException {
        return this.select(0L);
    }

    private static native int implSelect(int[] var0, int[] var1, int[] var2, long var3) throws IOException;

    private final int[] getFDsAsArray(int ops) {
        SelectionKeyImpl key;
        int counter = 0;
        Iterator it = this.keys.iterator();
        while (it.hasNext()) {
            key = (SelectionKeyImpl)it.next();
            if ((key.interestOps() & ops) == 0) continue;
            ++counter;
        }
        int[] result = new int[counter];
        counter = 0;
        it = this.keys.iterator();
        while (it.hasNext()) {
            key = (SelectionKeyImpl)it.next();
            if ((key.interestOps() & ops) == 0) continue;
            result[counter] = key.getNativeFD();
            ++counter;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int select(long timeout) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        Set set = this.keys;
        synchronized (set) {
            try {
                Set set2 = this.selected;
                synchronized (set2) {
                    try {
                        this.deregisterCancelledKeys();
                        int[] read = this.getFDsAsArray(17);
                        int[] write = this.getFDsAsArray(12);
                        int[] except = new int[]{};
                        Object object = this.selectThreadMutex;
                        synchronized (object) {
                            try {
                                if (this.unhandledWakeup) {
                                    this.unhandledWakeup = false;
                                    return 0;
                                }
                                this.selectThread = Thread.currentThread();
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                throw throwable;
                            }
                            Object var10_11 = null;
                        }
                        int result = 0;
                        try {
                            this.begin();
                            result = SelectorImpl.implSelect(read, write, except, timeout);
                        }
                        finally {
                            Object var11_21 = null;
                            this.end();
                        }
                        Object object2 = this.selectThreadMutex;
                        synchronized (object2) {
                            try {
                                if (this.unhandledWakeup) {
                                    this.unhandledWakeup = false;
                                    Thread.interrupted();
                                }
                                this.selectThread = null;
                            }
                            finally {
                                Object var12_24 = null;
                            }
                            Iterator it = this.keys.iterator();
                            while (it.hasNext()) {
                                int i;
                                int ops = 0;
                                SelectionKeyImpl key = (SelectionKeyImpl)it.next();
                                if (this.selected.contains(key)) {
                                    ops = key.readyOps();
                                }
                                for (i = 0; i < read.length; ++i) {
                                    if (key.getNativeFD() != read[i]) continue;
                                    if (key.channel() instanceof ServerSocketChannelImpl) {
                                        ops |= 0x10;
                                        continue;
                                    }
                                    ops |= 1;
                                }
                                for (i = 0; i < write.length; ++i) {
                                    if (key.getNativeFD() != write[i]) continue;
                                    ops |= 4;
                                }
                                if (!this.selected.contains(key)) {
                                    this.selected.add(key);
                                }
                                key.readyOps(key.interestOps() & ops);
                            }
                            this.deregisterCancelledKeys();
                            return result;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_18 = null;
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                throw throwable;
            }
        }
    }

    public final Set selectedKeys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.selected;
    }

    public final Selector wakeup() {
        SelectorImpl selectorImpl;
        Object object = this.selectThreadMutex;
        synchronized (object) {
            block3: {
                try {
                    this.unhandledWakeup = true;
                    if (this.selectThread == null) break block3;
                    this.selectThread.interrupt();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            selectorImpl = null;
        }
        selectorImpl = this;
        return selectorImpl;
    }

    private final void deregisterCancelledKeys() {
        Set ckeys;
        Set set = ckeys = this.cancelledKeys();
        synchronized (set) {
            try {
                Iterator it = ckeys.iterator();
                while (it.hasNext()) {
                    this.keys.remove((SelectionKeyImpl)it.next());
                    it.remove();
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    protected SelectionKey register(SelectableChannel ch, int ops, Object att) {
        return this.register((AbstractSelectableChannel)ch, ops, att);
    }

    protected final SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
        SelectionKeyImpl result;
        if (ch instanceof SocketChannelImpl) {
            SocketChannelImpl sc = (SocketChannelImpl)ch;
            result = new SocketChannelSelectionKey(ch, this);
        } else if (ch instanceof DatagramChannelImpl) {
            DatagramChannelImpl dc = (DatagramChannelImpl)ch;
            result = new DatagramChannelSelectionKey(ch, this);
        } else if (ch instanceof ServerSocketChannelImpl) {
            ServerSocketChannelImpl ssc = (ServerSocketChannelImpl)ch;
            result = new ServerSocketChannelSelectionKey(ch, this);
        } else {
            throw new InternalError("No known channel type");
        }
        Set set = this.keys;
        synchronized (set) {
            SelectionKeyImpl selectionKeyImpl;
            try {
                this.keys.add(result);
            }
            finally {
                selectionKeyImpl = null;
            }
            result.interestOps(ops);
            result.attach(att);
            selectionKeyImpl = result;
            return selectionKeyImpl;
        }
    }
}

