/***************************************************************************
                          scores.cc -  description
                             -------------------
    begin                : Sun Oct 21 2001
    copyright            : (C) 2001 by Primoz Anzur 
    email                : zerokode@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
 #include <klocale.h>

#include "scores.moc"
#include "scores.h"

#include <qgroupbox.h>
#include <qheader.h>
#include <qlistview.h>
#include <qtabwidget.h>
#include <qlayout.h>

#include <kpushbutton.h>
#include <kstdguiitem.h>

/* 
 *  Constructs a HighScores which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
HighScores::HighScores( QWidget* parent,  const char* name, WFlags fl ) : QWidget( parent, name, fl )
{
config = kapp->config();


    if ( !name )
	setName( "HighScores" );
    resize( 349, 331 ); 
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)5, sizePolicy().hasHeightForWidth() ) );
    setCaption( i18n( "The Highest Scores" ) );
    setAutoMask( FALSE );
    HighScoresLayout = new QGridLayout( this ); 
    HighScoresLayout->setSpacing( 6 );
    HighScoresLayout->setMargin( 11 );

    GroupBox1 = new QGroupBox( this, "GroupBox1" );
    GroupBox1->setLineWidth( 2 );
    GroupBox1->setTitle( QString::null );
    GroupBox1->setColumnLayout(0, Qt::Vertical );
    GroupBox1->layout()->setSpacing( 0 );
    GroupBox1->layout()->setMargin( 0 );
    GroupBox1Layout = new QGridLayout( GroupBox1->layout() );
    GroupBox1Layout->setAlignment( Qt::AlignTop );
    GroupBox1Layout->setSpacing( 6 );
    GroupBox1Layout->setMargin( 11 );

    TabWidget3 = new QTabWidget( GroupBox1, "TabWidget3" );
    TabWidget3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7, TabWidget3->sizePolicy().hasHeightForWidth() ) );
    TabWidget3->setAutoMask( FALSE );
    TabWidget3->setTabPosition( QTabWidget::Top );
    TabWidget3->setTabShape( QTabWidget::Rounded );

    tab = new QWidget( TabWidget3, "tab" );
    tabLayout = new QGridLayout( tab ); 
    tabLayout->setSpacing( 6 );
    tabLayout->setMargin( 11 );

    scoringEasy = new QListView( tab, "scoringEasy" );
    scoringEasy->addColumn( i18n( "Name" ) );
    scoringEasy->header()->setClickEnabled( FALSE, scoringEasy->header()->count() - 1 );
    scoringEasy->header()->setResizeEnabled( FALSE, scoringEasy->header()->count() - 1 );
    scoringEasy->addColumn( i18n( "Solved" ) );
    scoringEasy->header()->setClickEnabled( FALSE, scoringEasy->header()->count() - 1 );
    scoringEasy->header()->setResizeEnabled( FALSE, scoringEasy->header()->count() - 1 );
    scoringEasy->addColumn( i18n( "Total Messes" ) );
    scoringEasy->header()->setClickEnabled( FALSE, scoringEasy->header()->count() - 1 );
    scoringEasy->header()->setResizeEnabled( FALSE, scoringEasy->header()->count() - 1 );
    scoringEasy->addColumn( i18n( "Total Guesses" ) );
    scoringEasy->header()->setClickEnabled( FALSE, scoringEasy->header()->count() - 1 );
    scoringEasy->header()->setResizeEnabled( FALSE, scoringEasy->header()->count() - 1 );
	
	 /***** Scoring *****/
   QListViewItem * eItem = 0;
   config->setGroup("Easy_scores");
   for (int i=0; i<=9; ++i)
   {
	readName[i]=config->readEntry(QString("name%1").arg(i),"Anonymous");
	readSolved[i]=config->readEntry(QString("solved%1").arg(i),"0");
	readRounds[i]=config->readEntry(QString("rounds%1").arg(i),"0");
	readTotal[i]=config->readEntry(QString("guesses%1").arg(i),"0");

	eItem = new QListViewItem( scoringEasy, eItem );
	eItem->setText( 0, readName[i]    );
	eItem->setText( 1, readSolved[i]  );
	eItem->setText( 2, readRounds[i] );
	eItem->setText( 3, readTotal[i]     );
   }
		
   scoringEasy->setSorting (4, false); //this makes think the QListView, that there actually IS another column and it sorts by it :)

   tabLayout->addWidget( scoringEasy, 0, 0 );
   TabWidget3->insertTab( tab, i18n( "Easy" ) );

    tab_2 = new QWidget( TabWidget3, "tab_2" );
    tabLayout_2 = new QGridLayout( tab_2 ); 
    tabLayout_2->setSpacing( 6 );
    tabLayout_2->setMargin( 11 );

    scoringMedium = new QListView( tab_2, "scoringMedium" );
    scoringMedium->addColumn( i18n( "Name" ) );
    scoringMedium->header()->setClickEnabled( FALSE, scoringMedium->header()->count() - 1 );
    scoringMedium->header()->setResizeEnabled( FALSE, scoringMedium->header()->count() - 1 );
    scoringMedium->addColumn( i18n( "Solved" ) );
    scoringMedium->header()->setClickEnabled( FALSE, scoringMedium->header()->count() - 1 );
    scoringMedium->header()->setResizeEnabled( FALSE, scoringMedium->header()->count() - 1 );
    scoringMedium->addColumn( i18n( "Total Messes" ) );
    scoringMedium->header()->setClickEnabled( FALSE, scoringMedium->header()->count() - 1 );
    scoringMedium->header()->setResizeEnabled( FALSE, scoringMedium->header()->count() - 1 );
    scoringMedium->addColumn( i18n( "Total Guesses" ) );
    scoringMedium->header()->setClickEnabled( FALSE, scoringMedium->header()->count() - 1 );
    scoringMedium->header()->setResizeEnabled( FALSE, scoringMedium->header()->count() - 1 );

   QListViewItem * mItem = 0;
   config->setGroup("Medium_scores");
   for (int i=0; i<=9; ++i)
   {
	readName[i]=config->readEntry(QString("name%1").arg(i),"Anonymous");
	readSolved[i]=config->readEntry(QString("solved%1").arg(i),"0");
	readRounds[i]=config->readEntry(QString("rounds%1").arg(i),"0");
	readTotal[i]=config->readEntry(QString("guesses%1").arg(i),"0");

	mItem = new QListViewItem( scoringMedium, mItem );
	mItem->setText( 0, readName[i]    );
	mItem->setText( 1, readSolved[i]  );
	mItem->setText( 2, readRounds[i] );
	mItem->setText( 3, readTotal[i]     );
   }

   scoringMedium->setSorting (4, false);

	
    tabLayout_2->addWidget( scoringMedium, 0, 0 );
    TabWidget3->insertTab( tab_2, i18n( "Medium" ) );

    tab_3 = new QWidget( TabWidget3, "tab_3" );
    tabLayout_3 = new QGridLayout( tab_3 ); 
    tabLayout_3->setSpacing( 6 );
    tabLayout_3->setMargin( 11 );

    scoringHard = new QListView( tab_3, "scoringHard" );
    scoringHard->addColumn( i18n( "Name" ) );
    scoringHard->header()->setClickEnabled( FALSE, scoringHard->header()->count() - 1 );
    scoringHard->header()->setResizeEnabled( FALSE, scoringHard->header()->count() - 1 );
    scoringHard->addColumn( i18n( "Solved" ) );
    scoringHard->header()->setClickEnabled( FALSE, scoringHard->header()->count() - 1 );
    scoringHard->header()->setResizeEnabled( FALSE, scoringHard->header()->count() - 1 );
    scoringHard->addColumn( i18n( "Total Messes" ) );
    scoringHard->header()->setClickEnabled( FALSE, scoringHard->header()->count() - 1 );
    scoringHard->header()->setResizeEnabled( FALSE, scoringHard->header()->count() - 1 );
    scoringHard->addColumn( i18n( "Total Guesses" ) );
    scoringHard->header()->setClickEnabled( FALSE, scoringHard->header()->count() - 1 );
    scoringHard->header()->setResizeEnabled( FALSE, scoringHard->header()->count() - 1 );

   QListViewItem * hItem = 0;
   config->setGroup("Hard_scores");
   for (int i=0; i<=9; ++i)
   {
	readName[i]=config->readEntry(QString("name%1").arg(i),"Anonymous");
	readSolved[i]=config->readEntry(QString("solved%1").arg(i),"0");
	readRounds[i]=config->readEntry(QString("rounds%1").arg(i),"0");
	readTotal[i]=config->readEntry(QString("guesses%1").arg(i),"0");
 
	hItem = new QListViewItem( scoringHard, hItem );
	hItem->setText( 0, readName[i]    );
	hItem->setText( 1, readSolved[i]  );
	hItem->setText( 2, readRounds[i] );
	hItem->setText( 3, readTotal[i]     );
   }
   /***** End scoring *****/
	
   scoringHard->setSorting (4, false);

    tabLayout_3->addWidget( scoringHard, 0, 0 );
    TabWidget3->insertTab( tab_3, i18n( "Hard" ) );

    GroupBox1Layout->addWidget( TabWidget3, 0, 0 );

    Layout2 = new QGridLayout; 
    Layout2->setSpacing( 6 );
    Layout2->setMargin( 0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout2->addItem( spacer, 0, 0 );

    closeButton = new KPushButton( KStdGuiItem::close(), GroupBox1, "closeButton" );

    Layout2->addWidget( closeButton, 0, 1 );

    GroupBox1Layout->addLayout( Layout2, 1, 0 );

    HighScoresLayout->addWidget( GroupBox1, 0, 0 );

    // signals and slots connections
    connect( closeButton, SIGNAL( clicked() ), this, SLOT( slot_ok() ) );

}

/*  
 *  Destroys the object and frees any allocated resources
 */
HighScores::~HighScores()
{
    // no need to delete child widgets, Qt does it all for us
}

void HighScores::slot_ok()
{
	close();
}
