//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import java.util.Calendar;
import org.kde.qt.QObject;

/**

 Watch directories and files for changes.
 The watched directories or files don't have to exist yet.
 When a watched directory is changed, i.e. when files therein are
 created or deleted, KDirWatch will emit the signal dirty().
 When a watched, but previously not existing directory gets created,
 KDirWatch will emit the signal created().
 When a watched directory gets deleted, KDirWatch will emit the
 signal deleted(). The directory is still watched for new
 creation.
 When a watched file is changed, i.e. attributes changed or written
 to, KDirWatch will emit the signal dirty().
 Scanning of particular directories or files can be stopped temporarily
 and restarted. The whole class can be stopped and restarted.
 Directories and files can be added/removed from the list in any state.
 The implementation uses the FAM service when available;
 if FAM is not available, the DNOTIFY functionality is used on LINUX.
 As a last resort, a regular polling for change of modification times
 is done; the polling interval is a global config option:
 DirWatch/PollInterval and DirWatch/NFSPollInterval for NFS mounted
 directories.
 See {@link KDirWatchSignals} for signals emitted by KDirWatch
		@author Sven Radej <sven@lisa.exp.univie.ac.at>
  
		@short Class for watching directory and file changes. 
		@see #self

*/
public class KDirWatch extends QObject  {
	protected KDirWatch(Class dummy){super((Class) null);}
	public static final int FAM = 0;
	public static final int DNotify = 1;
	public static final int Stat = 2;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructor.
			 Scanning begins immediately when a dir/file watch
		 is added.
			@param parent the parent of the QObject (or 0 for parent-less KDataTools)
			@param name the name of the QObject, can be 0
		    		@short    Constructor.
	*/
	public KDirWatch(QObject parent, String name) {
		super((Class) null);
		newKDirWatch(parent,name);
	}
	private native void newKDirWatch(QObject parent, String name);
	public KDirWatch(QObject parent) {
		super((Class) null);
		newKDirWatch(parent);
	}
	private native void newKDirWatch(QObject parent);
	public KDirWatch() {
		super((Class) null);
		newKDirWatch();
	}
	private native void newKDirWatch();
	/**	
		 Adds a directory to be watched.
			 The directory does not have to exist. When <code>watchFiles</code> is
		 false (the default), the signals dirty(), created(), deleted()
		 can be emitted, all for the watched directory.
		 When <code>watchFiles</code> is true, all files in the watched directory
		 are watched for changes, too. Thus, the signals dirty(),
		 created(), deleted() can be emitted.
			@param path the path to watch
			@param watchFiles if true, the KDirWatch will also watch files
			@param recursive if true, all sub directories are also watched
		    		@short    Adds a directory to be watched.
	*/
	public native void addDir(String path, boolean watchFiles, boolean recursive);
	public native void addDir(String path, boolean watchFiles);
	public native void addDir(String path);
	/**	
		 Adds a file to be watched.
			@param file the file to watch
		    		@short    Adds a file to be watched.
	*/
	public native void addFile(String file);
	/**	
		 Returns the time the directory/file was last changed.
			@param path the file to check
				@return the date of the last modification
    
		@short    Returns the time the directory/file was last changed.
	*/
	public native Calendar ctime(String path);
	/**	
		 Removes a directory from the list of scanned directories.
			 If specified path is not in the list this does nothing.
			@param path the path of the dir to be removed from the list
		    		@short    Removes a directory from the list of scanned directories.
	*/
	public native void removeDir(String path);
	/**	
		 Removes a file from the list of watched files.
			 If specified path is not in the list this does nothing.
			@param file the file to be removed from the list
		    		@short    Removes a file from the list of watched files.
	*/
	public native void removeFile(String file);
	/**	
		 Stops scanning the specified path.
			 The <code>path</code> is not deleted from the interal just, it is just skipped.
		 Call this function when you perform an huge operation
		 on this directory (copy/move big files or many files). When finished,
		 call restartDirScan(path).
			@param path the path to skip
				@return true if the <code>path</code> is being watched, otherwise false

		@short    Stops scanning the specified path.
		@see #restartDirScanning
	*/
	public native boolean stopDirScan(String path);
	/**	
		 Restarts scanning for specified path.
			 Resets ctime. It doesn't notify
		 the change (by emitted a signal), since the ctime value is reset.
			 Call it when you are finished with big operations on that path,
		 <b>and</b> when <b>you</b> have refreshed that path. 
			@param path the path to restart scanning
				@return true if the <code>path</code> is being watched, otherwise false

		@short    Restarts scanning for specified path.
		@see #stopDirScanning
	*/
	public native boolean restartDirScan(String path);
	/**	
		 Starts scanning of all dirs in list.
			@param notify If true, all changed directories (since 
		 stopScan() call) will be notified for refresh. If notify is
		 false, all ctimes will be reset (except those who are stopped,
		 but only if <code>skippedToo</code> is false) and changed dirs won't be
		 notified. You can start scanning even if the list is
		 empty. First call should be called with <code>false</code> or else all 
		 directories 
		 in list will be notified.  
			@param skippedToo if true, the skipped directoris (scanning of which was
		 stopped with stopDirScan() ) will be reset and notified
		 for change. Otherwise, stopped directories will continue to be
		 unnotified.
		    		@short    Starts scanning of all dirs in list.
	*/
	public native void startScan(boolean notify, boolean skippedToo);
	public native void startScan(boolean notify);
	public native void startScan();
	/**	
		 Stops scanning of all directories in internal list.
			 The timer is stopped, but the list is not cleared.
		    		@short    Stops scanning of all directories in internal list.
	*/
	public native void stopScan();
	/**	
		 Is scanning stopped?
		 After creation of a KDirWatch instance, this is false.
				@return true when scanning stopped
    
		@short    Is scanning stopped?  After creation of a KDirWatch instance, this is false.
	*/
	public native boolean isStopped();
	/**	
		 Check if a directory is being watched by this KDirWatch instance
			@param path the directory to check
				@return true if the directory is being watched
    
		@short    Check if a directory is being watched by this KDirWatch instance
	*/
	public native boolean contains(String path);
	/**	 
		 Emits created().
			@param path the path of the file or directory
		    		@short     Emits created().
	*/
	public native void setCreated(String path);
	/**	 
		 Emits dirty().
			@param path the path of the file or directory
		    		@short     Emits dirty().
	*/
	public native void setDirty(String path);
	/**	 
		 Emits deleted().
			@param path the path of the file or directory
		    		@short     Emits deleted().
	*/
	public native void setDeleted(String path);
	/**	
		 Returns the preferred internal method to
		 watch for changes.
				@short    Returns the preferred internal method to  watch for changes.
	*/
	public native int internalMethod();
	/**	
		 Dump statistic information about all KDirWatch instances.
		 This checks for consistency, too.
		    		@short    Dump statistic information about all KDirWatch instances.
	*/
	public static native void statistics();
	/**	
		 The KDirWatch instance usually globally used in an application.
		 It is automatically deleted when the application exits.
			 However, you can create an arbitrary number of KDirWatch instances
		 aside from this one - for those you have to take care of memory management.
			 This function returns an instance of KDirWatch. If there is none, it
		 will be created.
				@return a KDirWatch instance
    
		@short    The KDirWatch instance usually globally used in an application.
	*/
	public static native KDirWatch self();
	/**	
		 Returns true if there is an instance of KDirWatch.
				@return true if there is an instance of KDirWatch.

		@short    Returns true if there is an instance of KDirWatch.
		@see KDirWatch#self
	*/
	public static native boolean exists();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
